/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.nio.ByteBuffer;
import java.util.Calendar;
import org.openremote.agent.protocol.bluetooth.mesh.IvIndex;
import org.openremote.agent.protocol.bluetooth.mesh.MeshBeacon;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class SecureNetworkBeacon
extends MeshBeacon {
    public static final int BEACON_DATA_LENGTH = 22;
    private final int flags;
    private boolean isKeyRefreshActive;
    private final byte[] networkId = new byte[8];
    private final IvIndex ivIndex;
    private final byte[] authenticationValue = new byte[8];

    public SecureNetworkBeacon(byte[] beaconData) {
        super(beaconData);
        if (beaconData.length != 22) {
            throw new IllegalArgumentException("Incorrect Secure Network Beacon length: " + beaconData.length + ", expected: 22. Check MTU and Proxy Protocol segmentation.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(beaconData);
        byteBuffer.position(1);
        this.flags = byteBuffer.get();
        this.isKeyRefreshActive = (this.flags & 1) == 1;
        boolean isIvUpdateActive = (this.flags & 2) >> 1 == 1;
        byteBuffer.get(this.networkId, 0, 8);
        this.ivIndex = new IvIndex(byteBuffer.getInt(), isIvUpdateActive, Calendar.getInstance());
        byteBuffer.get(this.authenticationValue, 0, 8);
    }

    public String toString() {
        return "SecureNetworkBeacon { KeyRefreshActive: " + this.isKeyRefreshActive + ", IV Index: " + this.ivIndex + ", Authentication Value: " + MeshParserUtils.bytesToHex(this.authenticationValue, true) + "}";
    }

    @Override
    public int getBeaconType() {
        return this.beaconType;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isKeyRefreshActive() {
        return this.isKeyRefreshActive;
    }

    public byte[] getNetworkId() {
        return this.networkId;
    }

    public IvIndex getIvIndex() {
        return this.ivIndex;
    }

    public byte[] getAuthenticationValue() {
        return this.authenticationValue;
    }

    protected boolean canOverwrite(IvIndex ivIndex, Calendar updatedAt, boolean ivRecoveryActive, boolean isTestMode, boolean ivRecoveryOver42Allowed) {
        if (this.ivIndex.getIvIndex() > ivIndex.getIvIndex() && (ivRecoveryOver42Allowed || this.ivIndex.getIvIndex() <= ivIndex.getIvIndex() + 42) || this.ivIndex.getIvIndex() == ivIndex.getIvIndex() && (ivIndex.isIvUpdateActive() || !this.ivIndex.isIvUpdateActive())) {
            return this.isMinimumTimeRequirementCompleted(ivIndex, updatedAt, ivRecoveryActive, isTestMode);
        }
        return false;
    }

    private boolean isMinimumTimeRequirementCompleted(IvIndex ivIndex, Calendar updatedAt, boolean isIvRecoveryActive, boolean isTestMode) {
        int stateDiff = (this.ivIndex.getIvIndex() - ivIndex.getIvIndex()) * 2 - 1 + (ivIndex.isIvUpdateActive() ? 1 : 0) + (this.ivIndex.isIvUpdateActive() ? 0 : 1) - (isIvRecoveryActive || isTestMode ? 1 : 0);
        int numberOfHoursRequired = stateDiff * 96;
        long timeDifference = Calendar.getInstance().getTimeInMillis() - updatedAt.getTimeInMillis();
        int numberOfHoursSinceDate = (int)(timeDifference / 3600000L);
        if (isIvRecoveryActive && stateDiff > 1 && numberOfHoursSinceDate < 192) {
            return false;
        }
        return numberOfHoursSinceDate >= numberOfHoursRequired;
    }
}

