/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class Scene {
    private final String meshUuid;
    private String name = "nRF Scene";
    protected List<Integer> addresses = new ArrayList<Integer>();
    private int number;

    public Scene(int number, String meshUuid) {
        this.number = number;
        this.meshUuid = meshUuid;
    }

    public Scene(int number, List<Integer> addresses, String meshUuid) {
        this.number = number;
        this.addresses.addAll(addresses);
        this.meshUuid = meshUuid;
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Integer> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public void setAddresses(List<Integer> addresses) {
        this.addresses.clear();
        this.addresses.addAll(addresses);
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public static boolean isValidSceneNumber(int sceneNumber) {
        if (sceneNumber > 0 && sceneNumber <= 65535) {
            return true;
        }
        throw new IllegalArgumentException("Scene number must range from 0x0001 to 0xFFFF!");
    }

    public static String formatSceneNumber(int number, boolean add0x) {
        return add0x ? "0x" + String.format(Locale.US, "%04X", number) : String.format(Locale.US, "%04X", number);
    }

    public String toString() {
        return "Scene{meshUuid='" + this.meshUuid + "', name='" + this.name + "', addresses=" + this.addresses + ", number=" + this.number + "}";
    }
}

