/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.List;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedGroupRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedSceneRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedUnicastRange;

public abstract class Range {
    protected int lowerBound;
    protected int upperBound;

    public abstract int getLowerBound();

    public abstract int getUpperBound();

    public abstract boolean overlaps(Range var1);

    public abstract int range();

    protected boolean overlaps(int rLow, int rHigh, int oLow, int oHigh) {
        if (rLow == oLow && rHigh == oHigh) {
            return true;
        }
        if (rLow < oLow && rHigh > oHigh) {
            return true;
        }
        if (rLow > oLow && rHigh < oHigh) {
            return true;
        }
        if (rLow <= oLow && rHigh >= oLow && rHigh <= oHigh) {
            return true;
        }
        return rHigh >= oHigh && rLow >= oLow && rLow <= oHigh;
    }

    public static List<AllocatedUnicastRange> mergeUnicastRanges(List<AllocatedUnicastRange> ranges) {
        AllocatedUnicastRange accumulator = new AllocatedUnicastRange();
        ArrayList<AllocatedUnicastRange> result = new ArrayList<AllocatedUnicastRange>();
        for (AllocatedUnicastRange range : ranges) {
            if (accumulator.getLowAddress() == 0 && accumulator.getHighAddress() == 0) {
                accumulator = range;
            }
            if (accumulator.getHighAddress() >= range.getHighAddress()) continue;
            if (accumulator.getHighAddress() + 1 >= range.getLowAddress()) {
                accumulator = new AllocatedUnicastRange(accumulator.getLowAddress(), range.getHighAddress());
                continue;
            }
            result.add(accumulator);
            accumulator = range;
        }
        if (accumulator.getLowAddress() != 0 && accumulator.getHighAddress() != 0) {
            result.add(accumulator);
        }
        return result;
    }

    public static List<AllocatedGroupRange> mergeGroupRanges(List<AllocatedGroupRange> ranges) {
        AllocatedGroupRange accumulator = new AllocatedGroupRange();
        ArrayList<AllocatedGroupRange> results = new ArrayList<AllocatedGroupRange>();
        for (AllocatedGroupRange range : ranges) {
            if (accumulator.getLowAddress() == 0 && accumulator.getHighAddress() == 0) {
                accumulator = range;
            }
            if (accumulator.getHighAddress() >= range.getHighAddress()) continue;
            if (accumulator.getHighAddress() + 1 >= range.getLowAddress()) {
                accumulator = new AllocatedGroupRange(accumulator.getLowAddress(), range.getHighAddress());
                continue;
            }
            results.add(accumulator);
            accumulator = range;
        }
        if (accumulator.getLowAddress() != 0 && accumulator.getHighAddress() != 0) {
            results.add(accumulator);
        }
        return results;
    }

    public static List<AllocatedSceneRange> mergeSceneRanges(List<AllocatedSceneRange> ranges) {
        AllocatedSceneRange accumulator = new AllocatedSceneRange();
        ArrayList<AllocatedSceneRange> result = new ArrayList<AllocatedSceneRange>();
        for (AllocatedSceneRange range : ranges) {
            if (accumulator.getFirstScene() == 0 && accumulator.getLastScene() == 0) {
                accumulator = range;
            }
            if (accumulator.getLastScene() >= range.getLastScene()) continue;
            if (accumulator.getLastScene() + 1 >= range.getFirstScene()) {
                accumulator = new AllocatedSceneRange(accumulator.getFirstScene(), range.getLastScene());
                continue;
            }
            result.add(accumulator);
            accumulator = range;
        }
        if (accumulator.getFirstScene() != 0 && accumulator.getLastScene() != 0) {
            result.add(accumulator);
        }
        return result;
    }
}

