/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.openremote.agent.protocol.bluetooth.mesh.AddressRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedGroupRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedSceneRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedUnicastRange;
import org.openremote.agent.protocol.bluetooth.mesh.Range;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class Provisioner {
    private String meshUuid;
    private String provisionerUuid;
    private String provisionerName = "nRF Mesh Provisioner";
    List<AllocatedUnicastRange> allocatedUnicastRanges = new ArrayList<AllocatedUnicastRange>();
    List<AllocatedGroupRange> allocatedGroupRanges = new ArrayList<AllocatedGroupRange>();
    List<AllocatedSceneRange> allocatedSceneRanges = new ArrayList<AllocatedSceneRange>();
    private Integer provisionerAddress = null;
    private int globalTtl = 5;
    private boolean lastSelected;
    private final Comparator<AddressRange> addressRangeComparator = (addressRange1, addressRange2) -> Integer.compare(addressRange1.getLowAddress(), addressRange2.getLowAddress());
    private final Comparator<AllocatedSceneRange> sceneRangeComparator = (sceneRange1, sceneRange2) -> Integer.compare(sceneRange1.getFirstScene(), sceneRange2.getFirstScene());

    public Provisioner(String provisionerUuid, List<AllocatedUnicastRange> allocatedUnicastRanges, List<AllocatedGroupRange> allocatedGroupRanges, List<AllocatedSceneRange> allocatedSceneRanges, String meshUuid) {
        this.provisionerUuid = provisionerUuid.toUpperCase(Locale.US);
        this.allocatedUnicastRanges = allocatedUnicastRanges;
        this.allocatedGroupRanges = allocatedGroupRanges;
        this.allocatedSceneRanges = allocatedSceneRanges;
        this.meshUuid = meshUuid;
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public void setMeshUuid(String uuid) {
        this.meshUuid = uuid;
    }

    public String getProvisionerName() {
        return this.provisionerName;
    }

    public void setProvisionerName(String provisionerName) throws IllegalArgumentException {
        if (provisionerName == null || provisionerName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        this.provisionerName = provisionerName;
    }

    public String getProvisionerUuid() {
        return this.provisionerUuid;
    }

    public void setProvisionerUuid(String provisionerUuid) {
        this.provisionerUuid = provisionerUuid;
    }

    public List<AllocatedGroupRange> getAllocatedGroupRanges() {
        return Collections.unmodifiableList(this.allocatedGroupRanges);
    }

    public void setAllocatedGroupRanges(List<AllocatedGroupRange> allocatedGroupRanges) {
        this.allocatedGroupRanges = allocatedGroupRanges;
    }

    public List<AllocatedUnicastRange> getAllocatedUnicastRanges() {
        return Collections.unmodifiableList(this.allocatedUnicastRanges);
    }

    public void setAllocatedUnicastRanges(List<AllocatedUnicastRange> allocatedUnicastRanges) {
        this.allocatedUnicastRanges = allocatedUnicastRanges;
    }

    public List<AllocatedSceneRange> getAllocatedSceneRanges() {
        return Collections.unmodifiableList(this.allocatedSceneRanges);
    }

    public void setAllocatedSceneRanges(List<AllocatedSceneRange> allocatedSceneRanges) {
        this.allocatedSceneRanges = allocatedSceneRanges;
    }

    public Integer getProvisionerAddress() {
        return this.provisionerAddress;
    }

    public void setProvisionerAddress(Integer address) throws IllegalArgumentException {
        if (address != null && !MeshAddress.isValidUnicastAddress(address)) {
            throw new IllegalArgumentException("Unicast address must range between 0x0001 to 0x7FFF.");
        }
        this.provisionerAddress = address;
    }

    public boolean assignProvisionerAddress(Integer address) throws IllegalArgumentException {
        if (address != null && !MeshAddress.isValidUnicastAddress(address)) {
            throw new IllegalArgumentException("Unicast address must range between 0x0001 to 0x7FFF.");
        }
        if (this.isAddressWithinAllocatedRange(address)) {
            this.provisionerAddress = address;
            return true;
        }
        throw new IllegalArgumentException("Address must be within the allocated address range.");
    }

    public int getGlobalTtl() {
        return this.globalTtl;
    }

    public boolean supportsConfiguration() {
        return this.provisionerAddress != null;
    }

    public void setGlobalTtl(int ttl) throws IllegalArgumentException {
        if (!MeshParserUtils.isValidTtl(ttl)) {
            throw new IllegalArgumentException("Invalid ttl, ttl must range from 0 - 127");
        }
        this.globalTtl = ttl;
    }

    public boolean isLastSelected() {
        return this.lastSelected;
    }

    public void setLastSelected(boolean lastSelected) {
        this.lastSelected = lastSelected;
    }

    public boolean addRange(Range allocatedRange) {
        if (allocatedRange instanceof AllocatedUnicastRange) {
            this.allocatedUnicastRanges.add((AllocatedUnicastRange)allocatedRange);
            ArrayList<AllocatedUnicastRange> ranges = new ArrayList<AllocatedUnicastRange>(this.allocatedUnicastRanges);
            Collections.sort(ranges, this.addressRangeComparator);
            this.allocatedUnicastRanges.clear();
            this.allocatedUnicastRanges.addAll(Range.mergeUnicastRanges(ranges));
            return true;
        }
        if (allocatedRange instanceof AllocatedGroupRange) {
            this.allocatedGroupRanges.add((AllocatedGroupRange)allocatedRange);
            ArrayList<AllocatedGroupRange> ranges = new ArrayList<AllocatedGroupRange>(this.allocatedGroupRanges);
            Collections.sort(ranges, this.addressRangeComparator);
            this.allocatedGroupRanges.clear();
            this.allocatedGroupRanges.addAll(Range.mergeGroupRanges(ranges));
            return true;
        }
        if (allocatedRange instanceof AllocatedSceneRange) {
            this.allocatedSceneRanges.add((AllocatedSceneRange)allocatedRange);
            ArrayList<AllocatedSceneRange> ranges = new ArrayList<AllocatedSceneRange>(this.allocatedSceneRanges);
            Collections.sort(this.allocatedSceneRanges, this.sceneRangeComparator);
            this.allocatedSceneRanges.clear();
            this.allocatedSceneRanges.addAll(Range.mergeSceneRanges(ranges));
            return true;
        }
        return false;
    }

    public boolean removeRange(Range range) {
        if (range instanceof AllocatedUnicastRange) {
            return this.allocatedUnicastRanges.remove(range);
        }
        if (range instanceof AllocatedGroupRange) {
            return this.allocatedGroupRanges.remove(range);
        }
        if (range instanceof AllocatedSceneRange) {
            return this.allocatedSceneRanges.remove(range);
        }
        return false;
    }

    boolean isAddressWithinAllocatedRange(Integer address) throws IllegalArgumentException {
        if (address == null) {
            return true;
        }
        if (!MeshAddress.isValidUnicastAddress(address)) {
            throw new IllegalArgumentException("Unicast address must range from 0x0001 - 0x7FFF");
        }
        for (AllocatedUnicastRange range : this.allocatedUnicastRanges) {
            if (address < range.getLowAddress() || address > range.getHighAddress()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOverlappingUnicastRanges(List<AllocatedUnicastRange> otherRanges) {
        for (AllocatedUnicastRange range : this.allocatedUnicastRanges) {
            for (AllocatedUnicastRange other : otherRanges) {
                if (!range.overlaps(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOverlappingGroupRanges(List<AllocatedGroupRange> otherRanges) {
        for (AllocatedGroupRange range : this.allocatedGroupRanges) {
            for (AllocatedGroupRange other : otherRanges) {
                if (!range.overlaps(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOverlappingSceneRanges(List<AllocatedSceneRange> otherRanges) {
        for (AllocatedSceneRange range : this.allocatedSceneRanges) {
            for (AllocatedSceneRange other : otherRanges) {
                if (!range.overlaps(other)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isNodeAddressInUse(List<ProvisionedMeshNode> nodes) {
        if (this.provisionerAddress == null) {
            return false;
        }
        for (ProvisionedMeshNode node : nodes) {
            if (node.getUuid().equalsIgnoreCase(this.provisionerUuid) || node.getUnicastAddress() != this.provisionerAddress.intValue()) continue;
            return true;
        }
        return false;
    }
}

