/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import javax.validation.constraints.NotNull;
import org.openremote.agent.protocol.bluetooth.mesh.MeshKey;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public final class NetworkKey
extends MeshKey {
    public static final int NORMAL_OPERATION = 0;
    public static final int KEY_DISTRIBUTION = 1;
    public static final int USING_NEW_KEYS = 2;
    public static final int USE_NEW_KEYS = 2;
    public static final int REVOKE_OLD_KEYS = 3;
    private int phase = 0;
    private boolean minSecurity;
    private long timestamp;
    private byte[] identityKey;
    private byte[] oldIdentityKey;
    private SecureUtils.K2Output derivatives;
    private SecureUtils.K2Output oldDerivatives;

    public NetworkKey(int keyIndex, @NotNull byte[] key) {
        super(keyIndex, key);
        this.name = "Network Key " + (keyIndex + 1);
        this.identityKey = SecureUtils.calculateIdentityKey(key);
        this.derivatives = SecureUtils.calculateK2(key, SecureUtils.K2_MASTER_INPUT);
        this.timestamp = System.currentTimeMillis();
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public void setKey(@NotNull byte[] key) {
        super.setKey(key);
        this.identityKey = SecureUtils.calculateIdentityKey(key);
        this.derivatives = SecureUtils.calculateK2(key, SecureUtils.K2_MASTER_INPUT);
    }

    @Override
    public void setOldKey(byte[] oldKey) {
        super.setOldKey(oldKey);
        this.oldIdentityKey = SecureUtils.calculateIdentityKey(oldKey);
        this.oldDerivatives = SecureUtils.calculateK2(oldKey, SecureUtils.K2_MASTER_INPUT);
    }

    public byte[] getTxNetworkKey() {
        switch (this.phase) {
            case 1: {
                return this.oldKey;
            }
        }
        return this.key;
    }

    public SecureUtils.K2Output getTxDerivatives() {
        switch (this.phase) {
            case 1: {
                return this.oldDerivatives;
            }
        }
        return this.derivatives;
    }

    public boolean isMinSecurity() {
        return this.minSecurity;
    }

    public void setMinSecurity(boolean minSecurity) {
        this.minSecurity = minSecurity;
    }

    public byte[] getIdentityKey() {
        return this.identityKey;
    }

    public byte[] getOldIdentityKey() {
        return this.oldIdentityKey;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getPhaseDescription() {
        switch (this.phase) {
            default: {
                return "Normal Operation";
            }
            case 1: {
                return "Key Distribution";
            }
            case 2: 
        }
        return "Using New Keys";
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public NetworkKey clone() throws CloneNotSupportedException {
        return (NetworkKey)super.clone();
    }

    @Override
    protected boolean distributeKey(@NotNull byte[] newKey) throws IllegalArgumentException {
        if (this.valid(newKey)) {
            if (this.phase == 0 || this.phase == 1) {
                this.phase = 1;
                this.timestamp = System.currentTimeMillis();
                return super.distributeKey(newKey);
            }
            throw new IllegalArgumentException("A NetworkKey can only be updated once during a Key Refresh Procedure.");
        }
        return false;
    }

    protected boolean switchToNewKey() {
        if (this.phase == 1) {
            this.setPhase(2);
            this.timestamp = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    protected boolean revokeOldKey() {
        if (this.phase == 1 || this.phase == 2) {
            this.phase = 0;
            this.timestamp = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    protected byte[] getNetworkId() {
        return SecureUtils.calculateK3(this.key);
    }

    protected byte[] getOldNetworkId() {
        return SecureUtils.calculateK3(this.oldKey);
    }

    public SecureUtils.K2Output getDerivatives() {
        return this.derivatives;
    }

    public SecureUtils.K2Output getOldDerivatives() {
        return this.oldDerivatives;
    }
}

