/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedUnicastRange;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.BaseMeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.Group;
import org.openremote.agent.protocol.bluetooth.mesh.IvIndex;
import org.openremote.agent.protocol.bluetooth.mesh.MeshNetworkCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.Provisioner;
import org.openremote.agent.protocol.bluetooth.mesh.Scene;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Element;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

public class MeshNetwork
extends BaseMeshNetwork {
    public MeshNetwork(String meshUUID) {
        super(meshUUID);
    }

    synchronized void setCallbacks(MeshNetworkCallbacks mCallbacks) {
        this.mCallbacks = mCallbacks;
    }

    public synchronized void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public synchronized List<Scene> getScenes() {
        return Collections.unmodifiableList(this.scenes);
    }

    public synchronized Group getGroup(int address) {
        for (Group group : this.groups) {
            if (address != group.getAddress()) continue;
            return group;
        }
        return null;
    }

    public synchronized List<Group> getGroups() {
        return this.groups;
    }

    public synchronized String getMeshUUID() {
        return this.meshUUID;
    }

    synchronized void setNetKeys(List<NetworkKey> netKeys) {
        this.netKeys = netKeys;
    }

    public synchronized List<NetworkKey> getNetKeys() {
        return Collections.unmodifiableList(this.netKeys);
    }

    public synchronized NetworkKey getPrimaryNetworkKey() {
        for (NetworkKey networkKey : this.netKeys) {
            if (networkKey.getKeyIndex() != 0) continue;
            return networkKey;
        }
        return null;
    }

    public synchronized List<ApplicationKey> getAppKeys() {
        return Collections.unmodifiableList(this.appKeys);
    }

    public synchronized IvIndex getIvIndex() {
        return this.ivIndex;
    }

    public synchronized String getSchema() {
        return this.schema;
    }

    public synchronized String getId() {
        return this.id;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    public synchronized String getMeshName() {
        return this.meshName;
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void setPartial(boolean partial) {
        this.partial = partial;
    }

    public synchronized void setLastSelected(boolean lastSelected) {
        this.lastSelected = lastSelected;
    }

    public synchronized Scene getScene(int number) {
        for (Scene scene : this.scenes) {
            if (number != scene.getNumber()) continue;
            return scene;
        }
        return null;
    }

    public synchronized UUID getLabelUuid(int address) throws IllegalArgumentException {
        if (!MeshAddress.isValidVirtualAddress(address)) {
            throw new IllegalArgumentException("Address type must be a virtual address ");
        }
        for (ProvisionedMeshNode node : this.nodes) {
            for (Map.Entry<Integer, Element> elementEntry : node.getElements().entrySet()) {
                Element element = elementEntry.getValue();
                for (Map.Entry<Integer, MeshModel> modelEntry : element.getMeshModels().entrySet()) {
                    MeshModel model = modelEntry.getValue();
                    if (model == null) continue;
                    if (model.getPublicationSettings() != null && model.getPublicationSettings().getLabelUUID() != null && address == MeshAddress.generateVirtualAddress(model.getPublicationSettings().getLabelUUID())) {
                        return model.getPublicationSettings().getLabelUUID();
                    }
                    UUID label = model.getLabelUUID(address);
                    if (label == null) continue;
                    return label;
                }
            }
        }
        return null;
    }

    public synchronized int nextAvailableUnicastAddress(int elementCount, Provisioner provisioner) throws IllegalArgumentException {
        if (provisioner.getAllocatedUnicastRanges().isEmpty()) {
            throw new IllegalArgumentException("Please allocate a unicast address range to the provisioner");
        }
        ArrayList<Integer> usedAddresses = new ArrayList<Integer>();
        for (ProvisionedMeshNode node : this.nodes) {
            usedAddresses.addAll(node.getElements().keySet());
        }
        if (this.networkExclusions.get(this.ivIndex.getIvIndex()) != null) {
            usedAddresses.addAll((Collection)this.networkExclusions.get(this.ivIndex.getIvIndex()));
        }
        if (this.networkExclusions.get(this.ivIndex.getIvIndex() - 1) != null) {
            usedAddresses.addAll((Collection)this.networkExclusions.get(this.ivIndex.getIvIndex() - 1));
        }
        Collections.sort(usedAddresses);
        boolean index = false;
        for (AllocatedUnicastRange range : provisioner.getAllocatedUnicastRanges()) {
            int address = range.getLowAddress();
            Iterator iterator = usedAddresses.iterator();
            while (iterator.hasNext()) {
                int usedAddress = (Integer)iterator.next();
                if (address > usedAddress) continue;
                if (usedAddress > address + (elementCount - 1)) {
                    return address;
                }
                address = usedAddress + 1;
                if (range.highAddress >= address + (elementCount - 1)) continue;
                break;
            }
            if (range.getHighAddress() < address + (elementCount - 1)) continue;
            return address;
        }
        return -1;
    }
}

