/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.nio.ByteBuffer;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedGroupRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedSceneRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedUnicastRange;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.Group;
import org.openremote.agent.protocol.bluetooth.mesh.InternalMeshManagerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.InternalTransportCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.IvIndex;
import org.openremote.agent.protocol.bluetooth.mesh.MeshManagerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshMessageHandler;
import org.openremote.agent.protocol.bluetooth.mesh.MeshMngrApi;
import org.openremote.agent.protocol.bluetooth.mesh.MeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.MeshNetworkCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshProvisioningHandler;
import org.openremote.agent.protocol.bluetooth.mesh.MeshStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.Provisioner;
import org.openremote.agent.protocol.bluetooth.mesh.Scene;
import org.openremote.agent.protocol.bluetooth.mesh.SecureNetworkBeacon;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.NetworkLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.transport.UpperTransportLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ExtendedInvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ProxyFilter;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class MeshManagerApi
implements MeshMngrApi {
    public static final Logger LOG = Logger.getLogger(MeshManagerApi.class.getName());
    public static final UUID MESH_PROVISIONING_UUID = UUID.fromString("00001827-0000-1000-8000-00805F9B34FB");
    public static final UUID MESH_PROXY_UUID = UUID.fromString("00001828-0000-1000-8000-00805F9B34FB");
    public static final byte PDU_TYPE_PROVISIONING = 3;
    private static final long PROXY_SAR_TRANSFER_TIME_OUT = 20000L;
    public static final byte PDU_TYPE_NETWORK = 0;
    public static final byte PDU_TYPE_MESH_BEACON = 1;
    public static final byte PDU_TYPE_PROXY_CONFIGURATION = 2;
    private static final byte GATT_SAR_COMPLETE = 0;
    private static final byte GATT_SAR_START = 1;
    private static final byte GATT_SAR_CONTINUATION = 2;
    private static final byte GATT_SAR_END = 3;
    private static final int GATT_SAR_MASK = 192;
    private static final int GATT_SAR_UNMASK = 63;
    private static final int SAR_BIT_OFFSET = 6;
    private boolean ivUpdateTestModeActive = false;
    private boolean allowIvIndexRecoveryOver42 = false;
    private MeshNetwork mMeshNetwork;
    private MeshManagerCallbacks mMeshManagerCallbacks;
    private final MeshMessageHandler mMeshMessageHandler;
    private final MeshProvisioningHandler mMeshProvisioningHandler;
    private byte[] mOutgoingBuffer;
    private int mOutgoingBufferOffset;
    private byte[] mIncomingBuffer;
    private int mIncomingBufferOffset;
    private final ScheduledExecutorService executorService;
    private final Runnable mProxyProtocolTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            MeshManagerApi.this.mMeshMessageHandler.onIncompleteTimerExpired(0);
        }
    };
    private ScheduledFuture<?> scheduledFuture;
    private final MeshNetworkCallbacks callbacks = new MeshNetworkCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMeshNetworkUpdated() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshNetwork.setTimestamp(System.currentTimeMillis());
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNetworkKeyAdded(NetworkKey networkKey) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNetworkKeyUpdated(NetworkKey networkKey) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNetworkKeyDeleted(NetworkKey networkKey) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onApplicationKeyAdded(ApplicationKey applicationKey) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onApplicationKeyUpdated(ApplicationKey applicationKey) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onApplicationKeyDeleted(ApplicationKey applicationKey) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProvisionerAdded(Provisioner provisioner) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProvisionerUpdated(Provisioner provisioner) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProvisionersUpdated(List<Provisioner> provisioners) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProvisionerDeleted(Provisioner provisioner) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        @Override
        public void onNodeDeleted(ProvisionedMeshNode meshNode) {
            MeshManagerApi.this.deleteNode(meshNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNodeAdded(ProvisionedMeshNode meshNode) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNodeUpdated(ProvisionedMeshNode meshNode) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNodesUpdated() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGroupAdded(Group group) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGroupUpdated(Group group) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGroupDeleted(Group group) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSceneAdded(Scene scene) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSceneUpdated(Scene scene) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSceneDeleted(Scene scene) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }
    };
    private final InternalMeshManagerCallbacks internalMeshMgrCallbacks = new InternalMeshManagerCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNodeProvisioned(ProvisionedMeshNode meshNode) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                this.updateProvisionedNodeList(meshNode);
                MeshManagerApi.this.mMeshNetwork.sequenceNumbers.put(meshNode.getUnicastAddress(), meshNode.getSequenceNumber());
                MeshManagerApi.this.mMeshNetwork.unicastAddress = MeshManagerApi.this.mMeshNetwork.nextAvailableUnicastAddress(meshNode.getNumberOfElements(), MeshManagerApi.this.mMeshNetwork.getSelectedProvisioner());
                meshNode.setMeshUuid(MeshManagerApi.this.mMeshNetwork.getMeshUUID());
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }

        private void updateProvisionedNodeList(ProvisionedMeshNode meshNode) {
            for (int i = 0; i < MeshManagerApi.this.mMeshNetwork.nodes.size(); ++i) {
                ProvisionedMeshNode node = (ProvisionedMeshNode)MeshManagerApi.this.mMeshNetwork.nodes.get(i);
                if (!meshNode.getUuid().equals(node.getUuid())) continue;
                MeshManagerApi.this.mMeshNetwork.nodes.remove(i);
                break;
            }
            MeshManagerApi.this.mMeshNetwork.nodes.add(meshNode);
        }
    };
    private final NetworkLayerCallbacks networkLayerCallbacks = new NetworkLayerCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Provisioner getProvisioner() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getSelectedProvisioner();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Provisioner getProvisioner(int unicastAddress) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                for (Provisioner provisioner : MeshManagerApi.this.mMeshNetwork.getProvisioners()) {
                    if (!provisioner.isLastSelected()) continue;
                    return provisioner;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetworkKey getPrimaryNetworkKey() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getPrimaryNetworkKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetworkKey getNetworkKey(int keyIndex) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getNetKey(keyIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<NetworkKey> getNetworkKeys() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getNetKeys();
            }
        }
    };
    private final UpperTransportLayerCallbacks upperTransportLayerCallbacks = new UpperTransportLayerCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProvisionedMeshNode getNode(int unicastAddress) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getNode(unicastAddress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getIvIndex() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                int ivIndex = MeshManagerApi.this.mMeshNetwork.getIvIndex().getTransmitIvIndex();
                return ByteBuffer.allocate(4).putInt(ivIndex).array();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getApplicationKey(int aid) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                for (ApplicationKey key : MeshManagerApi.this.mMeshNetwork.getAppKeys()) {
                    byte[] k = key.getKey();
                    if (aid != SecureUtils.calculateK4(k)) continue;
                    return key.getKey();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ApplicationKey> getApplicationKeys(int boundNetKeyIndex) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                ArrayList<ApplicationKey> keys = new ArrayList<ApplicationKey>();
                for (ApplicationKey key : MeshManagerApi.this.mMeshNetwork.getAppKeys()) {
                    if (key.getBoundNetKeyIndex() != boundNetKeyIndex) continue;
                    keys.add(key);
                }
                return keys;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Group> gerVirtualGroups() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getGroups();
            }
        }
    };
    private final InternalTransportCallbacks internalTransportCallbacks = new InternalTransportCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ApplicationKey> getApplicationKeys(int boundNetKeyIndex) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getAppKeys(boundNetKeyIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProvisionedMeshNode getNode(int unicast) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getNode(unicast);
            }
        }

        @Override
        public Provisioner getProvisioner(int unicast) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendProvisioningPdu(UnprovisionedMeshNode meshNode, byte[] pdu) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                int mtu = MeshManagerApi.this.mMeshManagerCallbacks.getMtu();
                MeshManagerApi.this.mMeshManagerCallbacks.sendProvisioningPdu(meshNode, MeshManagerApi.this.applySegmentation(mtu, pdu));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMeshPduCreated(int dst, byte[] pdu) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                ProvisionedMeshNode meshNode = MeshManagerApi.this.mMeshNetwork.getNode(dst);
                this.updateNetwork(meshNode);
                int mtu = MeshManagerApi.this.mMeshManagerCallbacks.getMtu();
                MeshManagerApi.this.mMeshManagerCallbacks.onMeshPduCreated(MeshManagerApi.this.applySegmentation(mtu, pdu));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProxyFilter getProxyFilter() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork.getProxyFilter();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProxyFilter(ProxyFilter filter) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                MeshManagerApi.this.mMeshNetwork.setProxyFilter(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateMeshNetwork(MeshMessage message) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                ProvisionedMeshNode meshNode = MeshManagerApi.this.mMeshNetwork.getNode(message.getSrc());
                this.updateNetwork(meshNode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMeshNodeReset(ProvisionedMeshNode meshNode) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                if (meshNode != null && MeshManagerApi.this.mMeshNetwork.deleteNode(meshNode)) {
                    MeshManagerApi.this.deleteNode(meshNode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MeshNetwork getMeshNetwork() {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                return MeshManagerApi.this.mMeshNetwork;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void storeScene(int address, int currentScene, List<Integer> scenes) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                Scene scene = MeshManagerApi.this.mMeshNetwork.getScene(currentScene);
                if (scene != null && !scene.getAddresses().contains(address)) {
                    scene.addresses.add(address);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteScene(int address, int currentScene, List<Integer> scenes) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                Scene scene = MeshManagerApi.this.mMeshNetwork.getScene(currentScene);
                if (scene != null && scene.getAddresses().contains(address)) {
                    scene.addresses.remove((Object)address);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateNetwork(ProvisionedMeshNode meshNode) {
            MeshManagerApi meshManagerApi = MeshManagerApi.this;
            synchronized (meshManagerApi) {
                if (meshNode != null) {
                    for (int i = 0; i < MeshManagerApi.this.mMeshNetwork.nodes.size(); ++i) {
                        if (meshNode.getUnicastAddress() != ((ProvisionedMeshNode)MeshManagerApi.this.mMeshNetwork.nodes.get(i)).getUnicastAddress()) continue;
                        MeshManagerApi.this.mMeshNetwork.nodes.set(i, meshNode);
                        break;
                    }
                }
                MeshManagerApi.this.mMeshNetwork.setTimestamp(System.currentTimeMillis());
                MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
            }
        }
    };

    public MeshManagerApi(ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.mMeshProvisioningHandler = new MeshProvisioningHandler(this.internalTransportCallbacks, this.internalMeshMgrCallbacks);
        this.mMeshMessageHandler = new MeshMessageHandler(this.internalTransportCallbacks, this.networkLayerCallbacks, this.upperTransportLayerCallbacks);
        this.initBouncyCastle();
    }

    @Override
    public synchronized void setMeshManagerCallbacks(MeshManagerCallbacks callbacks) {
        this.mMeshManagerCallbacks = callbacks;
    }

    @Override
    public void setMeshStatusCallbacks(MeshStatusCallbacks callbacks) {
        this.mMeshMessageHandler.setMeshStatusCallbacks(callbacks);
    }

    @Override
    public final synchronized void handleWriteCallbacks(int mtuSize, byte[] data) {
        byte[] unsegmentedPdu;
        if (!this.shouldWaitForMoreData(data)) {
            unsegmentedPdu = data;
        } else {
            byte[] combinedPdu = this.appendWritePdu(mtuSize, data);
            if (combinedPdu == null) {
                return;
            }
            unsegmentedPdu = this.removeSegmentation(mtuSize, combinedPdu);
        }
        this.handleWriteCallbacks(unsegmentedPdu);
    }

    @Override
    public final synchronized void handleNotifications(int mtuSize, byte[] data) {
        byte[] unsegmentedPdu;
        if (!this.shouldWaitForMoreData(data)) {
            unsegmentedPdu = data;
        } else {
            byte[] combinedPdu = this.appendPdu(mtuSize, data);
            if (combinedPdu == null) {
                this.toggleProxyProtocolSarTimeOut(data);
                return;
            }
            this.toggleProxyProtocolSarTimeOut(data);
            unsegmentedPdu = this.removeSegmentation(mtuSize, combinedPdu);
        }
        this.parseNotifications(unsegmentedPdu);
    }

    public String dataAsHexString(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            builder.append(String.format("0x%02X%s", data[i] & 0xFF, i == data.length - 1 ? "" : ", "));
        }
        return builder.toString();
    }

    public synchronized MeshNetwork getMeshNetwork() {
        return this.mMeshNetwork;
    }

    private void toggleProxyProtocolSarTimeOut(byte[] data) {
        int pduType = MeshParserUtils.unsignedByteToInt(data[0]);
        if (pduType == 66) {
            this.scheduleTimeoutHandler();
        } else if (pduType == 194) {
            this.cancelTimeoutHandler();
        }
    }

    private void scheduleTimeoutHandler() {
        this.cancelTimeoutHandler();
        this.scheduledFuture = this.executorService.schedule(this.mProxyProtocolTimeoutRunnable, 20000L, TimeUnit.MILLISECONDS);
    }

    private void cancelTimeoutHandler() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.scheduledFuture = null;
    }

    private void parseNotifications(byte[] unsegmentedPdu) {
        try {
            switch (unsegmentedPdu[0]) {
                case 0: {
                    LOG.info("Received network pdu: " + MeshParserUtils.bytesToHex(unsegmentedPdu, true));
                    this.mMeshMessageHandler.parseMeshPduNotifications(unsegmentedPdu, this.mMeshNetwork);
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.mMeshNetwork.getNetKeys().size(); ++i) {
                        NetworkKey networkKey = this.mMeshNetwork.getNetKeys().get(i);
                        byte[] receivedBeaconData = new byte[unsegmentedPdu.length - 1];
                        System.arraycopy(unsegmentedPdu, 1, receivedBeaconData, 0, receivedBeaconData.length);
                        SecureNetworkBeacon receivedBeacon = new SecureNetworkBeacon(receivedBeaconData);
                        byte[] n = networkKey.getTxNetworkKey();
                        int flags = receivedBeacon.getFlags();
                        byte[] networkId = SecureUtils.calculateK3(n);
                        int ivIndex = receivedBeacon.getIvIndex().getIvIndex();
                        LOG.info("Received mesh beacon: " + receivedBeacon.toString());
                        SecureNetworkBeacon localSecureNetworkBeacon = SecureUtils.createSecureNetworkBeacon(n, flags, networkId, ivIndex);
                        if (!Arrays.equals(receivedBeacon.getAuthenticationValue(), localSecureNetworkBeacon.getAuthenticationValue())) continue;
                        LOG.info("Secure Network Beacon beacon authenticated.");
                        if (this.mMeshNetwork.getPrimaryNetworkKey() != null && networkKey.keyIndex != 0) {
                            LOG.info("Discarding beacon for secondary subnet with network key index: " + networkKey.keyIndex);
                            return;
                        }
                        IvIndex lastIvIndex = this.mMeshNetwork.getIvIndex();
                        LOG.info("Last IV Index: " + lastIvIndex.getIvIndex());
                        Calendar lastTransitionDate = lastIvIndex.getTransitionDate();
                        boolean isIvRecoveryActive = lastIvIndex.getIvRecoveryFlag();
                        boolean isIvTestModeActive = this.ivUpdateTestModeActive;
                        boolean flag = this.allowIvIndexRecoveryOver42;
                        if (!receivedBeacon.canOverwrite(lastIvIndex, lastTransitionDate, isIvRecoveryActive, isIvTestModeActive, flag)) {
                            String numberOfHoursSinceDate = (Calendar.getInstance().getTimeInMillis() - lastTransitionDate.getTimeInMillis()) / 3600000L + "h";
                            LOG.info("Discarding beacon " + receivedBeacon.getIvIndex() + ", last " + lastIvIndex.getIvIndex() + ", changed: " + numberOfHoursSinceDate + "ago, test mode: " + this.ivUpdateTestModeActive);
                            return;
                        }
                        IvIndex receivedIvIndex = receivedBeacon.getIvIndex();
                        this.mMeshNetwork.ivIndex = new IvIndex(receivedIvIndex.getIvIndex(), receivedIvIndex.isIvUpdateActive(), lastTransitionDate);
                        if (this.mMeshNetwork.ivIndex.getIvIndex() > lastIvIndex.getIvIndex()) {
                            LOG.info("Applying: " + this.mMeshNetwork.ivIndex.getIvIndex());
                        }
                        if (this.mMeshNetwork.ivIndex.getTransmitIvIndex() > lastIvIndex.getTransmitIvIndex()) {
                            LOG.info("Resetting local sequence numbers to 0");
                            Provisioner provisioner = this.mMeshNetwork.getSelectedProvisioner();
                            ProvisionedMeshNode node = this.mMeshNetwork.getNode(provisioner.getProvisionerUuid());
                            node.setSequenceNumber(0);
                        }
                        if (lastIvIndex != this.mMeshNetwork.ivIndex) {
                            boolean ivRecovery = this.mMeshNetwork.getIvIndex().getIvIndex() > lastIvIndex.getIvIndex() + 1 && !receivedBeacon.getIvIndex().isIvUpdateActive();
                            this.mMeshNetwork.getIvIndex().setIvRecoveryFlag(ivRecovery);
                        }
                        if (this.mMeshNetwork.ivIndex.getIvRecoveryFlag()) continue;
                        Iterator iterator = this.mMeshNetwork.networkExclusions.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry exclusions = iterator.next();
                            int expectedIncrement = (Integer)exclusions.getKey() + 2;
                            if (this.mMeshNetwork.ivIndex.getIvIndex() < expectedIncrement) continue;
                            iterator.remove();
                        }
                    }
                    break;
                }
                case 2: {
                    LOG.info("Received proxy configuration message: " + MeshParserUtils.bytesToHex(unsegmentedPdu, true));
                    this.mMeshMessageHandler.parseMeshPduNotifications(unsegmentedPdu, this.mMeshNetwork);
                    break;
                }
                case 3: {
                    LOG.info("Received provisioning message: " + MeshParserUtils.bytesToHex(unsegmentedPdu, true));
                    this.mMeshProvisioningHandler.parseProvisioningNotifications(unsegmentedPdu);
                }
            }
        }
        catch (ExtendedInvalidCipherTextException networkKey) {
        }
        catch (IllegalArgumentException ex) {
            LOG.severe("Parsing notification failed: " + MeshParserUtils.bytesToHex(unsegmentedPdu, true) + " - " + ex.getMessage());
        }
    }

    private void handleWriteCallbacks(byte[] data) {
        switch (data[0]) {
            case 0: {
                LOG.info("MeshNetwork pdu sent: " + MeshParserUtils.bytesToHex(data, true));
                break;
            }
            case 1: {
                LOG.info("Mesh beacon pdu sent: " + MeshParserUtils.bytesToHex(data, true));
                break;
            }
            case 2: {
                LOG.info("Proxy configuration pdu sent: " + MeshParserUtils.bytesToHex(data, true));
                break;
            }
            case 3: {
                LOG.info("Provisioning pdu sent: " + MeshParserUtils.bytesToHex(data, true));
                this.mMeshProvisioningHandler.handleProvisioningWriteCallbacks();
            }
        }
    }

    private boolean shouldWaitForMoreData(byte[] pdu) {
        int gattSar = (pdu[0] & 0xC0) >> 6;
        switch (gattSar) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private byte[] appendPdu(int mtuSize, byte[] pdu) {
        if (this.mIncomingBuffer == null) {
            int length = Math.min(pdu.length, mtuSize);
            this.mIncomingBufferOffset = 0;
            this.mIncomingBufferOffset += length;
            this.mIncomingBuffer = pdu;
        } else {
            int length = Math.min(pdu.length, mtuSize);
            byte[] buffer = new byte[this.mIncomingBuffer.length + length];
            System.arraycopy(this.mIncomingBuffer, 0, buffer, 0, this.mIncomingBufferOffset);
            System.arraycopy(pdu, 0, buffer, this.mIncomingBufferOffset, length);
            this.mIncomingBufferOffset += length;
            this.mIncomingBuffer = buffer;
            if (length < mtuSize) {
                byte[] packet = this.mIncomingBuffer;
                this.mIncomingBuffer = null;
                return packet;
            }
        }
        return null;
    }

    private byte[] appendWritePdu(int mtuSize, byte[] pdu) {
        if (this.mOutgoingBuffer == null) {
            int length = Math.min(pdu.length, mtuSize);
            this.mOutgoingBufferOffset = 0;
            this.mOutgoingBufferOffset += length;
            this.mOutgoingBuffer = pdu;
        } else {
            int length = Math.min(pdu.length, mtuSize);
            byte[] buffer = new byte[this.mOutgoingBuffer.length + length];
            System.arraycopy(this.mOutgoingBuffer, 0, buffer, 0, this.mOutgoingBufferOffset);
            System.arraycopy(pdu, 0, buffer, this.mOutgoingBufferOffset, length);
            this.mOutgoingBufferOffset += length;
            this.mOutgoingBuffer = buffer;
            if (length < mtuSize) {
                byte[] packet = this.mOutgoingBuffer;
                this.mOutgoingBuffer = null;
                return packet;
            }
        }
        return null;
    }

    @Override
    public synchronized void createMeshPdu(int dst, MeshMessage meshMessage) {
        UUID label;
        if (!MeshAddress.isAddressInRange(dst)) {
            throw new IllegalArgumentException("Invalid address, destination address must be a valid 16-bit value.");
        }
        Provisioner provisioner = this.mMeshNetwork.getSelectedProvisioner();
        if (provisioner != null && provisioner.getProvisionerAddress() != null) {
            label = null;
            if (MeshAddress.isValidVirtualAddress(dst) && (label = this.mMeshNetwork.getLabelUuid(dst)) == null) {
                throw new IllegalArgumentException("Label UUID unavailable for the virtual address provided");
            }
        } else {
            throw new IllegalArgumentException("Provisioner address not set, please assign an address to the provisioner.");
        }
        this.mMeshMessageHandler.createMeshMessage(provisioner.getProvisionerAddress(), dst, label, meshMessage);
    }

    public final synchronized void resetMeshNetwork(int provisionerAddress) {
        this.ivUpdateTestModeActive = false;
        this.allowIvIndexRecoveryOver42 = false;
        MeshNetwork meshNet = this.mMeshNetwork;
        MeshNetwork newMeshNetwork = this.generateMeshNetwork(provisionerAddress);
        newMeshNetwork.setCallbacks(this.callbacks);
        this.insertNetwork(newMeshNetwork);
        this.mMeshNetwork = newMeshNetwork;
        this.mMeshManagerCallbacks.onNetworkLoaded(newMeshNetwork);
    }

    private MeshNetwork generateMeshNetwork(int provisionerAddress) {
        String meshUuid = UUID.randomUUID().toString().toUpperCase(Locale.US);
        MeshNetwork network = new MeshNetwork(meshUuid);
        AllocatedUnicastRange unicastRange = new AllocatedUnicastRange(provisionerAddress, provisionerAddress);
        AllocatedGroupRange groupRange = new AllocatedGroupRange(49152, 52378);
        AllocatedSceneRange sceneRange = new AllocatedSceneRange(1, 13107);
        Provisioner provisioner = network.createProvisioner("nRF Mesh Provisioner", unicastRange, groupRange, sceneRange);
        int unicast = provisioner.getAllocatedUnicastRanges().get(0).getLowAddress();
        provisioner.assignProvisionerAddress(unicast);
        network.selectProvisioner(provisioner);
        network.addProvisioner(provisioner);
        ProvisionedMeshNode node = network.getNode(unicast);
        network.unicastAddress = node != null ? node.getUnicastAddress() + (node.getNumberOfElements() - 1) : 1;
        network.lastSelected = true;
        network.sequenceNumbers.clear();
        network.loadSequenceNumbers();
        this.ivUpdateTestModeActive = false;
        this.allowIvIndexRecoveryOver42 = false;
        return network;
    }

    private List<NetworkKey> generateNetKeys(String meshUuid) {
        ArrayList<NetworkKey> networkKeys = new ArrayList<NetworkKey>();
        NetworkKey networkKey = new NetworkKey(0, SecureUtils.generateRandomNumber());
        networkKey.setMeshUuid(meshUuid);
        networkKeys.add(networkKey);
        return networkKeys;
    }

    private List<ApplicationKey> generateAppKeys(String meshUuid) {
        ArrayList<ApplicationKey> appKeys = new ArrayList<ApplicationKey>();
        for (int i = 0; i < 3; ++i) {
            ApplicationKey appKey = new ApplicationKey(i, SecureUtils.generateRandomNumber());
            appKey.setMeshUuid(meshUuid);
            appKeys.add(appKey);
        }
        return appKeys;
    }

    private void deleteNode(ProvisionedMeshNode meshNode) {
        this.deleteSceneAddress(meshNode.getUnicastAddress());
        this.mMeshMessageHandler.resetState(meshNode.getUnicastAddress());
        this.mMeshManagerCallbacks.onNetworkUpdated(this.mMeshNetwork);
    }

    private void deleteSceneAddress(int address) {
        for (Scene scene : this.mMeshNetwork.getScenes()) {
            if (!scene.addresses.remove((Object)address)) continue;
            LOG.info("Node removed from " + scene.getName());
        }
    }

    private byte[] applySegmentation(int mtuSize, byte[] pdu) {
        int srcOffset = 0;
        int dstOffset = 0;
        int chunks = (pdu.length + (mtuSize - 1)) / mtuSize;
        byte pduType = pdu[0];
        if (chunks > 1) {
            byte[] segmentedBuffer = new byte[pdu.length + chunks - 1];
            for (int i = 0; i < chunks; ++i) {
                int length;
                if (i == 0) {
                    length = Math.min(pdu.length - srcOffset, mtuSize);
                    System.arraycopy(pdu, srcOffset, segmentedBuffer, dstOffset, length);
                    segmentedBuffer[0] = (byte)(0x40 | pduType);
                } else if (i == chunks - 1) {
                    length = Math.min(pdu.length - srcOffset, mtuSize);
                    segmentedBuffer[dstOffset] = (byte)(0xC0 | pduType);
                    System.arraycopy(pdu, srcOffset, segmentedBuffer, dstOffset + 1, length);
                } else {
                    length = Math.min(pdu.length - srcOffset, mtuSize - 1);
                    segmentedBuffer[dstOffset] = (byte)(0x80 | pduType);
                    System.arraycopy(pdu, srcOffset, segmentedBuffer, dstOffset + 1, length);
                }
                srcOffset += length;
                dstOffset += mtuSize;
            }
            return segmentedBuffer;
        }
        return pdu;
    }

    private byte[] removeSegmentation(int mtuSize, byte[] data) {
        int srcOffset = 0;
        int dstOffset = 0;
        int chunks = (data.length + (mtuSize - 1)) / mtuSize;
        if (chunks > 1) {
            byte[] buffer = new byte[data.length - (chunks - 1)];
            for (int i = 0; i < chunks; ++i) {
                int length = Math.min(buffer.length - dstOffset, mtuSize);
                if (i == 0) {
                    System.arraycopy(data, srcOffset, buffer, dstOffset, length);
                    buffer[0] = (byte)(buffer[0] & 0x3F);
                } else if (i == chunks - 1) {
                    System.arraycopy(data, srcOffset + 1, buffer, dstOffset, length);
                } else {
                    System.arraycopy(data, srcOffset + 1, buffer, dstOffset, --length);
                }
                srcOffset += mtuSize;
                dstOffset += length;
            }
            return buffer;
        }
        return data;
    }

    private void insertNetwork(MeshNetwork meshNetwork) {
        meshNetwork.setLastSelected(true);
        if (meshNetwork.provisioners.size() == 1) {
            ((Provisioner)meshNetwork.provisioners.get(0)).setLastSelected(true);
        }
    }

    private void initBouncyCastle() {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
    }
}

