/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.model.util.TextUtil;

abstract class MeshKey
implements Cloneable {
    protected int id;
    protected String meshUuid;
    protected int keyIndex;
    protected String name;
    protected byte[] key;
    protected byte[] oldKey;

    MeshKey() {
    }

    MeshKey(int keyIndex, @NotNull byte[] key) {
        Objects.requireNonNull(key);
        this.keyIndex = keyIndex;
        if (key.length != 16) {
            throw new IllegalArgumentException("Application key must be 16-bytes");
        }
        this.key = key;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public void setMeshUuid(String meshUuid) {
        this.meshUuid = meshUuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) throws IllegalArgumentException {
        if (TextUtil.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Name cannot be empty!");
        }
        this.name = name;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(@NotNull byte[] key) {
        Objects.requireNonNull(key);
        if (this.valid(key)) {
            this.key = key;
        }
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    public byte[] getOldKey() {
        return this.oldKey;
    }

    public void setOldKey(byte[] oldKey) {
        this.oldKey = oldKey;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ApplicationKey) {
            ApplicationKey appKey = (ApplicationKey)obj;
            return Arrays.equals(this.key, appKey.key) && this.keyIndex == appKey.keyIndex;
        }
        if (obj instanceof NetworkKey) {
            NetworkKey netKey = (NetworkKey)obj;
            return Arrays.equals(this.key, netKey.key) && this.keyIndex == netKey.keyIndex;
        }
        return false;
    }

    public MeshKey clone() throws CloneNotSupportedException {
        return (MeshKey)super.clone();
    }

    protected boolean valid(@NotNull byte[] key) {
        Objects.requireNonNull(key);
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be of length 16!");
        }
        return true;
    }

    protected boolean distributeKey(@NotNull byte[] key) {
        Objects.requireNonNull(key);
        if (!Arrays.equals(this.key, this.oldKey)) {
            this.setOldKey(this.key);
        }
        this.setKey(key);
        return true;
    }
}

