/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.Calendar;

public class IvIndex {
    private final int ivIndex;
    private final boolean isIvUpdateActive;
    private boolean ivRecoveryFlag = false;
    private Calendar transitionDate;

    public IvIndex(int ivIndex, boolean isIvUpdateActive, Calendar transitionDate) {
        this.ivIndex = ivIndex;
        this.isIvUpdateActive = isIvUpdateActive;
        this.transitionDate = transitionDate;
    }

    public String toString() {
        return "IV Index: " + this.ivIndex + ", IV Update Active: " + this.isIvUpdateActive;
    }

    public int getIvIndex() {
        return this.ivIndex;
    }

    public boolean isIvUpdateActive() {
        return this.isIvUpdateActive;
    }

    public int getTransmitIvIndex() {
        return this.isIvUpdateActive && this.ivIndex != 0 ? this.ivIndex - 1 : this.ivIndex;
    }

    public boolean getIvRecoveryFlag() {
        return this.ivRecoveryFlag;
    }

    public void setIvRecoveryFlag(boolean ivRecoveryFlag) {
        this.ivRecoveryFlag = ivRecoveryFlag;
    }

    public Calendar getTransitionDate() {
        return this.transitionDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IvIndex ivIndex1 = (IvIndex)o;
        return this.ivIndex == ivIndex1.ivIndex && this.isIvUpdateActive == ivIndex1.isIvUpdateActive && this.ivRecoveryFlag == ivIndex1.ivRecoveryFlag && this.transitionDate.getTimeInMillis() == ivIndex1.transitionDate.getTimeInMillis();
    }
}

