/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.UUID;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

public class Group {
    public int id = 0;
    private String name = "Mesh Group";
    private int address;
    private UUID addressLabel;
    private int parentAddress;
    private UUID parentAddressLabel;
    private String meshUuid;

    public Group(int id, int address, UUID addressLabel, int parentAddress, UUID parentAddressLabel, String meshUuid) throws IllegalArgumentException {
        this(address, addressLabel, parentAddress, parentAddressLabel, meshUuid);
        this.id = id;
    }

    public Group(int address, String meshUuid) throws IllegalArgumentException {
        this(address, null, 0, null, meshUuid);
    }

    public Group(int address, int parentAddress, String meshUuid) throws IllegalArgumentException {
        this(address, null, parentAddress, null, meshUuid);
    }

    public Group(int address, UUID parentAddressLabel, String meshUuid) throws IllegalArgumentException {
        this(address, null, 0, parentAddressLabel, meshUuid);
    }

    public Group(UUID addressLabel, int parentAddress, String meshUuid) throws IllegalArgumentException {
        this(0, addressLabel, parentAddress, null, meshUuid);
    }

    public Group(UUID addressLabel, UUID parentAddressLabel, String meshUuid) throws IllegalArgumentException {
        this(0, addressLabel, 0, parentAddressLabel, meshUuid);
    }

    private Group(int address, UUID addressLabel, int parentAddress, UUID parentAddressLabel, String meshUuid) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnassignedAddress(address) && MeshAddress.isValidUnassignedAddress(parentAddress) && address == parentAddress) {
            throw new IllegalArgumentException("The value of the parentAddress property shall not be equal to the value of the address property");
        }
        if (addressLabel == null) {
            if (MeshAddress.isValidVirtualAddress(address)) {
                throw new IllegalArgumentException("Please provide a Label UUID when creating groups using virtual addresses");
            }
            if (!MeshAddress.isValidGroupAddress(address)) {
                throw new IllegalArgumentException("Address of the group must be a valid group address or a virtual address");
            }
            this.address = address;
            this.generateParentAddressLabel(parentAddressLabel, parentAddress);
        } else {
            this.addressLabel = addressLabel;
            this.address = MeshAddress.generateVirtualAddress(addressLabel);
            this.generateParentAddressLabel(parentAddressLabel, parentAddress);
        }
        this.meshUuid = meshUuid;
    }

    private void generateParentAddressLabel(UUID parentAddressLabel, int parentAddress) throws IllegalArgumentException {
        this.parentAddressLabel = parentAddressLabel;
        if (parentAddressLabel == null) {
            if (MeshAddress.isValidVirtualAddress(parentAddress)) {
                throw new IllegalArgumentException("Please provide a Label UUID for the parent address of this group");
            }
            if (!MeshAddress.isValidGroupAddress(parentAddress) && !MeshAddress.isValidUnassignedAddress(parentAddress)) {
                throw new IllegalArgumentException("parentAddress value must be a group address, virtual address or an unassigned address");
            }
            this.parentAddress = parentAddress;
        } else {
            this.parentAddress = MeshAddress.generateVirtualAddress(parentAddressLabel);
        }
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public void setMeshUuid(String meshUuid) {
        this.meshUuid = meshUuid;
    }

    public int getAddress() {
        return this.address;
    }

    public UUID getAddressLabel() {
        return this.addressLabel;
    }

    public void setAddressLabel(UUID uuidLabel) {
        this.addressLabel = uuidLabel;
        if (uuidLabel != null) {
            this.address = MeshAddress.generateVirtualAddress(uuidLabel);
        }
    }

    public UUID getParentAddressLabel() {
        return this.parentAddressLabel;
    }

    public void setParentAddressLabel(UUID parentAddressLabel) {
        this.parentAddressLabel = parentAddressLabel;
        if (parentAddressLabel != null) {
            this.parentAddress = MeshAddress.generateVirtualAddress(parentAddressLabel);
        }
    }

    public int getParentAddress() {
        return this.parentAddress;
    }

    public void setParentAddress(int parentAddress) {
        if (MeshAddress.isValidVirtualAddress(parentAddress)) {
            throw new IllegalArgumentException("Assigning a virtual address to parentAddress can be done only by setting a parent address label");
        }
        if (!MeshAddress.isValidGroupAddress(parentAddress)) {
            throw new IllegalArgumentException("parentAddress must be a group address value");
        }
        this.parentAddress = parentAddress;
        this.parentAddressLabel = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

