/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

public class Features {
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int UNSUPPORTED = 2;
    private int friend;
    private int lowPower;
    private int proxy;
    private int relay;

    public Features(int friend, int lowPower, int proxy, int relay) {
        this.friend = friend;
        this.lowPower = lowPower;
        this.proxy = proxy;
        this.relay = relay;
    }

    public String toString() {
        return "Features{friend=" + this.friend + ", lowPower=" + this.lowPower + ", proxy=" + this.proxy + ", relay=" + this.relay + "}";
    }

    public int getFriend() {
        return this.friend;
    }

    public void setFriend(int friend) {
        this.friend = friend;
    }

    public int getLowPower() {
        return this.lowPower;
    }

    public void setLowPower(int lowPower) {
        this.lowPower = lowPower;
    }

    public int getProxy() {
        return this.proxy;
    }

    public void setProxy(int proxy) {
        this.proxy = proxy;
    }

    public int getRelay() {
        return this.relay;
    }

    public void setRelay(int relay) {
        this.relay = relay;
    }

    public boolean isFriendFeatureSupported() {
        switch (this.friend) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean isRelayFeatureSupported() {
        switch (this.relay) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean isProxyFeatureSupported() {
        switch (this.proxy) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean isLowPowerFeatureSupported() {
        switch (this.lowPower) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    public int assembleFeatures() {
        int features = this.bitValue(this.lowPower) << 3;
        features |= this.bitValue(this.friend) << 2;
        features |= this.bitValue(this.proxy) << 1;
        return features |= this.bitValue(this.relay);
    }

    private short bitValue(int feature) {
        switch (feature) {
            default: {
                return 0;
            }
            case 1: 
        }
        return 1;
    }
}

