/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothGattCharacteristic;
import com.welie.blessed.BluetoothGattService;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.ScanResult;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxy;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyConnectCallback;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyRxCallback;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxySendDataCallback;
import org.openremote.agent.protocol.bluetooth.mesh.MainThreadManager;
import org.openremote.agent.protocol.bluetooth.mesh.SendDataCommand;
import org.openremote.agent.protocol.bluetooth.mesh.SendMultiDataSegmentCommand;
import org.openremote.agent.protocol.bluetooth.mesh.SendSingleDataSegmentCommand;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.syslog.SyslogCategory;

public class BluetoothMeshProxyStateMachine {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)BluetoothMeshProxyStateMachine.class.getName());
    public static final int MAX_RETRY_COUNT = 20;
    public static final int CONNECT_TIMEOUT = 60000;
    public static final int SCAN_TIMEOUT = 60000;
    private final BluetoothMeshProxy meshProxy;
    private final BluetoothCentralManager bluetoothCentral;
    private volatile BluetoothPeripheral peripheral;
    private final BluetoothPeripheralCallback peripheralCallback;
    private final ScheduledExecutorService executorService;
    private volatile BluetoothMeshProxyRxCallback rxDataCallback;
    private volatile Consumer<ConnectionStatus> statusConsumer;
    private volatile BluetoothMeshProxyConnectCallback connectCallback;
    private volatile BluetoothGattCharacteristic dataInCharacteristic;
    private volatile BluetoothGattCharacteristic dataOutCharacteristic;
    private volatile int retryCount = 0;
    private volatile boolean isInitialConnectionSuccessful = false;
    private final BlockingQueue<SendDataCommand> sendDataQueue = new LinkedBlockingQueue<SendDataCommand>();
    private final QueueWorker queueWorker = new QueueWorker(this.sendDataQueue);
    private volatile ScheduledFuture<?> workerFuture;
    private volatile ScheduledFuture<?> timeoutFuture;
    private final MainThreadManager commandSerializer;
    private final StartState startState = new StartState(this);
    private final RetryToConnectState retryToConnectState = new RetryToConnectState(this);
    private final ConnectingState connectingState = new ConnectingState(this);
    private final ConnectedState connectedState = new ConnectedState(this);
    private final ServicesDiscoveredState servicesDiscoveredState = new ServicesDiscoveredState(this);
    private final ConfigureCharacteristicState configureCharacteristicState = new ConfigureCharacteristicState(this);
    private final EndState endState = new EndState(this);
    private final ScanState scanState = new ScanState(this);
    private final DisconnectedState disconnectedState = new DisconnectedState(this);
    private final FailedState failedState = new FailedState(this);
    private volatile State state = this.startState;

    public BluetoothMeshProxyStateMachine(BluetoothMeshProxy proxy, BluetoothCentralManager bluetoothCentral, ScheduledExecutorService executorService, MainThreadManager commandSerializer, BluetoothPeripheral peripheral, BluetoothPeripheralCallback callback) {
        this.meshProxy = proxy;
        this.bluetoothCentral = bluetoothCentral;
        this.commandSerializer = commandSerializer;
        this.executorService = executorService;
        this.peripheral = peripheral;
        this.peripheralCallback = callback;
    }

    void setState(State state) {
        this.state = state;
    }

    StartState getStartState() {
        return this.startState;
    }

    RetryToConnectState getRetryToConnectState() {
        return this.retryToConnectState;
    }

    ConnectingState getConnectingState() {
        return this.connectingState;
    }

    ConnectedState getConnectedState() {
        return this.connectedState;
    }

    ServicesDiscoveredState getServicesDiscoveredState() {
        return this.servicesDiscoveredState;
    }

    ConfigureCharacteristicState getConfigureCharacteristicState() {
        return this.configureCharacteristicState;
    }

    EndState getEndState() {
        return this.endState;
    }

    ScanState getScanState() {
        return this.scanState;
    }

    DisconnectedState getDisconnectedState() {
        return this.disconnectedState;
    }

    FailedState getFailedState() {
        return this.failedState;
    }

    public synchronized void setRxDataCallback(BluetoothMeshProxyRxCallback callback) {
        this.rxDataCallback = callback;
    }

    public synchronized void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        this.state.connect(statusConsumer, callback);
    }

    public synchronized void disconnect() {
        this.state.disconnect();
    }

    public synchronized void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        this.state.sendData(mtuSize, data, callback);
    }

    public synchronized void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        this.state.onConnectedPeripheral(peripheral);
    }

    public synchronized void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        this.state.onConnectionFailed(peripheral, status);
        this.state.connect(this.statusConsumer, this.connectCallback);
    }

    public synchronized void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        this.state.onDisconnectedPeripheral(peripheral, status);
        this.state.connect(this.statusConsumer, this.connectCallback);
    }

    public synchronized void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        this.state.onServicesDiscovered(peripheral, services);
        this.state.configureOutCharacteristic();
    }

    public synchronized void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        this.state.onNotificationStateUpdate(peripheral, characteristic, status);
    }

    public synchronized void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        if (!this.dataOutCharacteristic.getUuid().equals(characteristic.getUuid())) {
            return;
        }
        if (status == BluetoothCommandStatus.COMMAND_SUCCESS) {
            LOG.info("Received '" + value.length + "' data bytes from mesh proxy: [data=" + this.dataAsHexString(value) + "]");
            BluetoothMeshProxyRxCallback callback = this.rxDataCallback;
            if (callback != null) {
                this.executorService.execute(() -> callback.onRxData(value));
            }
        }
    }

    public synchronized void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        if (this.queueWorker != null) {
            this.queueWorker.onCharacteristicWrite(peripheral, value, characteristic, status);
        }
    }

    public synchronized void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        this.state.onDiscoveredPeripheral(peripheral, scanResult);
        this.state.connect(this.statusConsumer, this.connectCallback);
    }

    public synchronized boolean isConnected() {
        return this.state == this.getEndState();
    }

    synchronized void onTimeout() {
        LOG.info("Timeout fired !");
        this.state.onTimeout();
    }

    void setStatusConsumer(Consumer<ConnectionStatus> statusConsumer) {
        this.statusConsumer = statusConsumer;
    }

    Consumer<ConnectionStatus> getStatusConsumer() {
        return this.statusConsumer;
    }

    void setConnectCallback(BluetoothMeshProxyConnectCallback callback) {
        this.connectCallback = callback;
    }

    BluetoothMeshProxyConnectCallback getConnectCallback() {
        return this.connectCallback;
    }

    void setDataInCharacteristic(BluetoothGattCharacteristic characteristic) {
        this.dataInCharacteristic = characteristic;
    }

    BluetoothGattCharacteristic getDataInCharacteristic() {
        return this.dataInCharacteristic;
    }

    void setDataOutCharacteristic(BluetoothGattCharacteristic characteristic) {
        this.dataOutCharacteristic = characteristic;
    }

    BluetoothGattCharacteristic getDataOutCharacteristic() {
        return this.dataOutCharacteristic;
    }

    void startQueueWorker() {
        this.workerFuture = this.executorService.schedule(this.queueWorker, 0L, TimeUnit.MILLISECONDS);
    }

    void stopQueueWorker() {
        if (this.workerFuture != null) {
            this.workerFuture.cancel(true);
            this.workerFuture = null;
        }
        this.sendDataQueue.clear();
    }

    int getRetryCount() {
        return this.retryCount;
    }

    void setRetryCount(int count) {
        this.retryCount = count;
    }

    int incrementRetryCount() {
        return ++this.retryCount;
    }

    BluetoothCentralManager getBluetoothCentral() {
        return this.bluetoothCentral;
    }

    public synchronized BluetoothPeripheral getPeripheral() {
        return this.peripheral;
    }

    void setPeripheral(BluetoothPeripheral peripheral) {
        this.peripheral = peripheral;
    }

    BluetoothPeripheralCallback getPeripheralCallback() {
        return this.peripheralCallback;
    }

    void notifyStatusConsumer(ConnectionStatus status) {
        this.executorService.execute(() -> this.statusConsumer.accept(status));
    }

    void executeOnMainThread(Runnable runnable) {
        this.commandSerializer.enqueue(runnable);
    }

    boolean isExpectedPeripheral(BluetoothPeripheral peripheral) {
        if (peripheral != null && this.peripheral != null) {
            return peripheral.getAddress().equalsIgnoreCase(this.peripheral.getAddress());
        }
        return false;
    }

    void notifyListeners(boolean isSuccess, ConnectionStatus status) {
        boolean isConnectionLoss = !isSuccess ? this.isInitialConnectionSuccessful : false;
        this.executorService.execute(() -> this.connectCallback.onMeshProxyConnected(this.peripheral, isSuccess, isConnectionLoss));
        this.executorService.execute(() -> this.statusConsumer.accept(status));
    }

    void disableOutCharacteristicNotifications() {
        BluetoothGattCharacteristic out = this.getDataOutCharacteristic();
        if (out != null) {
            this.executeOnMainThread(() -> {
                LOG.info("Disabling out characteristic notifications: [Name=" + this.getPeripheral().getName() + ", Address=" + this.getPeripheral().getAddress() + "]");
                this.getPeripheral().setNotify(out, false);
            });
        }
    }

    void cancelConnection() {
        this.executeOnMainThread(() -> {
            LOG.info("Cancelling peripheral connection: [Name=" + this.getPeripheral().getName() + ", Address=" + this.getPeripheral().getAddress() + "]");
            this.getBluetoothCentral().cancelConnection(this.getPeripheral());
        });
    }

    void scanOn() {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        this.executeOnMainThread(() -> {
            LOG.info("Scan ON");
            this.getBluetoothCentral().scanForPeripheralsWithServices(new UUID[]{BluetoothMeshProxy.MESH_PROXY_UUID});
        });
    }

    void scanOff() {
        this.executeOnMainThread(() -> {
            LOG.info("Scan OFF");
            this.getBluetoothCentral().stopScan();
        });
    }

    void startTimeout(int timeout) {
        this.timeoutFuture = this.executorService.schedule(() -> this.onTimeout(), (long)timeout, TimeUnit.MILLISECONDS);
    }

    void stopTimeout() {
        if (this.timeoutFuture != null) {
            if (!this.timeoutFuture.isCancelled() && !this.timeoutFuture.isDone()) {
                this.timeoutFuture.cancel(true);
            }
            this.timeoutFuture = null;
        }
    }

    String dataAsHexString(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            builder.append(String.format("0x%02X%s", data[i] & 0xFF, i == data.length - 1 ? "" : ", "));
        }
        return builder.toString();
    }

    private class QueueWorker
    extends BluetoothPeripheralCallback
    implements Runnable {
        private final BlockingQueue<SendDataCommand> queue;
        private SendDataCommand pendingCommand = null;

        public QueueWorker(BlockingQueue<SendDataCommand> queue) {
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    SendDataCommand command = this.queue.take();
                    QueueWorker queueWorker = this;
                    synchronized (queueWorker) {
                        this.pendingCommand = command;
                    }
                    command.sendData();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public synchronized void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
            if (this.pendingCommand != null) {
                this.pendingCommand.onCharacteristicWrite(peripheral, value, characteristic, status);
            }
        }
    }

    private class StartState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public StartState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
            BluetoothMeshProxyStateMachine.this.setStatusConsumer(statusConsumer);
            BluetoothMeshProxyStateMachine.this.setConnectCallback(callback);
            BluetoothMeshProxyStateMachine.this.startQueueWorker();
            BluetoothMeshProxyStateMachine.this.setRetryCount(1);
            BluetoothMeshProxyStateMachine.this.setDataInCharacteristic(null);
            BluetoothMeshProxyStateMachine.this.setDataOutCharacteristic(null);
            BluetoothMeshProxyStateMachine.this.startTimeout(60000);
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getConnectingState());
            BluetoothMeshProxyStateMachine.this.notifyStatusConsumer(ConnectionStatus.CONNECTING);
            BluetoothMeshProxyStateMachine.this.executeOnMainThread(() -> {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                LOG.info("Initially connecting to mesh proxy: [Name=" + BluetoothMeshProxyStateMachine.this.getPeripheral().getName() + ", Address=" + BluetoothMeshProxyStateMachine.this.getPeripheral().getAddress() + "]");
                BluetoothMeshProxyStateMachine.this.getBluetoothCentral().connectPeripheral(BluetoothMeshProxyStateMachine.this.getPeripheral(), BluetoothMeshProxyStateMachine.this.getPeripheralCallback());
            });
        }

        @Override
        public void disconnect() {
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private class RetryToConnectState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public RetryToConnectState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
            BluetoothMeshProxyStateMachine.this.incrementRetryCount();
            BluetoothMeshProxyStateMachine.this.setDataInCharacteristic(null);
            BluetoothMeshProxyStateMachine.this.setDataOutCharacteristic(null);
            BluetoothMeshProxyStateMachine.this.stopTimeout();
            BluetoothMeshProxyStateMachine.this.startTimeout(60000);
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getConnectingState());
            BluetoothMeshProxyStateMachine.this.notifyStatusConsumer(ConnectionStatus.CONNECTING);
            BluetoothMeshProxyStateMachine.this.executeOnMainThread(() -> {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                LOG.info("Reconnecting to mesh proxy: [RetryCount=" + BluetoothMeshProxyStateMachine.this.getRetryCount() + ", Name=" + BluetoothMeshProxyStateMachine.this.getPeripheral().getName() + ", Address=" + BluetoothMeshProxyStateMachine.this.getPeripheral().getAddress() + "]");
                BluetoothMeshProxyStateMachine.this.getBluetoothCentral().connectPeripheral(BluetoothMeshProxyStateMachine.this.getPeripheral(), BluetoothMeshProxyStateMachine.this.getPeripheralCallback());
            });
        }

        @Override
        public void disconnect() {
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getDisconnectedState());
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private class ConnectingState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public ConnectingState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        }

        @Override
        public void disconnect() {
            BluetoothMeshProxyStateMachine.this.stopTimeout();
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getDisconnectedState());
            BluetoothMeshProxyStateMachine.this.cancelConnection();
            BluetoothMeshProxyStateMachine.this.notifyStatusConsumer(ConnectionStatus.DISCONNECTED);
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
            if (BluetoothMeshProxyStateMachine.this.isExpectedPeripheral(peripheral)) {
                BluetoothMeshProxyStateMachine.this.stopTimeout();
                BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getConnectedState());
            }
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
            if (BluetoothMeshProxyStateMachine.this.isExpectedPeripheral(peripheral)) {
                if (BluetoothMeshProxyStateMachine.this.getRetryCount() < 20) {
                    BluetoothMeshProxyStateMachine.this.stopTimeout();
                    BluetoothMeshProxyStateMachine.this.startTimeout(60000);
                    BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getScanState());
                    BluetoothMeshProxyStateMachine.this.scanOn();
                } else {
                    BluetoothMeshProxyStateMachine.this.notifyListeners(false, ConnectionStatus.ERROR);
                    BluetoothMeshProxyStateMachine.this.stopTimeout();
                    BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getFailedState());
                    BluetoothMeshProxyStateMachine.this.stopQueueWorker();
                }
            }
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
            LOG.warning("ConnectingState::onTimeout");
            BluetoothMeshProxyStateMachine.this.notifyListeners(false, ConnectionStatus.ERROR);
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getFailedState());
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }
    }

    private class ConnectedState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public ConnectedState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        }

        @Override
        public void disconnect() {
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getDisconnectedState());
            BluetoothMeshProxyStateMachine.this.cancelConnection();
            BluetoothMeshProxyStateMachine.this.notifyStatusConsumer(ConnectionStatus.DISCONNECTED);
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
            if (BluetoothMeshProxyStateMachine.this.isExpectedPeripheral(peripheral)) {
                BluetoothMeshProxyStateMachine.this.stopTimeout();
                BluetoothMeshProxyStateMachine.this.startTimeout(60000);
                BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getScanState());
                BluetoothMeshProxyStateMachine.this.scanOn();
            }
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
            if (BluetoothMeshProxyStateMachine.this.isExpectedPeripheral(peripheral)) {
                BluetoothGattCharacteristic in = peripheral.getCharacteristic(BluetoothMeshProxy.MESH_PROXY_UUID, BluetoothMeshProxy.MESH_PROXY_DATA_IN);
                BluetoothGattCharacteristic out = peripheral.getCharacteristic(BluetoothMeshProxy.MESH_PROXY_UUID, BluetoothMeshProxy.MESH_PROXY_DATA_OUT);
                if (in != null && out != null) {
                    BluetoothMeshProxyStateMachine.this.setDataInCharacteristic(in);
                    BluetoothMeshProxyStateMachine.this.setDataOutCharacteristic(out);
                    BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getServicesDiscoveredState());
                } else {
                    BluetoothMeshProxyStateMachine.this.notifyListeners(false, ConnectionStatus.ERROR);
                    BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getFailedState());
                    BluetoothMeshProxyStateMachine.this.stopQueueWorker();
                }
            }
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private class ServicesDiscoveredState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public ServicesDiscoveredState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        }

        @Override
        public void disconnect() {
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getDisconnectedState());
            BluetoothMeshProxyStateMachine.this.cancelConnection();
            BluetoothMeshProxyStateMachine.this.notifyStatusConsumer(ConnectionStatus.DISCONNECTED);
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
            if (BluetoothMeshProxyStateMachine.this.isExpectedPeripheral(peripheral)) {
                BluetoothMeshProxyStateMachine.this.stopTimeout();
                BluetoothMeshProxyStateMachine.this.startTimeout(60000);
                BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getScanState());
                BluetoothMeshProxyStateMachine.this.scanOn();
            }
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
            BluetoothGattCharacteristic out = BluetoothMeshProxyStateMachine.this.getDataOutCharacteristic();
            BluetoothMeshProxyStateMachine.this.executeOnMainThread(() -> {
                LOG.info("Enabling out characteristic notifications: [Name=" + BluetoothMeshProxyStateMachine.this.getPeripheral().getName() + ", Address=" + BluetoothMeshProxyStateMachine.this.getPeripheral().getAddress() + "]");
                BluetoothMeshProxyStateMachine.this.getPeripheral().setNotify(out, true);
            });
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getConfigureCharacteristicState());
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
            LOG.info("ConfigureCharacteristicState::onNotificationStateUpdate: status=" + status);
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private class ConfigureCharacteristicState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public ConfigureCharacteristicState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        }

        @Override
        public void disconnect() {
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getDisconnectedState());
            BluetoothMeshProxyStateMachine.this.disableOutCharacteristicNotifications();
            BluetoothMeshProxyStateMachine.this.cancelConnection();
            BluetoothMeshProxyStateMachine.this.notifyStatusConsumer(ConnectionStatus.DISCONNECTED);
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
            if (BluetoothMeshProxyStateMachine.this.isExpectedPeripheral(peripheral)) {
                BluetoothMeshProxyStateMachine.this.stopTimeout();
                BluetoothMeshProxyStateMachine.this.startTimeout(60000);
                BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getScanState());
                BluetoothMeshProxyStateMachine.this.scanOn();
            }
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
            if (BluetoothMeshProxyStateMachine.this.isExpectedPeripheral(peripheral) && BluetoothMeshProxyStateMachine.this.getDataOutCharacteristic().getUuid().equals(characteristic.getUuid())) {
                if (status == BluetoothCommandStatus.COMMAND_SUCCESS) {
                    BluetoothMeshProxyStateMachine.this.isInitialConnectionSuccessful = true;
                    BluetoothMeshProxyStateMachine.this.setRetryCount(0);
                    BluetoothMeshProxyStateMachine.this.notifyListeners(true, ConnectionStatus.CONNECTED);
                    BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getEndState());
                } else {
                    BluetoothMeshProxyStateMachine.this.notifyListeners(false, ConnectionStatus.ERROR);
                    BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getFailedState());
                    BluetoothMeshProxyStateMachine.this.stopQueueWorker();
                }
            }
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private class EndState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public EndState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        }

        @Override
        public void disconnect() {
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getDisconnectedState());
            BluetoothMeshProxyStateMachine.this.disableOutCharacteristicNotifications();
            BluetoothMeshProxyStateMachine.this.executeOnMainThread(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            BluetoothMeshProxyStateMachine.this.cancelConnection();
            BluetoothMeshProxyStateMachine.this.executeOnMainThread(() -> {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            BluetoothMeshProxyStateMachine.this.notifyStatusConsumer(ConnectionStatus.DISCONNECTED);
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
            SendDataCommand cmd = null;
            cmd = data.length > mtuSize ? new SendMultiDataSegmentCommand(BluetoothMeshProxyStateMachine.this.meshProxy, BluetoothMeshProxyStateMachine.this.commandSerializer, mtuSize, BluetoothMeshProxyStateMachine.this.executorService, BluetoothMeshProxyStateMachine.this.dataInCharacteristic, data, callback) : new SendSingleDataSegmentCommand(BluetoothMeshProxyStateMachine.this.meshProxy, BluetoothMeshProxyStateMachine.this.commandSerializer, BluetoothMeshProxyStateMachine.this.executorService, BluetoothMeshProxyStateMachine.this.dataInCharacteristic, data, callback);
            try {
                BluetoothMeshProxyStateMachine.this.sendDataQueue.put(cmd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
            if (BluetoothMeshProxyStateMachine.this.isExpectedPeripheral(peripheral)) {
                BluetoothMeshProxyStateMachine.this.stopTimeout();
                BluetoothMeshProxyStateMachine.this.startTimeout(60000);
                BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getScanState());
                BluetoothMeshProxyStateMachine.this.scanOn();
                BluetoothMeshProxyStateMachine.this.executorService.execute(() -> BluetoothMeshProxyStateMachine.this.statusConsumer.accept(ConnectionStatus.DISCONNECTED));
            }
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private class ScanState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public ScanState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        }

        @Override
        public void disconnect() {
            BluetoothMeshProxyStateMachine.this.stopTimeout();
            BluetoothMeshProxyStateMachine.this.scanOff();
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getDisconnectedState());
            BluetoothMeshProxyStateMachine.this.notifyStatusConsumer(ConnectionStatus.DISCONNECTED);
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
            BluetoothPeripheral oldPeripheral = BluetoothMeshProxyStateMachine.this.getPeripheral();
            BluetoothPeripheral newPeripheral = peripheral;
            if (oldPeripheral.getAddress().equals(newPeripheral.getAddress())) {
                LOG.info("Scanned Bluetooth Mesh proxy after connection loss: [Name='" + peripheral.getName() + "', address='" + peripheral.getAddress() + "']");
                BluetoothMeshProxyStateMachine.this.setPeripheral(newPeripheral);
                BluetoothMeshProxyStateMachine.this.stopTimeout();
                BluetoothMeshProxyStateMachine.this.scanOff();
                BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getRetryToConnectState());
                BluetoothMeshProxyStateMachine.this.executorService.execute(() -> BluetoothMeshProxyStateMachine.this.statusConsumer.accept(ConnectionStatus.CONNECTING));
            }
        }

        @Override
        public void onTimeout() {
            LOG.warning("ScanState::onTimeout");
            BluetoothMeshProxyStateMachine.this.scanOff();
            BluetoothMeshProxyStateMachine.this.notifyListeners(false, ConnectionStatus.ERROR);
            BluetoothMeshProxyStateMachine.this.setState(BluetoothMeshProxyStateMachine.this.getFailedState());
            BluetoothMeshProxyStateMachine.this.stopQueueWorker();
        }
    }

    private class DisconnectedState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public DisconnectedState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        }

        @Override
        public void disconnect() {
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private class FailedState
    implements State {
        private final BluetoothMeshProxyStateMachine stateMachine;

        public FailedState(BluetoothMeshProxyStateMachine machine) {
            this.stateMachine = machine;
        }

        @Override
        public void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        }

        @Override
        public void disconnect() {
        }

        @Override
        public void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        }

        @Override
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        }

        @Override
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        }

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
        }

        @Override
        public void configureOutCharacteristic() {
        }

        @Override
        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        }

        @Override
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private static interface State {
        public void connect(Consumer<ConnectionStatus> var1, BluetoothMeshProxyConnectCallback var2);

        public void disconnect();

        public void sendData(int var1, byte[] var2, BluetoothMeshProxySendDataCallback var3);

        public void onConnectedPeripheral(BluetoothPeripheral var1);

        public void onConnectionFailed(BluetoothPeripheral var1, BluetoothCommandStatus var2);

        public void onDisconnectedPeripheral(BluetoothPeripheral var1, BluetoothCommandStatus var2);

        public void onServicesDiscovered(BluetoothPeripheral var1, List<BluetoothGattService> var2);

        public void configureOutCharacteristic();

        public void onNotificationStateUpdate(BluetoothPeripheral var1, BluetoothGattCharacteristic var2, BluetoothCommandStatus var3);

        public void onCharacteristicUpdate(BluetoothPeripheral var1, byte[] var2, BluetoothGattCharacteristic var3, BluetoothCommandStatus var4);

        public void onCharacteristicWrite(BluetoothPeripheral var1, byte[] var2, BluetoothGattCharacteristic var3, BluetoothCommandStatus var4);

        public void onDiscoveredPeripheral(BluetoothPeripheral var1, ScanResult var2);

        public void onTimeout();
    }
}

