/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.ScanResult;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxy;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyScannerCallback;
import org.openremote.agent.protocol.bluetooth.mesh.MainThreadManager;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.model.syslog.SyslogCategory;

public class BluetoothMeshProxyScanner
extends BluetoothCentralManagerCallback {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)BluetoothMeshProxyScanner.class.getName());
    public static final UUID MESH_PROXY_UUID = UUID.fromString("00001828-0000-1000-8000-00805F9B34FB");
    private static final int ADVERTISED_NETWORK_ID_OFFSET = 1;
    private static final int ADVERTISEMENT_TYPE_NETWORK_ID = 0;
    private static final int ADVERTISEMENT_TYPE_NODE_IDENTITY = 1;
    private static final int ADVERTISED_NETWORK_ID_LENGTH = 8;
    private static final int ADVERTISED_HASH_LENGTH = 8;
    private static final int ADVERTISED_HASH_OFFSET = 1;
    private final MainThreadManager bluetoothCommandSerializer;
    private final BluetoothCentralManager bluetoothCentral;
    private final ScheduledExecutorService executorService;
    private volatile BluetoothMeshProxyScannerCallback callback;
    private volatile NetworkKey networkKey;
    private volatile String address;
    private volatile boolean isStarted = false;
    private ScheduledFuture<?> timeoutFuture;
    private final Map<String, BluetoothMeshProxy> meshProxyMap = new HashMap<String, BluetoothMeshProxy>();

    public BluetoothMeshProxyScanner(MainThreadManager bluetoothCommandSerializer, BluetoothCentralManager central, ScheduledExecutorService executorService) {
        this.bluetoothCommandSerializer = bluetoothCommandSerializer;
        this.bluetoothCentral = central;
        this.executorService = executorService;
    }

    public synchronized void start(NetworkKey networkKey, String address, int duration, BluetoothMeshProxyScannerCallback callback) {
        LOG.info("Starting mesh proxy scanner");
        if (this.isStarted) {
            this.stop();
        }
        this.callback = callback;
        this.networkKey = networkKey;
        this.address = address;
        this.meshProxyMap.clear();
        this.isStarted = true;
        Runnable runnable = () -> {
            LOG.info("Scan ON");
            this.bluetoothCentral.scanForPeripheralsWithServices(new UUID[]{MESH_PROXY_UUID});
        };
        this.bluetoothCommandSerializer.enqueue(runnable);
        this.timeoutFuture = this.executorService.schedule(() -> {
            BluetoothMeshProxyScanner bluetoothMeshProxyScanner = this;
            synchronized (bluetoothMeshProxyScanner) {
                this.timeoutFuture = null;
                this.executeCallbackAndStopScanner();
            }
        }, (long)duration, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        LOG.info("Stopping mesh proxy scanner");
        if (this.isStarted) {
            Runnable runnable = () -> {
                LOG.info("Scan OFF");
                this.bluetoothCentral.stopScan();
            };
            this.bluetoothCommandSerializer.enqueue(runnable);
            this.meshProxyMap.clear();
            this.isStarted = false;
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
                this.timeoutFuture = null;
            }
        }
    }

    public synchronized void onConnectedPeripheral(BluetoothPeripheral peripheral) {
    }

    public synchronized void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
    }

    public synchronized void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
    }

    public synchronized void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        if (!this.isStarted) {
            return;
        }
        LOG.info("Scanned Bluetooth mesh proxy: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", connectionState=" + peripheral.getState() + "]");
        if (!this.meshProxyMap.containsKey(peripheral.getAddress())) {
            byte[] serviceData = (byte[])scanResult.getServiceData().get(MESH_PROXY_UUID.toString());
            if (serviceData != null) {
                if (this.isAdvertisingWithNetworkIdentity(serviceData)) {
                    LOG.info("Checking network identity of scanned Bluetooth mesh proxy: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                    if (this.networkIdMatches(serviceData, this.networkKey)) {
                        LOG.info("Network identity of scanned Bluetooth mesh proxy matches: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                        this.handleScannedPeripheral(peripheral, scanResult);
                    } else {
                        LOG.info("Network identity of scanned Bluetooth mesh proxy does NOT match: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                    }
                } else if (this.isAdvertisedWithNodeIdentity(serviceData)) {
                    LOG.info("Checking node identity of scanned Bluetooth mesh proxy: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                    if (this.checkIfNodeIdentityMatches(serviceData)) {
                        LOG.info("Node identity of scanned Bluetooth mesh proxy matches: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                        this.handleScannedPeripheral(peripheral, scanResult);
                    } else {
                        LOG.info("Node identity of scanned Bluetooth mesh proxy does NOT match: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                    }
                } else {
                    LOG.info("Could NOT find network or node identity in advertisement of Bluetooth mesh proxy: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                }
            } else {
                LOG.warning("Could NOT find service data in advertisement of Bluetooth mesh proxy [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "] for mesh proxy service UUID:" + MESH_PROXY_UUID.toString());
            }
        }
    }

    public synchronized void onScanFailed(int errorCode) {
        if (this.isStarted) {
            this.stop();
            this.executorService.execute(() -> {
                if (this.callback != null) {
                    this.callback.onMeshProxiesScanned(new ArrayList<BluetoothMeshProxy>(), errorCode);
                }
            });
        }
    }

    private void handleScannedPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        if (this.address == null || this.address != null && this.address.equalsIgnoreCase(peripheral.getAddress())) {
            this.meshProxyMap.put(peripheral.getAddress(), new BluetoothMeshProxy(this.bluetoothCommandSerializer, this.executorService, this.bluetoothCentral, peripheral, scanResult));
        }
        if (this.address != null && this.meshProxyMap.size() == 1) {
            this.executeCallbackAndStopScanner();
        }
    }

    private void executeCallbackAndStopScanner() {
        if (this.isStarted && this.callback != null) {
            List proxies = this.meshProxyMap.values().stream().sorted(Comparator.comparingInt(BluetoothMeshProxy::getRssi).reversed()).collect(Collectors.toList());
            this.executorService.execute(() -> this.callback.onMeshProxiesScanned(proxies, null));
        }
        this.stop();
    }

    private boolean isAdvertisingWithNetworkIdentity(byte[] serviceData) {
        return serviceData != null && serviceData.length == 9 && serviceData[0] == 0;
    }

    private boolean networkIdMatches(byte[] serviceData, NetworkKey networkKey) {
        byte[] advertisedNetworkId = this.getAdvertisedNetworkId(serviceData);
        return advertisedNetworkId != null && Arrays.equals(networkKey.getNetworkId(), advertisedNetworkId);
    }

    private byte[] getAdvertisedNetworkId(byte[] serviceData) {
        if (serviceData == null) {
            return null;
        }
        ByteBuffer advertisedNetworkID = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        advertisedNetworkID.put(serviceData, 1, 8);
        return advertisedNetworkID.array();
    }

    private boolean isAdvertisedWithNodeIdentity(byte[] serviceData) {
        return serviceData != null && serviceData.length == 17 && serviceData[0] == 1;
    }

    private boolean checkIfNodeIdentityMatches(byte[] serviceData) {
        return false;
    }
}

