/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothGattCharacteristic;
import com.welie.blessed.BluetoothGattDescriptor;
import com.welie.blessed.BluetoothGattService;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.ScanResult;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyConnectCallback;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyRxCallback;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxySendDataCallback;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyStateMachine;
import org.openremote.agent.protocol.bluetooth.mesh.MainThreadManager;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.syslog.SyslogCategory;

public class BluetoothMeshProxy
extends BluetoothCentralManagerCallback {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)BluetoothMeshProxy.class.getName());
    public static final UUID MESH_PROXY_UUID = UUID.fromString("00001828-0000-1000-8000-00805F9B34FB");
    public static final UUID MESH_PROXY_DATA_IN = UUID.fromString("00002ADD-0000-1000-8000-00805F9B34FB");
    public static final UUID MESH_PROXY_DATA_OUT = UUID.fromString("00002ADE-0000-1000-8000-00805F9B34FB");
    private final BluetoothPeripheralCallbackImpl peripheralCallback;
    private final ScanResult scanResult;
    private int rssi;
    private final BluetoothMeshProxyStateMachine stateMachine;

    public BluetoothMeshProxy(MainThreadManager bluetoothCommandSerializer, ScheduledExecutorService executorService, BluetoothCentralManager central, BluetoothPeripheral peripheral, ScanResult scanResult) {
        this.scanResult = scanResult;
        this.rssi = scanResult.getRssi();
        this.peripheralCallback = new BluetoothPeripheralCallbackImpl();
        this.stateMachine = new BluetoothMeshProxyStateMachine(this, central, executorService, bluetoothCommandSerializer, peripheral, this.peripheralCallback);
    }

    public synchronized void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        this.stateMachine.onConnectedPeripheral(peripheral);
    }

    public synchronized void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        this.stateMachine.onConnectionFailed(peripheral, status);
    }

    public synchronized void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        this.stateMachine.onDisconnectedPeripheral(peripheral, status);
    }

    public synchronized void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        this.stateMachine.onDiscoveredPeripheral(peripheral, scanResult);
    }

    public synchronized void onScanFailed(int errorCode) {
    }

    public synchronized void connect(Consumer<ConnectionStatus> statusConsumer, BluetoothMeshProxyConnectCallback callback) {
        this.stateMachine.connect(statusConsumer, callback);
    }

    public synchronized void disconnect() {
        this.stateMachine.disconnect();
    }

    public synchronized void sendData(int mtuSize, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        this.stateMachine.sendData(mtuSize, data, callback);
    }

    public synchronized void setRxDataCallback(BluetoothMeshProxyRxCallback callback) {
        this.stateMachine.setRxDataCallback(callback);
    }

    public synchronized BluetoothPeripheral getPeripheral() {
        return this.stateMachine.getPeripheral();
    }

    public synchronized ScanResult getScanResult() {
        return this.scanResult;
    }

    public synchronized int getRssi() {
        return this.rssi;
    }

    public synchronized boolean isConnected() {
        return this.stateMachine.isConnected();
    }

    private class BluetoothPeripheralCallbackImpl
    extends BluetoothPeripheralCallback {
        private BluetoothPeripheralCallbackImpl() {
        }

        public void onServicesDiscovered(BluetoothPeripheral peripheral, List<BluetoothGattService> services) {
            LOG.info("BluetoothPeripheralCallback::onServicesDiscovered: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
            BluetoothMeshProxy.this.stateMachine.onServicesDiscovered(peripheral, services);
        }

        public void onNotificationStateUpdate(BluetoothPeripheral peripheral, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
            LOG.info("BluetoothPeripheralCallback::onNotificationStateUpdate: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", Status=" + status + "]");
            BluetoothMeshProxy.this.stateMachine.onNotificationStateUpdate(peripheral, characteristic, status);
        }

        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
            LOG.info("BluetoothPeripheralCallback::onCharacteristicUpdate: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", Status=" + status + "]");
            BluetoothMeshProxy.this.stateMachine.onCharacteristicUpdate(peripheral, value, characteristic, status);
        }

        public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
            LOG.info("BluetoothPeripheralCallback::onCharacteristicWrite: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", Status=" + status + "]");
            BluetoothMeshProxy.this.stateMachine.onCharacteristicWrite(peripheral, value, characteristic, status);
        }

        public void onDescriptorRead(BluetoothPeripheral peripheral, byte[] value, BluetoothGattDescriptor descriptor, BluetoothCommandStatus status) {
            LOG.info("BluetoothPeripheralCallback::onDescriptorRead: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", Status=" + status + "]");
        }

        public void onDescriptorWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattDescriptor descriptor, BluetoothCommandStatus status) {
            LOG.info("BluetoothPeripheralCallback::onDescriptorWrite: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", Status=" + status + "]");
        }

        public void onBondingStarted(BluetoothPeripheral peripheral) {
            LOG.info("BluetoothPeripheralCallback::onBondingStarted: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
        }

        public void onBondingSucceeded(BluetoothPeripheral peripheral) {
            LOG.info("BluetoothPeripheralCallback::OnBondingSucceeded: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
        }

        public void onBondingFailed(BluetoothPeripheral peripheral) {
            LOG.info("BluetoothPeripheralCallback::onBondingFailed: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
        }

        public void onBondLost(BluetoothPeripheral peripheral) {
            LOG.info("BluetoothPeripheralCallback::onBondLost: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
        }

        public void onReadRemoteRssi(BluetoothPeripheral peripheral, int rssi, BluetoothCommandStatus status) {
            LOG.info("BluetoothPeripheralCallback::onReadRemoteRssi: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", RSSI=" + rssi + ", Status=" + status + "]");
        }
    }
}

