/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.ScanResult;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshAgent;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshAgentLink;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.MainThreadManager;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.SequenceNumberPersistencyManager;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.syslog.SyslogCategory;

public class BluetoothMeshProtocol
extends AbstractProtocol<BluetoothMeshAgent, BluetoothMeshAgentLink> {
    public static final String PROTOCOL_DISPLAY_NAME = "Bluetooth Mesh";
    public static final int DEFAULT_MTU = 20;
    public static final int DEFAULT_SEQUENCE_NUMBER = 1;
    public static final int DEFAULT_NETWORK_KEY_INDEX = 0;
    public static final int DEFAULT_APPLICATION_KEY_INDEX = 0;
    public static final String REGEXP_INDEX_AND_KEY = "^(\\s*(0|([1-9]+[0-9]*))\\s*:)?(\\s*[0-9A-Fa-f]{32}\\s*)";
    public static final String REGEXP_PROXY_ADDRESS = "^(?:[0-9A-Fa-f]{2}:){5}[0-9A-Fa-f]{2}$";
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)BluetoothMeshProtocol.class.getName());
    private static MainThreadManager mainThread = new MainThreadManager();
    private static ScheduledFuture<?> mainThreadFuture = null;
    private static BluetoothCentralManagerCallback bluetoothManagerCallback = new BluetoothCentralManagerCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectedPeripheral(BluetoothPeripheral peripheral) {
            LOG.info("BluetoothCentralManager::onConnectedPeripheral: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
            Class<BluetoothMeshProtocol> clazz = BluetoothMeshProtocol.class;
            synchronized (BluetoothMeshProtocol.class) {
                for (BluetoothMeshNetwork network : networkList) {
                    network.onConnectedPeripheral(peripheral);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
            LOG.info("BluetoothCentralManager::onConnectionFailed: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", Status=" + status + "]");
            Class<BluetoothMeshProtocol> clazz = BluetoothMeshProtocol.class;
            synchronized (BluetoothMeshProtocol.class) {
                for (BluetoothMeshNetwork network : networkList) {
                    network.onConnectionFailed(peripheral, status);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
            LOG.info("BluetoothCentralManager::onDisconnectedPeripheral: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", Status=" + status + "]");
            Class<BluetoothMeshProtocol> clazz = BluetoothMeshProtocol.class;
            synchronized (BluetoothMeshProtocol.class) {
                for (BluetoothMeshNetwork network : networkList) {
                    network.onDisconnectedPeripheral(peripheral, status);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
            LOG.info("BluetoothCentralManager::onDiscoveredPeripheral: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + ", ScanResult=" + scanResult + "]");
            Class<BluetoothMeshProtocol> clazz = BluetoothMeshProtocol.class;
            synchronized (BluetoothMeshProtocol.class) {
                for (BluetoothMeshNetwork network : networkList) {
                    network.onDiscoveredPeripheral(peripheral, scanResult);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanFailed(int errorCode) {
            LOG.info("BluetoothCentralManager::onScanFailed: [errorCode=" + errorCode + "]");
            Class<BluetoothMeshProtocol> clazz = BluetoothMeshProtocol.class;
            synchronized (BluetoothMeshProtocol.class) {
                for (BluetoothMeshNetwork network : networkList) {
                    network.onScanFailed(errorCode);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    };
    private static BluetoothCentralManager bluetoothCentral = new BluetoothCentralManager(bluetoothManagerCallback);
    private static List<BluetoothMeshNetwork> networkList = new LinkedList<BluetoothMeshNetwork>();
    private static SequenceNumberPersistencyManager sequenceNumberManager = new SequenceNumberPersistencyManager();
    private volatile BluetoothMeshNetwork meshNetwork;
    private final Map<AttributeRef, Consumer<Object>> sensorValueConsumerMap = new HashMap<AttributeRef, Consumer<Object>>();

    public static synchronized void initMainThread(ScheduledExecutorService executorService) {
        if (mainThreadFuture == null) {
            mainThreadFuture = executorService.schedule(mainThread, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static synchronized void addNetwork(BluetoothMeshNetwork network) {
        networkList.add(network);
    }

    public BluetoothMeshProtocol(BluetoothMeshAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    public String getProtocolInstanceUri() {
        return "bluetoothmesh://" + (this.meshNetwork != null && this.meshNetwork.getNetworkKey() != null ? MeshParserUtils.bytesToHex(this.meshNetwork.getNetworkKey().getKey(), false) : "");
    }

    @Override
    protected synchronized void doStart(Container container) throws Exception {
        LOG.info("Starting Bluetooth Mesh protocol.");
        String meshNetKeyParam = ((BluetoothMeshAgent)this.agent).getNetworkKey().orElseThrow(() -> {
            String msg = "No Bluetooth Mesh network key provided for protocol: " + this;
            LOG.warning(msg);
            return new IllegalArgumentException(msg);
        });
        Integer netKeyIndex = this.extractIndex(meshNetKeyParam, 0);
        String netKeyAsString = this.extractKey(meshNetKeyParam);
        if (netKeyIndex == null || netKeyAsString == null) {
            String msg = "Format of network key '" + meshNetKeyParam + "' is invalid for protocol: " + this;
            LOG.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        NetworkKey networkKey = new NetworkKey(netKeyIndex, MeshParserUtils.toByteArray(netKeyAsString));
        String meshAppKeyParam = ((BluetoothMeshAgent)this.agent).getApplicationKey().orElseThrow(() -> {
            String msg = "No Bluetooth Mesh application key provided for protocol: " + this;
            LOG.warning(msg);
            return new IllegalArgumentException(msg);
        });
        Integer appKeyIndex = this.extractIndex(meshAppKeyParam, 0);
        String appKeyAsString = this.extractKey(meshAppKeyParam);
        if (appKeyIndex == null || appKeyAsString == null) {
            String msg = "Format of application key '" + meshAppKeyParam + "' is invalid for protocol: " + this;
            LOG.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        ApplicationKey applicationKey = new ApplicationKey(appKeyIndex, MeshParserUtils.toByteArray(appKeyAsString));
        String proxyAddress = ((BluetoothMeshAgent)this.agent).getProxyAddress().orElse(null);
        String string = proxyAddress = proxyAddress != null ? proxyAddress.trim() : null;
        if (proxyAddress != null && !proxyAddress.matches(REGEXP_PROXY_ADDRESS)) {
            String msg = "Format of proxy address '" + proxyAddress + "' is invalid for protocol: " + this;
            LOG.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        String sourceAddressParam = ((BluetoothMeshAgent)this.agent).getSourceAddress().orElseThrow(() -> {
            String msg = "No Bluetooth Mesh unicast source address provided for protocol: " + this;
            LOG.warning(msg);
            return new IllegalArgumentException(msg);
        });
        Integer sourceAddress = this.toIntegerAddress(sourceAddressParam, null);
        if (sourceAddress == null) {
            String msg = "Format of Bluetooth Mesh unicast source address '" + sourceAddressParam + "' is invalid for protocol: " + this;
            throw new IllegalArgumentException(msg);
        }
        int sequenceNumberParam = ((BluetoothMeshAgent)this.agent).getSequenceNumber().orElse(1);
        int mtuParam = ((BluetoothMeshAgent)this.agent).getMtu().orElse(20);
        HashMap<Integer, ApplicationKey> applicationKeyMap = new HashMap<Integer, ApplicationKey>();
        applicationKeyMap.put(appKeyIndex, applicationKey);
        final ScheduledExecutorService finalExecutorService = this.executorService;
        Consumer<ConnectionStatus> statusConsumer = new Consumer<ConnectionStatus>(){

            @Override
            public void accept(ConnectionStatus connectionStatus) {
                BluetoothMeshProtocol.this.setConnectionStatus(connectionStatus);
                if (connectionStatus == ConnectionStatus.CONNECTED) {
                    finalExecutorService.execute(() -> BluetoothMeshProtocol.this.updateAllAttributes());
                }
            }
        };
        sequenceNumberManager.load();
        Integer oldSequenceNumber = sequenceNumberManager.getSequenceNumber(networkKey, sourceAddress);
        if (oldSequenceNumber == null) {
            oldSequenceNumber = sequenceNumberParam;
            sequenceNumberManager.save(networkKey, sourceAddress, oldSequenceNumber);
        }
        BluetoothMeshProtocol.initMainThread(this.executorService);
        this.meshNetwork = new BluetoothMeshNetwork(bluetoothCentral, sequenceNumberManager, mainThread, proxyAddress, sourceAddress, networkKey, applicationKeyMap, mtuParam, oldSequenceNumber, this.executorService, statusConsumer);
        BluetoothMeshProtocol.addNetwork(this.meshNetwork);
        mainThread.enqueue(() -> this.meshNetwork.start());
    }

    @Override
    protected synchronized void doStop(Container container) throws Exception {
        LOG.info("Stopping Bluetooth Mesh protocol.");
        if (this.meshNetwork != null) {
            this.meshNetwork.stop();
            this.meshNetwork = null;
        }
    }

    @Override
    protected synchronized void doLinkAttribute(String assetId, Attribute<?> attribute, BluetoothMeshAgentLink agentLink) throws RuntimeException {
        if (this.meshNetwork == null) {
            return;
        }
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        Integer appKeyIndex = (Integer)AgentLink.getOrThrowAgentLinkProperty(agentLink.getAppKeyIndex(), (String)"Bluetooth Mesh Application Key Index");
        String modelName = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getModelName(), (String)"Bluetooth Mesh Model Name");
        Integer modelId = this.toModelId(modelName, attributeRef);
        if (modelId == null) {
            return;
        }
        String addressAsString = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getAddress(), (String)"Bluetooth Mesh Address");
        Integer address = this.toIntegerAddress(addressAsString, attributeRef);
        if (address == null) {
            return;
        }
        LOG.info("Linking Bluetooth Mesh attribute: [address: '" + String.format("0x%04X", address) + "', model: '" + modelName + "', appKeyIndex: '" + appKeyIndex + "'] - " + attributeRef);
        Class clazz = attribute == null ? null : attribute.getType().getType();
        Consumer<Object> sensorValueConsumer = value -> this.updateLinkedAttribute(new AttributeState(attributeRef, this.toAttributeValue(value, clazz)));
        this.sensorValueConsumerMap.put(attributeRef, sensorValueConsumer);
        this.meshNetwork.addMeshModel(address, modelId, appKeyIndex);
        this.meshNetwork.addSensorValueConsumer(address, modelId, sensorValueConsumer);
        if (this.meshNetwork.isConnected()) {
            this.meshNetwork.sendMeshGetCommand(address, modelId);
        }
    }

    @Override
    protected synchronized void doUnlinkAttribute(String assetId, Attribute<?> attribute, BluetoothMeshAgentLink agentLink) {
        if (this.meshNetwork == null) {
            return;
        }
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        Integer appKeyIndex = (Integer)AgentLink.getOrThrowAgentLinkProperty(agentLink.getAppKeyIndex(), (String)"Bluetooth Mesh Application Key Index");
        String modelName = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getModelName(), (String)"Bluetooth Mesh Model Name");
        Integer modelId = this.toModelId(modelName, attributeRef);
        if (modelId == null) {
            return;
        }
        String addressAsString = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getAddress(), (String)"Bluetooth Mesh Address");
        Integer address = this.toIntegerAddress(addressAsString, attributeRef);
        if (address == null) {
            return;
        }
        LOG.info("Unlinking Bluetooth Mesh attribute: [address: '" + String.format("0x%04X", address) + "', model: '" + modelName + "', appKeyIndex: '" + appKeyIndex + "'] - " + attributeRef);
        Consumer<Object> sensorValueConsumer = this.sensorValueConsumerMap.remove(attributeRef);
        this.meshNetwork.removeSensorValueConsumer(address, modelId, sensorValueConsumer);
    }

    @Override
    protected synchronized void doLinkedAttributeWrite(Attribute<?> attribute, BluetoothMeshAgentLink agentLink, AttributeEvent event, Object processedValue) {
        if (this.meshNetwork == null) {
            return;
        }
        Integer appKeyIndex = (Integer)AgentLink.getOrThrowAgentLinkProperty(agentLink.getAppKeyIndex(), (String)"Bluetooth Mesh Application Key Index");
        String modelName = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getModelName(), (String)"Bluetooth Mesh Model Name");
        Integer modelId = this.toModelId(modelName, null);
        if (modelId == null) {
            return;
        }
        String addressAsString = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getAddress(), (String)"Bluetooth Mesh Address");
        Integer address = this.toIntegerAddress(addressAsString, null);
        if (address == null) {
            return;
        }
        LOG.info("Writing Bluetooth Mesh attribute: [address: '" + String.format("0x%04X", address) + "', model: '" + modelName + "', appKeyIndex: '" + appKeyIndex + "', value: '" + processedValue + "']");
        this.meshNetwork.sendMeshSetCommand(address, modelId, processedValue);
        this.meshNetwork.sendMeshGetCommand(address, modelId);
    }

    private synchronized void updateAllAttributes() {
        if (this.meshNetwork != null) {
            this.meshNetwork.sendMeshGetCommands();
        }
    }

    private Integer extractIndex(String indexAndKey, int defaultIndex) {
        Integer index = null;
        if (indexAndKey.matches(REGEXP_INDEX_AND_KEY)) {
            String[] indexAndKeyArr = indexAndKey.split(":");
            if (indexAndKeyArr.length == 2) {
                try {
                    index = Integer.decode(indexAndKeyArr[0].trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                index = defaultIndex;
            }
        }
        return index;
    }

    private String extractKey(String indexAndKey) {
        String key = null;
        if (indexAndKey.matches(REGEXP_INDEX_AND_KEY)) {
            String[] indexAndKeyArr;
            key = indexAndKeyArr[(indexAndKeyArr = indexAndKey.split(":")).length == 2 ? 1 : 0].trim();
        }
        return key;
    }

    private Integer toIntegerAddress(String addressAsString, AttributeRef attributeRef) {
        if (addressAsString == null) {
            return null;
        }
        Integer address = null;
        try {
            address = Integer.decode("0x" + addressAsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (address == null) {
            if (attributeRef != null) {
                LOG.warning("Format of Bluetooth Mesh unicast address value '" + addressAsString + "' is invalid for protocol attribute: " + attributeRef);
            } else {
                LOG.warning("Format of Bluetooth Mesh unicast address value '" + addressAsString + "' is invalid.");
            }
        }
        return address;
    }

    private Integer toModelId(String modelName, AttributeRef attributeRef) {
        if (modelName == null) {
            return null;
        }
        Integer modelId = null;
        if (modelName.toUpperCase().contains("ONOFF")) {
            modelId = 4096;
        }
        if (modelId == null) {
            if (attributeRef != null) {
                LOG.warning("Unknown or unsupported Bluetooth Mesh model name '" + modelName + "' for protocol attribute: " + attributeRef);
            } else {
                LOG.warning("Unknown or unsupported Bluetooth Mesh model name '" + modelName);
            }
        }
        return modelId;
    }

    private Object toAttributeValue(Object value, Class<?> clazz) {
        if (value == null || clazz == null) {
            return null;
        }
        Object retValue = null;
        if (clazz == String.class) {
            if (value instanceof Boolean) {
                retValue = (Boolean)value != false ? "On" : "Off";
            } else if (value instanceof Integer || value instanceof Double || value instanceof String) {
                retValue = value.toString();
            }
        } else if (clazz == Boolean.class) {
            if (value instanceof Boolean) {
                retValue = value;
            } else if (value instanceof String) {
                String strValue = ((String)value).trim().toUpperCase();
                if (strValue.equals("ON") || strValue.equals("TRUE") || strValue.equals("1")) {
                    retValue = true;
                } else if (strValue.equals("OFF") || strValue.equals("FALSE") || strValue.equals("0")) {
                    retValue = false;
                }
            } else if (value instanceof Integer) {
                retValue = (Integer)value == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            } else if (value instanceof Double) {
                retValue = (Double)value == 0.0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
        } else if (clazz == Integer.class) {
            if (value instanceof Boolean) {
                retValue = (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
            } else if (value instanceof String) {
                try {
                    retValue = Double.valueOf((String)value).intValue();
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (value instanceof Integer) {
                retValue = value;
            } else if (value instanceof Double) {
                retValue = ((Double)value).intValue();
            }
        }
        return retValue;
    }
}

