/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.ScanResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxy;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyConnectCallback;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyRxCallback;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyScanner;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxyScannerCallback;
import org.openremote.agent.protocol.bluetooth.mesh.MainThreadManager;
import org.openremote.agent.protocol.bluetooth.mesh.MeshManagerApi;
import org.openremote.agent.protocol.bluetooth.mesh.MeshManagerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.MeshStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.SequenceNumberPersistencyManager;
import org.openremote.agent.protocol.bluetooth.mesh.ShadowMeshElement;
import org.openremote.agent.protocol.bluetooth.mesh.ShadowMeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.SigModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.SigModelParser;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Element;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.syslog.SyslogCategory;

public class BluetoothMeshNetwork
extends BluetoothCentralManagerCallback
implements MeshManagerCallbacks,
MeshStatusCallbacks,
BluetoothMeshProxyRxCallback {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)BluetoothMeshNetwork.class.getName());
    public static final int SCAN_DURATION = 10000;
    private volatile BluetoothMeshProxyScanner proxyScanner;
    private volatile BluetoothMeshProxy bluetoothMeshProxy;
    private volatile MeshManagerApi meshManagerApi;
    private volatile boolean isStarted = false;
    private final ScheduledExecutorService executorService;
    private final BluetoothCentralManager bluetoothCentral;
    private final SequenceNumberPersistencyManager sequenceNumberManager;
    private final MainThreadManager mainThreadManager;
    private final Consumer<ConnectionStatus> statusConsumer;
    private final NetworkKey networkKey;
    private final String proxyAddress;
    private final int sourceUnicastAddress;
    private final Map<Integer, ApplicationKey> applicationKeyMap;
    private final Integer mtu;
    private final Map<Integer, ShadowMeshElement> elementMap = new HashMap<Integer, ShadowMeshElement>();

    public BluetoothMeshNetwork(BluetoothCentralManager bluetoothCentral, SequenceNumberPersistencyManager sequenceNumberManager, MainThreadManager mainThread, String proxyAddress, int unicastAddress, NetworkKey networkKey, Map<Integer, ApplicationKey> applicationKeyMap, int mtu, int sequenceNumber, ScheduledExecutorService executorService, Consumer<ConnectionStatus> statusConsumer) {
        this.bluetoothCentral = bluetoothCentral;
        this.sequenceNumberManager = sequenceNumberManager;
        this.mainThreadManager = mainThread;
        this.networkKey = networkKey;
        this.proxyAddress = proxyAddress;
        this.sourceUnicastAddress = unicastAddress;
        this.applicationKeyMap = applicationKeyMap;
        this.mtu = mtu;
        this.executorService = executorService;
        this.statusConsumer = statusConsumer;
        this.meshManagerApi = new MeshManagerApi(executorService);
        this.meshManagerApi.setMeshManagerCallbacks(this);
        this.meshManagerApi.setMeshStatusCallbacks(this);
        this.meshManagerApi.resetMeshNetwork(unicastAddress);
        MeshNetwork network = this.meshManagerApi.getMeshNetwork();
        network.addNetKey(networkKey);
        for (Map.Entry<Integer, ApplicationKey> keyEntry : applicationKeyMap.entrySet()) {
            network.addAppKey(keyEntry.getValue());
        }
        int provisionerAddress = this.getMeshNetwork().getSelectedProvisioner().getProvisionerAddress();
        ProvisionedMeshNode provisionerNode = this.getMeshNetwork().getNode(provisionerAddress);
        provisionerNode.setSequenceNumber(sequenceNumber);
    }

    public synchronized void onConnectedPeripheral(BluetoothPeripheral peripheral) {
        if (this.proxyScanner != null) {
            this.proxyScanner.onConnectedPeripheral(peripheral);
        }
        if (this.bluetoothMeshProxy != null) {
            this.bluetoothMeshProxy.onConnectedPeripheral(peripheral);
        }
    }

    public synchronized void onConnectionFailed(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        if (this.proxyScanner != null) {
            this.proxyScanner.onConnectionFailed(peripheral, status);
        }
        if (this.bluetoothMeshProxy != null) {
            this.bluetoothMeshProxy.onConnectionFailed(peripheral, status);
        }
    }

    public synchronized void onDisconnectedPeripheral(BluetoothPeripheral peripheral, BluetoothCommandStatus status) {
        if (this.proxyScanner != null) {
            this.proxyScanner.onDisconnectedPeripheral(peripheral, status);
        }
        if (this.bluetoothMeshProxy != null) {
            this.bluetoothMeshProxy.onDisconnectedPeripheral(peripheral, status);
        }
    }

    public synchronized void onDiscoveredPeripheral(BluetoothPeripheral peripheral, ScanResult scanResult) {
        if (this.proxyScanner != null) {
            this.proxyScanner.onDiscoveredPeripheral(peripheral, scanResult);
        }
        if (this.bluetoothMeshProxy != null) {
            this.bluetoothMeshProxy.onDiscoveredPeripheral(peripheral, scanResult);
        }
    }

    public synchronized void onScanFailed(int errorCode) {
        if (this.proxyScanner != null) {
            this.proxyScanner.onScanFailed(errorCode);
        }
        if (this.bluetoothMeshProxy != null) {
            this.bluetoothMeshProxy.onScanFailed(errorCode);
        }
    }

    @Override
    public void onNetworkLoaded(MeshNetwork meshNetwork) {
    }

    @Override
    public void onNetworkUpdated(MeshNetwork meshNetwork) {
    }

    @Override
    public void onNetworkLoadFailed(String error) {
    }

    @Override
    public void onNetworkImported(MeshNetwork meshNetwork) {
    }

    @Override
    public void onNetworkImportFailed(String error) {
    }

    @Override
    public void sendProvisioningPdu(UnprovisionedMeshNode meshNode, byte[] pdu) {
    }

    @Override
    public synchronized void onMeshPduCreated(byte[] pdu) {
        LOG.info("Sending PDU to mesh proxy: [data:" + this.dataAsHexString(pdu) + "]");
        if (this.bluetoothMeshProxy != null) {
            ProvisionedMeshNode sourceNode;
            this.bluetoothMeshProxy.sendData(this.getMtu(), pdu, (proxy, data, isSuccess) -> {
                if (isSuccess) {
                    LOG.info("Succeeded to send PDU to mesh proxy: [data:" + this.dataAsHexString(pdu) + "]");
                    this.meshManagerApi.handleWriteCallbacks(this.getMtu(), data);
                } else {
                    LOG.warning("Failed to send PDU to mesh proxy: [data:" + this.dataAsHexString(pdu) + "]");
                }
            });
            Integer sourceAddress = this.getMeshNetwork().getSelectedProvisioner().getProvisionerAddress();
            if (sourceAddress != null && (sourceNode = this.getMeshNetwork().getNode(sourceAddress)) != null) {
                int newSequenceNumber = sourceNode.getSequenceNumber();
                this.executorService.execute(() -> this.sequenceNumberManager.save(this.networkKey, this.sourceUnicastAddress, newSequenceNumber));
            }
        }
    }

    @Override
    public int getMtu() {
        return this.mtu;
    }

    @Override
    public synchronized void onRxData(byte[] data) {
        if (this.meshManagerApi != null) {
            this.meshManagerApi.handleNotifications(this.getMtu(), data);
        }
    }

    @Override
    public void onTransactionFailed(int dst, boolean hasIncompleteTimerExpired) {
    }

    @Override
    public void onUnknownPduReceived(int src, byte[] accessPayload) {
    }

    @Override
    public void onBlockAcknowledgementProcessed(int dst, ControlMessage message) {
    }

    @Override
    public void onBlockAcknowledgementReceived(int src, ControlMessage message) {
    }

    @Override
    public void onMeshMessageProcessed(int dst, MeshMessage meshMessage) {
    }

    @Override
    public synchronized void onMeshMessageReceived(int src, MeshMessage meshMessage) {
        LOG.info("Received mesh message: address='" + String.format("0x%04X", src) + "', message='" + meshMessage.getClass().getName() + "'");
        ShadowMeshElement element = this.elementMap.get(src);
        if (element != null) {
            element.onMeshMessageReceived(meshMessage);
        } else {
            LOG.info("Could not find element to process the received mesh message: address='" + String.format("0x%04X", src) + "', message='" + meshMessage.getClass().getName() + "'");
        }
    }

    @Override
    public void onMessageDecryptionFailed(String meshLayer, String errorMessage) {
        LOG.warning("Failed to decrypt Bluetooth mesh message: [meshLayer: '" + meshLayer + "', errorMessage: '" + errorMessage + "']");
    }

    public synchronized void start() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.connect();
    }

    public synchronized void stop() {
        this.isStarted = false;
        if (this.proxyScanner != null) {
            this.proxyScanner.stop();
            this.proxyScanner = null;
        }
        if (this.bluetoothMeshProxy != null) {
            this.bluetoothMeshProxy.disconnect();
            this.bluetoothMeshProxy = null;
        }
        this.bluetoothMeshProxy = null;
    }

    public synchronized boolean isConnected() {
        boolean isConnected = false;
        if (this.bluetoothMeshProxy != null) {
            isConnected = this.bluetoothMeshProxy.isConnected();
        }
        return isConnected;
    }

    public synchronized MeshManagerApi getMeshManagerApi() {
        return this.meshManagerApi;
    }

    public ApplicationKey getApplicationKey(int keyIndex) {
        return this.applicationKeyMap.get(keyIndex);
    }

    public NetworkKey getNetworkKey() {
        return this.networkKey;
    }

    public synchronized MeshNetwork getMeshNetwork() {
        MeshNetwork network = null;
        MeshManagerApi api = this.getMeshManagerApi();
        if (api != null) {
            network = api.getMeshNetwork();
        }
        return network;
    }

    public synchronized ProvisionedMeshNode getNode(int sourceAddress) {
        ProvisionedMeshNode node = null;
        MeshNetwork network = this.getMeshNetwork();
        if (network != null) {
            node = network.getNode(sourceAddress);
        }
        return node;
    }

    public synchronized void addMeshModel(int address, int modelId, int appKeyIndex) {
        MeshNetwork network = this.getMeshNetwork();
        SigModel model = SigModelParser.getSigModel(modelId);
        if (model == null) {
            LOG.severe("Bluetooth Mesh model with ID='" + String.format("0x%04X", modelId) + "' is not supported.");
            return;
        }
        if (address < 49152) {
            ProvisionedMeshNode node = this.getNode(address);
            if (node == null) {
                ArrayList<NetworkKey> networkKeys = new ArrayList<NetworkKey>(1);
                networkKeys.add(this.networkKey);
                ArrayList<ApplicationKey> applicationKeys = new ArrayList<ApplicationKey>(this.applicationKeyMap.size());
                applicationKeys.addAll(this.applicationKeyMap.values());
                node = new ProvisionedMeshNode(network.getSelectedProvisioner(), networkKeys, applicationKeys);
                node.setUnicastAddress(address);
            }
            Map<Integer, Element> oldElementMap = node.getElements();
            HashMap<Integer, Element> newElementMap = new HashMap<Integer, Element>();
            HashMap<Integer, MeshModel> newModelMap = new HashMap<Integer, MeshModel>();
            Element oldElement = oldElementMap.get(address);
            if (oldElement != null) {
                newModelMap.putAll(oldElement.getMeshModels());
            }
            int locationDescriptor = 0;
            model.setBoundAppKeyIndex(appKeyIndex);
            newModelMap.put(modelId, model);
            Element newElement = new Element(address, locationDescriptor, newModelMap);
            newElementMap.putAll(oldElementMap);
            newElementMap.put(address, newElement);
            node.setElements(newElementMap);
            if (this.getNode(address) == null) {
                network.nodes.add(node);
                network.sequenceNumbers.put(node.getUnicastAddress(), node.getSequenceNumber());
                network.unicastAddress = network.nextAvailableUnicastAddress(node.getNumberOfElements(), network.getSelectedProvisioner());
                node.setMeshUuid(network.getMeshUUID());
                network.loadSequenceNumbers();
            }
        }
        this.addShadowModel(address, modelId, appKeyIndex);
    }

    public synchronized void addSensorValueConsumer(int address, int modelId, Consumer<Object> consumer) {
        ShadowMeshModel model = this.searchShadowModel(address, modelId);
        if (model != null) {
            model.addSensorValueConsumer(consumer);
        }
    }

    public synchronized void removeSensorValueConsumer(int address, int modelId, Consumer<Object> consumer) {
        ShadowMeshModel model = this.searchShadowModel(address, modelId);
        if (model != null) {
            model.removeSensorValueConsumer(consumer);
        }
    }

    public synchronized void sendMeshSetCommand(int address, int modelId, Object value) {
        if (this.isConnected()) {
            ShadowMeshModel model = this.searchShadowModel(address, modelId);
            if (model != null) {
                model.sendSetCommand(value);
            } else {
                SigModel sigModel = SigModelParser.getSigModel(modelId);
                String modelName = sigModel != null ? sigModel.getModelName() : String.format("0x%04X", modelId);
                LOG.warning("Failed to send mesh command value '" + value + "' because couldn't find mesh model: address:'" + String.format("0x%04X", address) + "', model: '" + modelName + "\"");
            }
        }
    }

    public synchronized void sendMeshGetCommand(int address, int modelId) {
        if (this.isConnected()) {
            ShadowMeshModel model = this.searchShadowModel(address, modelId);
            if (model != null) {
                model.sendGetCommand();
            } else {
                SigModel sigModel = SigModelParser.getSigModel(modelId);
                String modelName = sigModel != null ? sigModel.getModelName() : String.format("0x%04X", modelId);
                LOG.warning("Failed to send mesh get status command because couldn't find mesh model: address:'" + String.format("0x%04X", address) + "', model: '" + modelName + "\"");
            }
        }
    }

    public synchronized void sendMeshGetCommands(int address) {
        ShadowMeshElement element;
        if (this.isConnected() && (element = this.elementMap.get(address)) != null) {
            List<ShadowMeshModel> models = element.getMeshModels();
            for (ShadowMeshModel curModel : models) {
                this.sendMeshGetCommand(address, curModel.getModelId());
            }
        }
    }

    public synchronized void sendMeshGetCommands() {
        if (this.isConnected()) {
            for (Integer address : this.elementMap.keySet()) {
                this.sendMeshGetCommands(address);
            }
        }
    }

    private synchronized void connect() {
        this.bluetoothMeshProxy = null;
        if (this.proxyScanner != null) {
            this.proxyScanner.stop();
        }
        this.executorService.execute(() -> this.statusConsumer.accept(ConnectionStatus.CONNECTING));
        this.proxyScanner = new BluetoothMeshProxyScanner(this.mainThreadManager, this.bluetoothCentral, this.executorService);
        this.proxyScanner.start(this.networkKey, this.proxyAddress, 10000, new BluetoothMeshProxyScannerCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMeshProxiesScanned(List<BluetoothMeshProxy> meshProxies, Integer errorCode) {
                LOG.info("Finished scanning Bluetooth mesh proxies.");
                if (errorCode == null) {
                    for (BluetoothMeshProxy curMeshProxy : meshProxies) {
                        LOG.info("Scan found Bluetooth mesh proxy: [Name=" + curMeshProxy.getPeripheral().getName() + ", Address=" + curMeshProxy.getPeripheral().getAddress() + ", Rssi=" + curMeshProxy.getRssi() + "]");
                    }
                    if (meshProxies.size() > 0) {
                        BluetoothMeshNetwork bluetoothMeshNetwork = BluetoothMeshNetwork.this;
                        synchronized (bluetoothMeshNetwork) {
                            BluetoothMeshNetwork.this.bluetoothMeshProxy = meshProxies.get(0);
                            BluetoothMeshNetwork.this.bluetoothMeshProxy.setRxDataCallback(BluetoothMeshNetwork.this);
                            BluetoothMeshNetwork.this.bluetoothMeshProxy.connect(BluetoothMeshNetwork.this.statusConsumer, new BluetoothMeshProxyConnectCallback(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onMeshProxyConnected(BluetoothPeripheral peripheral, boolean isSuccess, boolean isConnectionLoss) {
                                    BluetoothMeshNetwork bluetoothMeshNetwork = BluetoothMeshNetwork.this;
                                    synchronized (bluetoothMeshNetwork) {
                                        if (isSuccess) {
                                            LOG.info("Successfully connected to Bluetooth mesh proxy: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                                        } else {
                                            LOG.warning("Failed to connect to Bluetooth mesh proxy: [Name=" + peripheral.getName() + ", Address=" + peripheral.getAddress() + "]");
                                            BluetoothMeshNetwork.this.bluetoothMeshProxy = null;
                                            BluetoothMeshNetwork.this.executorService.execute(() -> BluetoothMeshNetwork.this.connect());
                                        }
                                    }
                                }
                            });
                        }
                    } else {
                        LOG.info("No Bluetooth mesh proxy found!");
                        BluetoothMeshNetwork.this.executorService.execute(() -> BluetoothMeshNetwork.this.connect());
                    }
                } else {
                    LOG.info("Failed to scan Bluetooth mesh proxies: [error code=" + errorCode + "]");
                    BluetoothMeshNetwork.this.executorService.execute(() -> BluetoothMeshNetwork.this.statusConsumer.accept(ConnectionStatus.ERROR));
                }
            }
        });
    }

    private ShadowMeshModel searchShadowModel(int address, int modelId) {
        ShadowMeshModel model = null;
        ShadowMeshElement element = this.elementMap.get(address);
        if (element != null) {
            model = element.searchShadowModel(modelId);
        }
        return model;
    }

    private void addShadowModel(int address, int modelId, int appKeyIndex) {
        if (!this.elementMap.containsKey(address)) {
            this.elementMap.put(address, new ShadowMeshElement(this.executorService, this, address));
        }
        ShadowMeshElement element = this.elementMap.get(address);
        element.addShadowModel(modelId, appKeyIndex);
    }

    private String dataAsHexString(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            builder.append(String.format("0x%02X%s", data[i] & 0xFF, i == data.length - 1 ? "" : ", "));
        }
        return builder.toString();
    }
}

