/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.openremote.model.asset.agent.AgentLink;

public class BluetoothMeshAgentLink
extends AgentLink<BluetoothMeshAgentLink> {
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    @NotNull
    protected @Min(value=0L) @Max(value=0x7FFFFFFFL) @NotNull Integer appKeyIndex;
    @Pattern(regexp="^([0-9A-Fa-f]{4})$")
    protected @Pattern(regexp="^([0-9A-Fa-f]{4})$") String address;
    @NotBlank
    protected String modelName;

    protected BluetoothMeshAgentLink() {
    }

    public BluetoothMeshAgentLink(String id, Integer appKeyIndex, String address, String modelName) {
        super(id);
        this.appKeyIndex = appKeyIndex;
        this.address = address;
        this.modelName = modelName;
    }

    public Optional<Integer> getAppKeyIndex() {
        return Optional.ofNullable(this.appKeyIndex);
    }

    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    public Optional<String> getModelName() {
        return Optional.ofNullable(this.modelName);
    }
}

