/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.Optional;
import javax.persistence.Entity;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshAgentLink;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProtocol;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.AgentDescriptor;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueType;

@Entity
public class BluetoothMeshAgent
extends Agent<BluetoothMeshAgent, BluetoothMeshProtocol, BluetoothMeshAgentLink> {
    public static final AttributeDescriptor<String> NETWORK_KEY = new AttributeDescriptor("networkKey", ValueType.TEXT);
    public static final AttributeDescriptor<String> APPLICATION_KEY = new AttributeDescriptor("applicationKey", ValueType.TEXT);
    public static final AttributeDescriptor<String> PROXY_ADDRESS = new AttributeDescriptor("proxyAddress", ValueType.TEXT);
    public static final AttributeDescriptor<String> SOURCE_ADDRESS = new AttributeDescriptor("sourceAddress", ValueType.TEXT);
    public static final AttributeDescriptor<Integer> SEQUENCE_NUMBER = new AttributeDescriptor("sequenceNumber", ValueType.POSITIVE_INTEGER);
    public static final AttributeDescriptor<Integer> MTU = new AttributeDescriptor("mtu", ValueType.POSITIVE_INTEGER);
    public static AgentDescriptor<BluetoothMeshAgent, BluetoothMeshProtocol, BluetoothMeshAgentLink> DESCRIPTOR = new AgentDescriptor(BluetoothMeshAgent.class, BluetoothMeshProtocol.class, BluetoothMeshAgentLink.class, null);

    protected BluetoothMeshAgent() {
    }

    public BluetoothMeshAgent(String name) {
        super(name);
    }

    public BluetoothMeshProtocol getProtocolInstance() {
        return new BluetoothMeshProtocol(this);
    }

    public Optional<String> getNetworkKey() {
        return this.getAttributes().getValue(NETWORK_KEY);
    }

    public BluetoothMeshAgent setNetworkKey(String value) {
        this.getAttributes().getOrCreate(NETWORK_KEY).setValue((Object)value);
        return this;
    }

    public Optional<String> getApplicationKey() {
        return this.getAttributes().getValue(APPLICATION_KEY);
    }

    public BluetoothMeshAgent setApplicationKey(String value) {
        this.getAttributes().getOrCreate(APPLICATION_KEY).setValue((Object)value);
        return this;
    }

    public Optional<String> getProxyAddress() {
        return this.getAttributes().getValue(PROXY_ADDRESS);
    }

    public BluetoothMeshAgent setProxyAddress(String value) {
        this.getAttributes().getOrCreate(PROXY_ADDRESS).setValue((Object)value);
        return this;
    }

    public Optional<String> getSourceAddress() {
        return this.getAttributes().getValue(SOURCE_ADDRESS);
    }

    public BluetoothMeshAgent setSourceAddress(String value) {
        this.getAttributes().getOrCreate(SOURCE_ADDRESS).setValue((Object)value);
        return this;
    }

    public Optional<Integer> getSequenceNumber() {
        return this.getAttributes().getValue(SEQUENCE_NUMBER);
    }

    public BluetoothMeshAgent setSequenceNumber(Integer value) {
        this.getAttributes().getOrCreate(SEQUENCE_NUMBER).setValue((Object)value);
        return this;
    }

    public Optional<Integer> getMtu() {
        return this.getAttributes().getValue(MTU);
    }

    public BluetoothMeshAgent setMtu(Integer value) {
        this.getAttributes().getOrCreate(MTU).setValue((Object)value);
        return this;
    }
}

