/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedGroupRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedSceneRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedUnicastRange;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.Group;
import org.openremote.agent.protocol.bluetooth.mesh.IvIndex;
import org.openremote.agent.protocol.bluetooth.mesh.MeshKey;
import org.openremote.agent.protocol.bluetooth.mesh.MeshNetworkCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.NodeKey;
import org.openremote.agent.protocol.bluetooth.mesh.Provisioner;
import org.openremote.agent.protocol.bluetooth.mesh.Scene;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ProxyFilter;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public abstract class BaseMeshNetwork {
    public static final Logger LOG = Logger.getLogger(BaseMeshNetwork.class.getName());
    public static final int NORMAL_OPERATION = 0;
    public static final int IV_UPDATE_ACTIVE = 1;
    final String meshUUID;
    protected final Comparator<ApplicationKey> appKeyComparator = (key1, key2) -> Integer.compare(key1.getKeyIndex(), key2.getKeyIndex());
    protected final Comparator<NetworkKey> netKeyComparator = (key1, key2) -> Integer.compare(key1.getKeyIndex(), key2.getKeyIndex());
    protected MeshNetworkCallbacks mCallbacks;
    String schema = "http://json-schema.org/draft-04/schema#";
    String id = "http://www.bluetooth.com/specifications/assigned-numbers/mesh-profile/cdb-schema.json#";
    String version = "1.0";
    String meshName = "nRF Mesh Network";
    long timestamp = System.currentTimeMillis();
    boolean partial = false;
    IvIndex ivIndex = new IvIndex(0, false, Calendar.getInstance());
    List<NetworkKey> netKeys = new ArrayList<NetworkKey>();
    List<ApplicationKey> appKeys = new ArrayList<ApplicationKey>();
    List<Provisioner> provisioners = new ArrayList<Provisioner>();
    List<ProvisionedMeshNode> nodes = new ArrayList<ProvisionedMeshNode>();
    List<Group> groups = new ArrayList<Group>();
    List<Scene> scenes = new ArrayList<Scene>();
    protected Map<Integer, ArrayList<Integer>> networkExclusions = new HashMap<Integer, ArrayList<Integer>>();
    int unicastAddress = 1;
    boolean lastSelected;
    protected Map<Integer, Integer> sequenceNumbers = new HashMap<Integer, Integer>();
    private ProxyFilter proxyFilter;
    protected final Comparator<ProvisionedMeshNode> nodeComparator = (node1, node2) -> Integer.compare(node1.getUnicastAddress(), node2.getUnicastAddress());
    protected final Comparator<Group> groupComparator = (group1, group2) -> Integer.compare(group1.getAddress(), group2.getAddress());
    protected final Comparator<AllocatedUnicastRange> unicastRangeComparator = (range1, range2) -> Integer.compare(range1.getLowAddress(), range2.getLowAddress());
    protected final Comparator<AllocatedGroupRange> groupRangeComparator = (range1, range2) -> Integer.compare(range1.getLowAddress(), range2.getLowAddress());
    protected final Comparator<AllocatedSceneRange> sceneRangeComparator = (range1, range2) -> Integer.compare(range1.getFirstScene(), range2.getFirstScene());

    BaseMeshNetwork(String meshUUID) {
        this.meshUUID = meshUUID;
    }

    private boolean isNetKeyExists(byte[] key) {
        for (int i = 0; i < this.netKeys.size(); ++i) {
            if (!Arrays.equals(key, this.netKeys.get(i).getKey())) continue;
            return true;
        }
        return false;
    }

    public synchronized NetworkKey createNetworkKey() throws IllegalArgumentException {
        NetworkKey key = new NetworkKey(this.getAvailableNetKeyIndex(), MeshParserUtils.toByteArray(SecureUtils.generateRandomNetworkKey()));
        key.setMeshUuid(this.meshUUID);
        return key;
    }

    public synchronized boolean addNetKey(NetworkKey newNetKey) {
        if (this.isNetKeyExists(newNetKey.getKey())) {
            throw new IllegalArgumentException("Net key already exists, check the contents of the key!");
        }
        newNetKey.setMeshUuid(this.meshUUID);
        this.netKeys.add(newNetKey);
        this.notifyNetKeyAdded(newNetKey);
        return true;
    }

    private int getAvailableNetKeyIndex() {
        if (this.netKeys.isEmpty()) {
            return 0;
        }
        Collections.sort(this.netKeys, this.netKeyComparator);
        int index = this.netKeys.size() - 1;
        return this.netKeys.get(index).getKeyIndex() + 1;
    }

    public synchronized boolean updateNetKey(NetworkKey networkKey, String newNetKey) throws IllegalArgumentException {
        if (MeshParserUtils.validateKeyInput(newNetKey)) {
            byte[] key = MeshParserUtils.toByteArray(newNetKey);
            if (this.isNetKeyExists(key)) {
                throw new IllegalArgumentException("Net key value is already in use.");
            }
            int keyIndex = networkKey.getKeyIndex();
            NetworkKey netKey = this.getNetKey(keyIndex);
            if (!this.isKeyInUse(netKey)) {
                if (netKey.equals(networkKey)) {
                    netKey.setKey(key);
                    return this.updateMeshKey(netKey);
                }
                return false;
            }
            throw new IllegalArgumentException("Unable to update a network key that's already in use. ");
        }
        return false;
    }

    public synchronized boolean updateNetKey(NetworkKey networkKey) throws IllegalArgumentException {
        int keyIndex = networkKey.getKeyIndex();
        NetworkKey key = this.getNetKey(keyIndex);
        if (key.equals(networkKey)) {
            return this.updateMeshKey(networkKey);
        }
        if (!this.isKeyInUse(key)) {
            return this.updateMeshKey(networkKey);
        }
        throw new IllegalArgumentException("Unable to update a network key that's already in use.");
    }

    public synchronized NetworkKey distributeNetKey(NetworkKey networkKey, byte[] newNetKey) throws IllegalArgumentException {
        if (this.validateKey(newNetKey)) {
            if (this.isNetKeyExists(newNetKey)) {
                throw new IllegalArgumentException("Net key value is already in use.");
            }
            int keyIndex = networkKey.getKeyIndex();
            NetworkKey netKey = this.getNetKey(keyIndex);
            if (netKey.equals(networkKey) && netKey.distributeKey(newNetKey)) {
                this.updateNodeKeyStatus(netKey);
                if (this.updateMeshKey(netKey)) {
                    return netKey;
                }
            }
        }
        return null;
    }

    private void updateNodeKeyStatus(MeshKey meshKey) {
        for (Provisioner provisioner : this.provisioners) {
            for (ProvisionedMeshNode node : this.nodes) {
                if (!node.getUuid().equalsIgnoreCase(provisioner.getProvisionerUuid())) continue;
                if (meshKey instanceof NetworkKey) {
                    for (NodeKey key : node.getAddedNetKeys()) {
                        if (key.getIndex() != meshKey.getKeyIndex()) continue;
                        key.setUpdated(true);
                    }
                    continue;
                }
                for (NodeKey key : node.getAddedAppKeys()) {
                    if (key.getIndex() != meshKey.getKeyIndex()) continue;
                    key.setUpdated(true);
                }
            }
        }
    }

    public synchronized boolean switchToNewKey(NetworkKey networkKey) throws IllegalArgumentException {
        if (!this.netKeys.contains(networkKey)) {
            throw new IllegalArgumentException("Network Key not distributed");
        }
        return networkKey.switchToNewKey();
    }

    public boolean revokeOldKey(NetworkKey networkKey) {
        if (this.netKeys.contains(networkKey)) {
            return networkKey.revokeOldKey();
        }
        return false;
    }

    public synchronized boolean removeNetKey(NetworkKey networkKey) throws IllegalArgumentException {
        if (!this.isKeyInUse(networkKey)) {
            if (this.netKeys.remove(networkKey)) {
                this.notifyNetKeyDeleted(networkKey);
                return true;
            }
            throw new IllegalArgumentException("Key does not exist.");
        }
        throw new IllegalArgumentException("Unable to delete a network key that's already in use.");
    }

    public synchronized NetworkKey getNetKey(int keyIndex) {
        for (NetworkKey key : this.netKeys) {
            if (keyIndex != key.getKeyIndex()) continue;
            try {
                return key.clone();
            }
            catch (CloneNotSupportedException e) {
                LOG.severe("Error while cloning key: " + e.getMessage());
            }
        }
        return null;
    }

    public synchronized ApplicationKey createAppKey() throws IllegalArgumentException {
        if (this.netKeys.isEmpty()) {
            throw new IllegalStateException("Cannot create an App Key without a Network key. Consider creating a network key first");
        }
        ApplicationKey key = new ApplicationKey(this.getAvailableAppKeyIndex(), MeshParserUtils.toByteArray(SecureUtils.generateRandomApplicationKey()));
        key.setMeshUuid(this.meshUUID);
        return key;
    }

    public synchronized boolean addAppKey(ApplicationKey newAppKey) {
        if (this.netKeys.isEmpty()) {
            throw new IllegalStateException("Cannot create an App Key without a Network key. Consider creating a network key first");
        }
        if (this.isAppKeyExists(newAppKey.getKey())) {
            throw new IllegalArgumentException("App key already exists, check the contents of the key!");
        }
        newAppKey.setMeshUuid(this.meshUUID);
        this.appKeys.add(newAppKey);
        this.notifyAppKeyAdded(newAppKey);
        return true;
    }

    private int getAvailableAppKeyIndex() {
        if (this.appKeys.isEmpty()) {
            return 0;
        }
        Collections.sort(this.appKeys, this.appKeyComparator);
        int index = this.appKeys.size() - 1;
        return this.appKeys.get(index).getKeyIndex() + 1;
    }

    public synchronized ApplicationKey getAppKey(int keyIndex) {
        for (ApplicationKey key : this.appKeys) {
            if (keyIndex != key.getKeyIndex()) continue;
            try {
                return key.clone();
            }
            catch (CloneNotSupportedException e) {
                LOG.severe("Error while cloning key: " + e.getMessage());
            }
        }
        return null;
    }

    protected synchronized List<ApplicationKey> getAppKeys(int boundNetKeyIndex) {
        ArrayList<ApplicationKey> applicationKeys = new ArrayList<ApplicationKey>();
        for (ApplicationKey applicationKey : this.appKeys) {
            if (applicationKey.getBoundNetKeyIndex() != boundNetKeyIndex) continue;
            applicationKeys.add(applicationKey);
        }
        return applicationKeys;
    }

    private boolean isAppKeyExists(byte[] appKey) {
        for (int i = 0; i < this.appKeys.size(); ++i) {
            ApplicationKey applicationKey = this.appKeys.get(i);
            if (!Arrays.equals(applicationKey.getKey(), appKey)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean updateAppKey(ApplicationKey applicationKey, String newAppKey) throws IllegalArgumentException {
        if (MeshParserUtils.validateKeyInput(newAppKey)) {
            byte[] key = MeshParserUtils.toByteArray(newAppKey);
            if (this.isNetKeyExists(key)) {
                throw new IllegalArgumentException("Net key already in use");
            }
            int keyIndex = applicationKey.getKeyIndex();
            ApplicationKey appKey = this.getAppKey(keyIndex);
            if (!this.isKeyInUse(appKey)) {
                if (appKey.equals(applicationKey)) {
                    appKey.setKey(key);
                    return this.updateMeshKey(appKey);
                }
                return false;
            }
            throw new IllegalArgumentException("Unable to update a application key that's already in use.");
        }
        return false;
    }

    public synchronized boolean updateAppKey(ApplicationKey applicationKey) throws IllegalArgumentException {
        int keyIndex = applicationKey.getKeyIndex();
        ApplicationKey key = this.getAppKey(keyIndex);
        if (!this.isKeyInUse(key)) {
            return this.updateMeshKey(applicationKey);
        }
        throw new IllegalArgumentException("Unable to update a application key that's already in use.");
    }

    public synchronized ApplicationKey distributeAppKey(ApplicationKey applicationKey, byte[] newAppKey) throws IllegalArgumentException {
        if (this.validateKey(newAppKey)) {
            if (this.isAppKeyExists(newAppKey)) {
                throw new IllegalArgumentException("App key value is already in use.");
            }
            int keyIndex = applicationKey.getKeyIndex();
            ApplicationKey appKey = this.getAppKey(keyIndex);
            if (appKey.equals(applicationKey) && appKey.distributeKey(newAppKey)) {
                this.updateNodeKeyStatus(appKey);
                if (this.updateMeshKey(appKey)) {
                    return appKey;
                }
            }
        }
        return null;
    }

    private boolean updateMeshKey(MeshKey key) {
        if (key instanceof ApplicationKey) {
            ApplicationKey appKey = null;
            for (int i = 0; i < this.appKeys.size(); ++i) {
                ApplicationKey tempKey = this.appKeys.get(i);
                if (tempKey.getKeyIndex() != key.getKeyIndex()) continue;
                appKey = (ApplicationKey)key;
                this.appKeys.set(i, appKey);
                break;
            }
            if (appKey != null) {
                this.notifyAppKeyUpdated(appKey);
                return true;
            }
        } else {
            NetworkKey netKey = null;
            for (int i = 0; i < this.netKeys.size(); ++i) {
                NetworkKey tempKey = this.netKeys.get(i);
                if (tempKey.getKeyIndex() != key.getKeyIndex()) continue;
                netKey = (NetworkKey)key;
                this.netKeys.set(i, netKey);
                break;
            }
            if (netKey != null) {
                netKey.setTimestamp(System.currentTimeMillis());
                this.notifyNetKeyUpdated(netKey);
                return true;
            }
        }
        return false;
    }

    public synchronized boolean removeAppKey(ApplicationKey appKey) throws IllegalArgumentException {
        if (this.isKeyInUse(appKey)) {
            throw new IllegalArgumentException("Unable to delete an app key that's in use.");
        }
        if (this.appKeys.remove(appKey)) {
            this.notifyAppKeyDeleted(appKey);
            return true;
        }
        throw new IllegalArgumentException("Key does not exist.");
    }

    public synchronized boolean isKeyInUse(MeshKey meshKey) {
        for (ProvisionedMeshNode node : this.nodes) {
            if (node.getUuid().equalsIgnoreCase(this.getSelectedProvisioner().getProvisionerUuid())) continue;
            int index = meshKey.getKeyIndex();
            if (meshKey instanceof ApplicationKey) {
                return MeshParserUtils.isNodeKeyExists(node.getAddedAppKeys(), index);
            }
            return MeshParserUtils.isNodeKeyExists(node.getAddedNetKeys(), index);
        }
        return false;
    }

    public synchronized Provisioner createProvisioner(String name, AllocatedUnicastRange unicastRange, AllocatedGroupRange groupRange, AllocatedSceneRange sceneRange) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty.");
        }
        ArrayList<AllocatedUnicastRange> unicastRanges = new ArrayList<AllocatedUnicastRange>();
        ArrayList<AllocatedGroupRange> groupRanges = new ArrayList<AllocatedGroupRange>();
        ArrayList<AllocatedSceneRange> sceneRanges = new ArrayList<AllocatedSceneRange>();
        unicastRanges.add(unicastRange != null ? unicastRange : new AllocatedUnicastRange(1, Short.MAX_VALUE));
        groupRanges.add(groupRange != null ? groupRange : new AllocatedGroupRange(49152, 65279));
        sceneRanges.add(sceneRange != null ? sceneRange : new AllocatedSceneRange(1, 65535));
        Provisioner provisioner = new Provisioner(UUID.randomUUID().toString(), unicastRanges, groupRanges, sceneRanges, this.meshUUID);
        provisioner.setProvisionerName(name);
        return provisioner;
    }

    public final synchronized void selectProvisioner(Provisioner provisioner) {
        provisioner.setLastSelected(true);
        for (Provisioner prov : this.provisioners) {
            if (prov.getProvisionerUuid().equalsIgnoreCase(provisioner.getProvisionerUuid())) continue;
            prov.setLastSelected(false);
        }
        this.notifyProvisionersUpdated(this.provisioners);
    }

    public synchronized boolean addProvisioner(Provisioner provisioner) throws IllegalArgumentException {
        if (provisioner.allocatedUnicastRanges.isEmpty() && provisioner.getProvisionerAddress() != null) {
            throw new IllegalArgumentException("Provisioner has no allocated unicast range assigned.");
        }
        for (Provisioner other : this.provisioners) {
            if (!provisioner.hasOverlappingUnicastRanges(other.getAllocatedUnicastRanges()) && !provisioner.hasOverlappingGroupRanges(other.getAllocatedGroupRanges()) && !provisioner.hasOverlappingSceneRanges(other.getAllocatedSceneRanges())) continue;
            throw new IllegalArgumentException("Provisioner ranges overlap.");
        }
        if (!provisioner.isAddressWithinAllocatedRange(provisioner.getProvisionerAddress())) {
            throw new IllegalArgumentException("Unicast address assigned to a provisioner must be within an allocated unicast address range.");
        }
        if (this.isAddressInUse(provisioner.getProvisionerAddress())) {
            throw new IllegalArgumentException("Unicast address is in use by another node.");
        }
        if (provisioner.isNodeAddressInUse(this.nodes)) {
            throw new IllegalArgumentException("Unicast address is already in use.");
        }
        if (this.isProvisionerUuidInUse(provisioner.getProvisionerUuid())) {
            throw new IllegalArgumentException("Provisioner uuid already in use.");
        }
        provisioner.assignProvisionerAddress(provisioner.getProvisionerAddress());
        this.provisioners.add(provisioner);
        this.notifyProvisionerAdded(provisioner);
        if (provisioner.isLastSelected()) {
            this.selectProvisioner(provisioner);
        }
        if (provisioner.getProvisionerAddress() != null) {
            ProvisionedMeshNode node = new ProvisionedMeshNode(provisioner, this.netKeys, this.appKeys);
            this.nodes.add(node);
            this.notifyNodeAdded(node);
        }
        return true;
    }

    public synchronized ProvisionedMeshNode getNode(int unicastAddress) {
        for (ProvisionedMeshNode node : this.nodes) {
            if (!node.hasUnicastAddress(unicastAddress)) continue;
            return node;
        }
        return null;
    }

    public synchronized ProvisionedMeshNode getNode(String uuid) {
        for (ProvisionedMeshNode node : this.nodes) {
            if (!node.getUuid().equalsIgnoreCase(uuid)) continue;
            return node;
        }
        return null;
    }

    protected synchronized void loadSequenceNumbers() {
        for (ProvisionedMeshNode node : this.nodes) {
            this.sequenceNumbers.put(node.getUnicastAddress(), node.getSequenceNumber());
        }
    }

    private boolean isAddressInUse(Integer address) {
        if (address == null) {
            return false;
        }
        for (ProvisionedMeshNode node : this.nodes) {
            if (address.intValue() != node.getUnicastAddress()) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean isProvisionerUuidInUse(String uuid) {
        for (Provisioner provisioner : this.provisioners) {
            if (!provisioner.getProvisionerUuid().equalsIgnoreCase(uuid)) continue;
            return true;
        }
        return false;
    }

    final synchronized void notifyProvisionersUpdated(List<Provisioner> provisioner) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onProvisionersUpdated(provisioner);
        }
    }

    final synchronized void notifyProvisionerAdded(Provisioner provisioner) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onProvisionerAdded(provisioner);
        }
    }

    final synchronized void notifyNodeAdded(ProvisionedMeshNode node) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNodeAdded(node);
        }
    }

    final synchronized void notifyNodeDeleted(ProvisionedMeshNode meshNode) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNodeDeleted(meshNode);
        }
    }

    final synchronized void notifyProvisionerDeleted(Provisioner provisioner) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onProvisionerDeleted(provisioner);
        }
    }

    final synchronized void notifyNodeUpdated(ProvisionedMeshNode node) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNodeUpdated(node);
        }
    }

    final synchronized void notifyNetworkUpdated() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onMeshNetworkUpdated();
        }
    }

    final synchronized void notifyNetKeyAdded(NetworkKey networkKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNetworkKeyAdded(networkKey);
        }
    }

    final synchronized void notifyNetKeyDeleted(NetworkKey networkKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNetworkKeyDeleted(networkKey);
        }
    }

    final synchronized void notifyAppKeyAdded(ApplicationKey appKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onApplicationKeyAdded(appKey);
        }
    }

    final synchronized void notifyAppKeyUpdated(ApplicationKey appKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onApplicationKeyUpdated(appKey);
        }
    }

    final synchronized void notifyNetKeyUpdated(NetworkKey networkKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNetworkKeyUpdated(networkKey);
        }
    }

    final synchronized void notifyAppKeyDeleted(ApplicationKey appKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onApplicationKeyDeleted(appKey);
        }
    }

    private boolean validateKey(byte[] key) {
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be 16 bytes");
        }
        return true;
    }

    public synchronized List<Provisioner> getProvisioners() {
        return Collections.unmodifiableList(this.provisioners);
    }

    public synchronized Provisioner getSelectedProvisioner() {
        for (Provisioner provisioner : this.provisioners) {
            if (!provisioner.isLastSelected()) continue;
            return provisioner;
        }
        return null;
    }

    public synchronized List<ProvisionedMeshNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public synchronized Map<Integer, ArrayList<Integer>> getNetworkExclusions() {
        return Collections.unmodifiableMap(this.networkExclusions);
    }

    public synchronized ProxyFilter getProxyFilter() {
        return this.proxyFilter;
    }

    public synchronized void setProxyFilter(ProxyFilter proxyFilter) {
        this.proxyFilter = proxyFilter;
    }

    public synchronized boolean deleteNode(ProvisionedMeshNode meshNode) {
        boolean nodeDeleted = false;
        for (ProvisionedMeshNode node : this.nodes) {
            if (!node.getUuid().equalsIgnoreCase(meshNode.getUuid())) continue;
            this.excludeNode(node);
            this.nodes.remove(node);
            this.notifyNodeDeleted(node);
            nodeDeleted = true;
            break;
        }
        if (nodeDeleted) {
            for (Provisioner provisioner : this.provisioners) {
                if (!provisioner.getProvisionerUuid().equalsIgnoreCase(meshNode.getUuid())) continue;
                this.provisioners.remove(provisioner);
                this.notifyProvisionerDeleted(provisioner);
                break;
            }
        }
        return nodeDeleted;
    }

    private void excludeNode(ProvisionedMeshNode node) {
        node.setExcluded(true);
        this.notifyNodeUpdated(node);
        ArrayList<Integer> addresses = this.networkExclusions.get(this.ivIndex.getIvIndex());
        if (addresses == null) {
            addresses = new ArrayList();
        }
        for (Integer address : node.getElements().keySet()) {
            if (addresses.contains(address)) continue;
            addresses.add(address);
        }
        this.networkExclusions.put(this.ivIndex.getIvIndex(), addresses);
        this.notifyNetworkUpdated();
    }
}

