/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import javax.validation.constraints.NotNull;
import org.openremote.agent.protocol.bluetooth.mesh.MeshKey;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public final class ApplicationKey
extends MeshKey {
    private int boundNetKeyIndex = 0;
    private int aid;
    private int oldAid;

    public ApplicationKey(int keyIndex, @NotNull byte[] key) {
        super(keyIndex, key);
        this.name = "Application Key " + (keyIndex + 1);
        this.aid = SecureUtils.calculateK4(key);
    }

    public int getBoundNetKeyIndex() {
        return this.boundNetKeyIndex;
    }

    public void setBoundNetKeyIndex(int boundNetKeyIndex) {
        this.boundNetKeyIndex = boundNetKeyIndex;
    }

    @Override
    public void setKey(@NotNull byte[] key) {
        super.setKey(key);
        this.aid = SecureUtils.calculateK4(key);
    }

    @Override
    public void setOldKey(byte[] oldKey) {
        super.setOldKey(oldKey);
        if (oldKey != null) {
            this.oldAid = SecureUtils.calculateK4(oldKey);
        }
    }

    public int getAid() {
        return this.aid;
    }

    public int getOldAid() {
        return this.oldAid;
    }

    @Override
    public ApplicationKey clone() throws CloneNotSupportedException {
        return (ApplicationKey)super.clone();
    }
}

