/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import org.openremote.agent.protocol.bluetooth.mesh.AddressRange;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

public class AllocatedUnicastRange
extends AddressRange {
    public AllocatedUnicastRange(int lowAddress, int highAddress) {
        this.lowerBound = 1;
        this.upperBound = Short.MAX_VALUE;
        if (!MeshAddress.isValidUnicastAddress(lowAddress)) {
            throw new IllegalArgumentException("Low address must range from 0x0001 to 0x7FFF");
        }
        if (!MeshAddress.isValidUnicastAddress(highAddress)) {
            throw new IllegalArgumentException("High address must range from 0x0001 to 0x7FFF");
        }
        this.lowAddress = lowAddress;
        this.highAddress = highAddress;
    }

    AllocatedUnicastRange() {
    }

    @Override
    public final int getLowerBound() {
        return this.lowAddress;
    }

    @Override
    public final int getUpperBound() {
        return this.upperBound;
    }

    @Override
    public int getLowAddress() {
        return this.lowAddress;
    }

    public void setLowAddress(int lowAddress) {
        if (!MeshAddress.isValidUnicastAddress(lowAddress)) {
            throw new IllegalArgumentException("Low address must range from 0x0000 to 0x7FFF");
        }
        this.lowAddress = lowAddress;
    }

    @Override
    public int getHighAddress() {
        return this.highAddress;
    }

    public void setHighAddress(int highAddress) {
        if (!MeshAddress.isValidUnicastAddress(this.lowAddress)) {
            throw new IllegalArgumentException("High address must range from 0x0000 to 0x7FFF");
        }
        this.highAddress = highAddress;
    }
}

