/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.List;
import org.openremote.agent.protocol.bluetooth.mesh.Range;

public class AllocatedSceneRange
extends Range {
    private int firstScene;
    private int lastScene;

    @Override
    public final int getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public final int getUpperBound() {
        return this.upperBound;
    }

    public List<Range> minus(Range left, Range right) {
        return null;
    }

    public AllocatedSceneRange(int firstScene, int lastScene) {
        this.lowerBound = 1;
        this.upperBound = 65535;
        if (firstScene < this.lowerBound || firstScene > this.upperBound) {
            throw new IllegalArgumentException("firstScene value must range from 0x0000 to 0xFFFF");
        }
        if (lastScene < this.lowerBound || lastScene > this.upperBound) {
            throw new IllegalArgumentException("lastScene value must range from 0x0000 to 0xFFFF");
        }
        this.firstScene = firstScene;
        this.lastScene = lastScene;
    }

    AllocatedSceneRange() {
    }

    public int getLastScene() {
        return this.lastScene;
    }

    public void setLastScene(int lastScene) {
        this.lastScene = lastScene;
    }

    public int getFirstScene() {
        return this.firstScene;
    }

    public void setFirstScene(int firstScene) {
        this.firstScene = firstScene;
    }

    @Override
    public int range() {
        return this.lastScene - this.firstScene;
    }

    @Override
    public boolean overlaps(Range otherRange) {
        if (otherRange instanceof AllocatedSceneRange) {
            AllocatedSceneRange otherSceneRange = (AllocatedSceneRange)otherRange;
            return this.overlaps(this.firstScene, this.lastScene, otherSceneRange.getFirstScene(), otherSceneRange.getLastScene());
        }
        return false;
    }

    public static List<AllocatedSceneRange> minus(List<AllocatedSceneRange> ranges, AllocatedSceneRange other) {
        List<AllocatedSceneRange> results = new ArrayList<AllocatedSceneRange>();
        for (AllocatedSceneRange range : ranges) {
            results.addAll(range.minus(other));
            results = AllocatedSceneRange.mergeSceneRanges(results);
        }
        return results;
    }

    private List<AllocatedSceneRange> minus(AllocatedSceneRange other) {
        ArrayList<AllocatedSceneRange> results = new ArrayList<AllocatedSceneRange>();
        if (other.firstScene > this.firstScene) {
            AllocatedSceneRange leftSlice = new AllocatedSceneRange(this.firstScene, Math.min(this.lastScene, other.firstScene - 1));
            results.add(leftSlice);
        }
        if (other.lastScene < this.lastScene) {
            AllocatedSceneRange rightSlice = new AllocatedSceneRange(Math.max(other.lastScene + 1, this.firstScene), this.lastScene);
            results.add(rightSlice);
        }
        return results;
    }
}

