/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import org.openremote.agent.protocol.bluetooth.mesh.AddressRange;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

public class AllocatedGroupRange
extends AddressRange {
    @Override
    public final int getLowerBound() {
        return 49152;
    }

    @Override
    public final int getUpperBound() {
        return 65279;
    }

    public AllocatedGroupRange(int lowAddress, int highAddress) {
        this.lowerBound = 49152;
        this.upperBound = 65279;
        if (!MeshAddress.isValidGroupAddress(lowAddress)) {
            throw new IllegalArgumentException("Low address must range from 0xC000 to 0xFEFF");
        }
        if (!MeshAddress.isValidGroupAddress(highAddress)) {
            throw new IllegalArgumentException("High address must range from 0xC000 to 0xFEFF");
        }
        this.lowAddress = lowAddress;
        this.highAddress = highAddress;
    }

    AllocatedGroupRange() {
    }

    @Override
    public int getLowAddress() {
        return this.lowAddress;
    }

    public void setLowAddress(int lowAddress) {
        this.lowAddress = lowAddress;
    }

    @Override
    public int getHighAddress() {
        return this.highAddress;
    }

    public void setHighAddress(int highAddress) {
        this.highAddress = highAddress;
    }
}

