/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.List;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedGroupRange;
import org.openremote.agent.protocol.bluetooth.mesh.AllocatedUnicastRange;
import org.openremote.agent.protocol.bluetooth.mesh.Range;

public abstract class AddressRange
extends Range {
    int lowAddress;
    int highAddress;

    public abstract int getLowAddress();

    public abstract int getHighAddress();

    @Override
    public int range() {
        return this.highAddress - this.lowAddress;
    }

    @Override
    public boolean overlaps(Range otherRange) {
        if (otherRange instanceof AddressRange) {
            AddressRange otherAddressRange = (AddressRange)otherRange;
            return this.overlaps(this.lowAddress, this.highAddress, otherAddressRange.getLowAddress(), otherAddressRange.getHighAddress());
        }
        return false;
    }

    public static List<AllocatedGroupRange> minus(List<AllocatedGroupRange> ranges, AllocatedGroupRange other) {
        List<AllocatedGroupRange> results = new ArrayList<AllocatedGroupRange>();
        for (AllocatedGroupRange range : ranges) {
            results.addAll(range.minus(other));
            results = AddressRange.mergeGroupRanges(results);
        }
        return results;
    }

    List<AllocatedGroupRange> minus(AllocatedGroupRange other) {
        ArrayList<AllocatedGroupRange> results = new ArrayList<AllocatedGroupRange>();
        if (other.lowAddress > this.lowAddress) {
            AllocatedGroupRange leftSlice = new AllocatedGroupRange(this.lowAddress, Math.min(this.highAddress, other.lowAddress - 1));
            results.add(leftSlice);
        }
        if (other.highAddress < this.highAddress) {
            AllocatedGroupRange rightSlice = new AllocatedGroupRange(Math.max(other.highAddress + 1, this.lowAddress), this.highAddress);
            results.add(rightSlice);
        }
        return results;
    }

    public static List<AllocatedUnicastRange> minus(List<AllocatedUnicastRange> ranges, AllocatedUnicastRange other) {
        List<AllocatedUnicastRange> results = new ArrayList<AllocatedUnicastRange>();
        for (AllocatedUnicastRange range : ranges) {
            results.addAll(range.minus(other));
            results = AddressRange.mergeUnicastRanges(results);
        }
        return results;
    }

    List<AllocatedUnicastRange> minus(AllocatedUnicastRange other) {
        ArrayList<AllocatedUnicastRange> results = new ArrayList<AllocatedUnicastRange>();
        if (other.lowAddress > this.lowAddress) {
            AllocatedUnicastRange leftSlice = new AllocatedUnicastRange(this.lowAddress, Math.min(this.highAddress, other.lowAddress - 1));
            results.add(leftSlice);
        }
        if (other.highAddress < this.highAddress) {
            AllocatedUnicastRange rightSlice = new AllocatedUnicastRange(Math.max(other.highAddress + 1, this.lowAddress), this.highAddress);
            results.add(rightSlice);
        }
        return results;
    }
}

