/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.artnet;

import io.netty.channel.ChannelHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openremote.agent.protocol.artnet.ArtnetAgent;
import org.openremote.agent.protocol.artnet.ArtnetLightAsset;
import org.openremote.agent.protocol.artnet.ArtnetPacket;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.agent.protocol.io.AbstractNettyIOClientProtocol;
import org.openremote.agent.protocol.udp.UDPIOClient;
import org.openremote.model.asset.AssetTreeNode;
import org.openremote.model.asset.agent.DefaultAgentLink;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.protocol.ProtocolAssetImport;

public class ArtnetProtocol
extends AbstractNettyIOClientProtocol<ArtnetProtocol, ArtnetAgent, ArtnetPacket, UDPIOClient<ArtnetPacket>, DefaultAgentLink>
implements ProtocolAssetImport {
    public static final String PROTOCOL_DISPLAY_NAME = "Artnet";
    protected final Map<AttributeRef, Consumer<ArtnetPacket>> protocolMessageConsumers = new HashMap<AttributeRef, Consumer<ArtnetPacket>>();
    protected final Map<String, ArtnetLightAsset> lights = new HashMap<String, ArtnetLightAsset>();

    public ArtnetProtocol(ArtnetAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    @Override
    protected UDPIOClient<ArtnetPacket> doCreateIoClient() throws Exception {
        String host = (String)((ArtnetAgent)this.agent).getHost().orElseThrow(() -> new IllegalArgumentException("Required host attribute is null or missing"));
        int port = (Integer)((ArtnetAgent)this.agent).getPort().orElseThrow(() -> new IllegalArgumentException("Port must be in the range 1-65536"));
        Integer bindPort = ((ArtnetAgent)this.agent).getBindPort().orElse(null);
        return new UDPIOClient<ArtnetPacket>(host, port, bindPort);
    }

    @Override
    protected Supplier<ChannelHandler[]> getEncoderDecoderProvider() {
        return () -> new ChannelHandler[]{new AbstractNettyIOClient.MessageToByteEncoder<ArtnetPacket>(ArtnetPacket.class, (AbstractNettyIOClient)this.client, ArtnetPacket::toByteBuf)};
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, DefaultAgentLink agentLink) {
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, DefaultAgentLink agentLink) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMessageReceived(ArtnetPacket packet) {
        Map<AttributeRef, Consumer<ArtnetPacket>> map = this.protocolMessageConsumers;
        synchronized (map) {
            this.protocolMessageConsumers.forEach((ref, c) -> c.accept(packet));
        }
    }

    @Override
    protected ArtnetPacket createWriteMessage(Attribute<?> attribute, DefaultAgentLink agentLink, AttributeEvent event, Object processedValue) {
        return null;
    }

    public Future<Void> startAssetImport(byte[] fileData, Consumer<AssetTreeNode[]> assetConsumer) {
        return CompletableFuture.completedFuture(null);
    }
}

