/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.artnet;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.openremote.agent.protocol.artnet.ArtnetLightAsset;

public class ArtnetPacket {
    private byte[] PREFIX = new byte[]{65, 114, 116, 45, 78, 101, 116, 0, 0, 80, 0, 14};
    private byte SEQUENCE = 0;
    private byte PHYSICAL = 0;
    private byte DUMMY_LENGTH_HI = 0;
    private byte DUMMY_LENGTH_LO = 0;
    private int universe;
    private List<ArtnetLightAsset> lights;

    public ArtnetPacket(int universe, List<ArtnetLightAsset> lights) {
        this.universe = universe;
        Collections.sort(lights, Comparator.comparingInt(light -> light.getLightId().orElse(0)));
        this.lights = lights;
    }

    public void toByteBuf(ByteBuf buf) {
        this.writePrefix(buf, this.universe);
        for (ArtnetLightAsset light : this.lights) {
            this.writeLight(buf, light.getValues(), light.getLEDCount().orElse(0));
        }
        this.updateLength(buf);
    }

    private void writePrefix(ByteBuf buf, int universe) {
        buf.writeBytes(this.PREFIX);
        buf.writeByte((int)this.SEQUENCE);
        buf.writeByte((int)this.PHYSICAL);
        buf.writeByte(universe >> 8 & 0xFF);
        buf.writeByte(universe & 0xFF);
        buf.writeByte((int)this.DUMMY_LENGTH_HI);
        buf.writeByte((int)this.DUMMY_LENGTH_LO);
    }

    private void updateLength(ByteBuf buf) {
        int len_idx = this.PREFIX.length + 4;
        int len = buf.writerIndex() - len_idx - 2;
        buf.setByte(len_idx, len >> 8 & 0xFF);
        buf.setByte(len_idx + 1, len & 0xFF);
    }

    private void writeLight(ByteBuf buf, Byte[] light, int repeat) {
        byte[] values = ArrayUtils.toPrimitive((Byte[])light);
        for (int i = 0; i < repeat; ++i) {
            buf.writeBytes(values);
        }
    }
}

