/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.artnet;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.openremote.model.asset.AssetDescriptor;
import org.openremote.model.asset.impl.LightAsset;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueType;

@Entity
public class ArtnetLightAsset
extends LightAsset {
    public static final AttributeDescriptor<Integer> LED_COUNT = new AttributeDescriptor("lEDCount", ValueType.POSITIVE_INTEGER);
    public static final AttributeDescriptor<Integer> LIGHT_ID = new AttributeDescriptor("lightId", ValueType.POSITIVE_INTEGER);
    public static final AttributeDescriptor<Integer> GROUP_ID = new AttributeDescriptor("groupId", ValueType.POSITIVE_INTEGER);
    public static final AttributeDescriptor<Integer> UNIVERSE = new AttributeDescriptor("universe", ValueType.POSITIVE_INTEGER);
    public static final AttributeDescriptor<String[]> REQUIRED_VALUES = new AttributeDescriptor("requiredValues", ValueType.TEXT.asArray());
    public static final AssetDescriptor<ArtnetLightAsset> DESCRIPTOR = new AssetDescriptor("lightbulb", "e6688a", ArtnetLightAsset.class);
    @Transient
    @JsonIgnore
    private Map<String, Integer> receivedValues;

    protected ArtnetLightAsset() {
    }

    protected ArtnetLightAsset(String name) {
        super(name);
    }

    public Optional<Integer> getLightId() {
        return this.getAttributes().getValue(LIGHT_ID);
    }

    public void setLightId(int lightId) {
        this.getAttributes().getOrCreate(LIGHT_ID).setValue((Object)lightId);
    }

    public Optional<Integer> getGroupId() {
        return this.getAttributes().getValue(GROUP_ID);
    }

    public void setGroupId(int groupId) {
        this.getAttributes().getOrCreate(GROUP_ID).setValue((Object)groupId);
    }

    public Optional<Integer> getLEDCount() {
        return this.getAttributes().getValue(LED_COUNT);
    }

    public void setLEDCount(int count) {
        this.getAttributes().getOrCreate(LED_COUNT).setValue((Object)count);
    }

    public Optional<Integer> getUniverse() {
        return this.getAttributes().getValue(UNIVERSE);
    }

    public void setUniverse(int universe) {
        this.getAttributes().getOrCreate(UNIVERSE).setValue((Object)universe);
    }

    public Optional<String[]> getRequiredValues() {
        return this.getAttributes().getValue(REQUIRED_VALUES);
    }

    public void setRequiredValues(String[] requiredValues) {
        this.getAttributes().getOrCreate(REQUIRED_VALUES).setValue((Object)requiredValues);
    }

    public void setReceivedValues(Map<String, Integer> receivedValues) {
        this.receivedValues = receivedValues;
    }

    public Byte[] getValues() {
        int enable;
        int n = enable = this.getOnOff().orElse(false) != false ? 1 : 0;
        if (this.receivedValues == null) {
            return null;
        }
        return (Byte[])this.receivedValues.values().stream().map(y -> (byte)((double)y.intValue() * ((double)this.getBrightness().orElse(0).intValue() / 100.0) * (double)enable)).toArray(Byte[]::new);
    }
}

