/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.openremote.model.ContainerService;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.query.AssetQuery;

public interface ProtocolAssetService
extends ContainerService {
    public <T extends Asset<?>> T mergeAsset(T var1);

    public boolean deleteAssets(String ... var1);

    public <T extends Asset<?>> T findAsset(String var1, Class<T> var2);

    public <T extends Asset<?>> T findAsset(String var1);

    public List<Asset<?>> findAssets(String var1, AssetQuery var2);

    public void sendAttributeEvent(AttributeEvent var1);

    public void subscribeChildAssetChange(String var1, Consumer<PersistenceEvent<Asset<?>>> var2);

    public void unsubscribeChildAssetChange(String var1, Consumer<PersistenceEvent<Asset<?>>> var2);

    public static class MergeOptions {
        protected final String assignToUserName;
        protected final Predicate<String> attributeNamesToEvaluate;
        protected final Predicate<String> ignoredAttributeNames;
        protected final Predicate<String> ignoredAttributeKeys;

        public MergeOptions(String assignToUserName) {
            this(assignToUserName, null, null, null);
        }

        public MergeOptions(Predicate<String> attributeNamesToEvaluate) {
            this(null, attributeNamesToEvaluate, null, null);
        }

        public MergeOptions(Predicate<String> ignoredAttributeNames, Predicate<String> ignoredAttributeKeys) {
            this(null, null, ignoredAttributeNames, ignoredAttributeKeys);
        }

        public MergeOptions(String assignToUserName, Predicate<String> ignoredAttributeKeys) {
            this(assignToUserName, null, null, ignoredAttributeKeys);
        }

        public MergeOptions(String assignToUserName, Predicate<String> attributeNamesToEvaluate, Predicate<String> ignoredAttributeNames, Predicate<String> ignoredAttributeKeys) {
            this.assignToUserName = assignToUserName;
            this.attributeNamesToEvaluate = attributeNamesToEvaluate;
            this.ignoredAttributeNames = ignoredAttributeNames;
            this.ignoredAttributeKeys = ignoredAttributeKeys;
        }

        public String getAssignToUserName() {
            return this.assignToUserName;
        }

        public Predicate<String> getAttributeNamesToEvaluate() {
            return this.attributeNamesToEvaluate;
        }

        public Predicate<String> getIgnoredAttributeNames() {
            return this.ignoredAttributeNames;
        }

        public Predicate<String> getIgnoredAttributeKeys() {
            return this.ignoredAttributeKeys;
        }
    }
}

