/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.agent.protocol.ProtocolAssetService;
import org.openremote.agent.protocol.ProtocolDatapointService;
import org.openremote.agent.protocol.ProtocolPredictedDatapointService;
import org.openremote.container.concurrent.GlobalLock;
import org.openremote.container.message.MessageBrokerContext;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.timer.TimerService;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.asset.agent.Protocol;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.protocol.ProtocolUtil;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.Pair;

public abstract class AbstractProtocol<T extends Agent<T, ?, U>, U extends AgentLink<?>>
implements Protocol<T> {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, AbstractProtocol.class);
    protected final Map<AttributeRef, Attribute<?>> linkedAttributes = new HashMap();
    protected final Set<AttributeRef> dynamicAttributes = new HashSet<AttributeRef>();
    protected MessageBrokerContext messageBrokerContext;
    protected ProducerTemplate producerTemplate;
    protected TimerService timerService;
    protected ScheduledExecutorService executorService;
    protected ProtocolAssetService assetService;
    protected ProtocolPredictedDatapointService predictedDatapointService;
    protected ProtocolDatapointService datapointService;
    protected T agent;

    public AbstractProtocol(T agent) {
        this.agent = agent;
    }

    public void start(Container container) throws Exception {
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.executorService = container.getExecutorService();
        this.assetService = (ProtocolAssetService)container.getService(ProtocolAssetService.class);
        this.predictedDatapointService = (ProtocolPredictedDatapointService)container.getService(ProtocolPredictedDatapointService.class);
        this.datapointService = (ProtocolDatapointService)container.getService(ProtocolDatapointService.class);
        this.messageBrokerContext = ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext();
        GlobalLock.withLock((String)(this.getProtocolName() + "::start"), () -> {
            try {
                this.messageBrokerContext.addRoutes((RoutesBuilder)new RouteBuilder(){

                    public void configure() throws Exception {
                        this.from("seda://ActuatorTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&limitConcurrentConsumers=false&size=1000").routeId("Actuator-" + AbstractProtocol.this.getProtocolName() + AbstractProtocol.this.getAgent().getId()).process(exchange -> {
                            Protocol protocolInstance = (Protocol)exchange.getIn().getHeader("Protocol", Protocol.class);
                            if (protocolInstance != AbstractProtocol.this) {
                                return;
                            }
                            AttributeEvent event = (AttributeEvent)exchange.getIn().getBody(AttributeEvent.class);
                            Attribute<?> linkedAttribute = AbstractProtocol.this.getLinkedAttributes().get(event.getAttributeRef());
                            if (linkedAttribute == null) {
                                LOG.info("Attempt to write to attribute that is not actually linked to this protocol '" + AbstractProtocol.this + "': " + linkedAttribute);
                                return;
                            }
                            AbstractProtocol.this.processLinkedAttributeWrite(event);
                        });
                    }
                });
                this.doStart(container);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        this.producerTemplate = ((MessageBrokerService)container.getService(MessageBrokerService.class)).getProducerTemplate();
    }

    public final void stop(Container container) {
        GlobalLock.withLock((String)(this.getProtocolName() + "::stop"), () -> {
            this.linkedAttributes.clear();
            try {
                this.messageBrokerContext.stopRoute("Actuator-" + this.getProtocolName(), 1L, TimeUnit.MILLISECONDS);
                this.messageBrokerContext.removeRoute("Actuator-" + this.getProtocolName());
                this.doStop(container);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    protected void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.sendAttributeEvent(new AttributeEvent(this.getAgent().getId(), Agent.STATUS, (Object)connectionStatus));
    }

    public final void linkAttribute(String assetId, Attribute<?> attribute) throws Exception {
        GlobalLock.withLock((String)(this.getProtocolName() + "::linkAttribute"), () -> {
            AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
            if (this.linkedAttributes.containsKey(attributeRef)) {
                LOG.warning("Attribute is already linked to this protocol so ignoring: " + attributeRef);
                return;
            }
            this.linkedAttributes.put(attributeRef, attribute);
            if (ProtocolUtil.hasDynamicWriteValue((AgentLink)this.agent.getAgentLink(attribute))) {
                this.dynamicAttributes.add(attributeRef);
            }
            try {
                this.doLinkAttribute(assetId, attribute, this.agent.getAgentLink(attribute));
            }
            catch (Exception e) {
                this.linkedAttributes.remove(attributeRef);
                throw new RuntimeException(e);
            }
        });
    }

    public final void unlinkAttribute(String assetId, Attribute<?> attribute) throws Exception {
        GlobalLock.withLock((String)(this.getProtocolName() + "::unlinkAttributes"), () -> {
            AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
            if (this.linkedAttributes.remove(attributeRef) != null) {
                this.dynamicAttributes.remove(attributeRef);
                this.doUnlinkAttribute(assetId, attribute, this.agent.getAgentLink(attribute));
            }
        });
    }

    public T getAgent() {
        return this.agent;
    }

    public Map<AttributeRef, Attribute<?>> getLinkedAttributes() {
        return this.linkedAttributes;
    }

    protected final void processLinkedAttributeWrite(AttributeEvent event) {
        LOG.finest("Processing linked attribute write on protocol '" + this + "': " + event);
        GlobalLock.withLock((String)(this.getProtocolName() + "::processLinkedAttributeWrite"), () -> {
            Attribute<?> attribute = this.linkedAttributes.get(event.getAttributeRef());
            if (attribute == null) {
                LOG.warning("Attribute not linked to protocol '" + this + "':" + event);
            } else {
                AgentLink agentLink = this.agent.getAgentLink(attribute);
                Pair ignoreAndConverted = ProtocolUtil.doOutboundValueProcessing((String)event.getAssetId(), attribute, (AgentLink)agentLink, event.getValue().orElse(null), (boolean)this.dynamicAttributes.contains(event.getAttributeRef()));
                if (((Boolean)ignoreAndConverted.key).booleanValue()) {
                    LOG.fine("Value conversion returned ignore so attribute will not write to protocol: " + event.getAttributeRef());
                    return;
                }
                this.doLinkedAttributeWrite(attribute, this.agent.getAgentLink(attribute), event, ignoreAndConverted.value);
                if (this.agent.isUpdateOnWrite().orElse(false).booleanValue() || agentLink.getUpdateOnWrite().orElse(false).booleanValue()) {
                    this.updateLinkedAttribute(new AttributeState(event.getAttributeRef(), ignoreAndConverted.value));
                }
            }
        });
    }

    protected final void sendAttributeEvent(AttributeState state) {
        this.sendAttributeEvent(new AttributeEvent(state, this.timerService.getCurrentTimeMillis()));
    }

    protected final void sendAttributeEvent(AttributeEvent event) {
        GlobalLock.withLock((String)(this.getProtocolName() + "::sendAttributeEvent"), () -> {
            if (this.linkedAttributes.containsKey(event.getAttributeRef())) {
                LOG.warning("Cannot update an attribute linked to the same protocol; use updateLinkedAttribute for that: " + event);
                return;
            }
            this.assetService.sendAttributeEvent(event);
        });
    }

    protected final void updateLinkedAttribute(AttributeState state, long timestamp) {
        Attribute<?> attribute = this.linkedAttributes.get(state.getRef());
        if (attribute == null) {
            LOG.severe("Update linked attribute called for un-linked attribute: " + state);
            return;
        }
        Pair ignoreAndConverted = ProtocolUtil.doInboundValueProcessing((String)state.getRef().getId(), attribute, (AgentLink)this.agent.getAgentLink(attribute), state.getValue().orElse(null));
        if (((Boolean)ignoreAndConverted.key).booleanValue()) {
            LOG.fine("Value conversion returned ignore so attribute will not be updated: " + state.getRef());
            return;
        }
        AttributeEvent attributeEvent = new AttributeEvent(new AttributeState(state.getRef(), ignoreAndConverted.value), timestamp);
        LOG.finer("Sending linked attribute update on sensor queue: " + attributeEvent);
        this.producerTemplate.sendBodyAndHeader("seda://SensorQueue?waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=false&size=25000", (Object)attributeEvent, "Protocol", (Object)this.getProtocolName());
    }

    protected final void updateAgentAttribute(AttributeState state) {
        if (!this.agent.getAttributes().has(state.getRef().getName()) || !this.agent.getId().equals(state.getRef().getId())) {
            LOG.warning("Attempt to update non existent agent attribute or agent ID is incorrect: " + state);
            return;
        }
        AttributeEvent attributeEvent = new AttributeEvent(state, this.timerService.getCurrentTimeMillis());
        LOG.finer("Sending protocol agent attribute update: " + attributeEvent);
        this.assetService.sendAttributeEvent(attributeEvent);
    }

    protected final void updateLinkedAttribute(AttributeState state) {
        this.updateLinkedAttribute(state, this.timerService.getCurrentTimeMillis());
    }

    protected abstract void doStart(Container var1) throws Exception;

    protected abstract void doStop(Container var1) throws Exception;

    public String toString() {
        return this.getProtocolName() + "[" + this.getProtocolInstanceUri() + "]";
    }

    protected abstract void doLinkAttribute(String var1, Attribute<?> var2, U var3) throws RuntimeException;

    protected abstract void doUnlinkAttribute(String var1, Attribute<?> var2, U var3);

    protected abstract void doLinkedAttributeWrite(Attribute<?> var1, U var2, AttributeEvent var3, Object var4);
}

