/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.test;

import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.VersionNumber;
import io.openmanufacturing.sds.aspectmodel.resolver.AspectModelResolver;
import io.openmanufacturing.sds.aspectmodel.resolver.ClasspathStrategy;
import io.openmanufacturing.sds.aspectmodel.resolver.ResolutionStrategy;
import io.openmanufacturing.sds.aspectmodel.resolver.services.SdsAspectMetaModelResourceResolver;
import io.openmanufacturing.sds.aspectmodel.resolver.services.TurtleLoader;
import io.openmanufacturing.sds.aspectmodel.resolver.services.VersionedModel;
import io.openmanufacturing.sds.test.InvalidTestAspect;
import io.openmanufacturing.sds.test.TestModel;
import io.vavr.control.Try;
import java.io.InputStream;

public class TestResources {
    private TestResources() {
    }

    public static VersionedModel getModelWithoutResolution(TestModel model, KnownVersion knownVersion) {
        String baseDirectory = model instanceof InvalidTestAspect ? "invalid" : "valid";
        SdsAspectMetaModelResourceResolver metaModelResourceResolver = new SdsAspectMetaModelResourceResolver();
        String path = String.format("%s/%s/%s/%s/%s.ttl", baseDirectory, knownVersion.toString().toLowerCase(), model.getUrn().getNamespace(), model.getUrn().getVersion(), model.getName());
        InputStream inputStream = TestResources.class.getClassLoader().getResourceAsStream(path);
        return (VersionedModel)TurtleLoader.loadTurtle((InputStream)inputStream).flatMap(rawModel -> metaModelResourceResolver.mergeMetaModelIntoRawModel(rawModel, VersionNumber.parse((String)knownVersion.toVersionString()))).get();
    }

    public static Try<VersionedModel> getModel(TestModel model, KnownVersion knownVersion) {
        String baseDirectory = model instanceof InvalidTestAspect ? "invalid" : "valid";
        String modelsRoot = baseDirectory + "/" + knownVersion.toString().toLowerCase();
        return new AspectModelResolver().resolveAspectModel((ResolutionStrategy)new ClasspathStrategy(modelsRoot), model.getUrn());
    }
}

