/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.urn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import io.openmanufacturing.sds.aspectmodel.urn.ElementType;
import io.openmanufacturing.sds.aspectmodel.urn.UrnSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class AspectModelUrn {
    public static final String NAMESPACE_REGEX = "([a-zA-Z0-9()+,\\-.:=@;$_!*']|%[0-9a-fA-F]{2})+";
    public static final Pattern NAMESPACE_PATTERN = Pattern.compile("([a-zA-Z0-9()+,\\-.:=@;$_!*']|%[0-9a-fA-F]{2})+");
    public static final String MODEL_ELEMENT_NAME_REGEX = "\\p{Alpha}\\p{Alnum}*";
    public static final String VERSION_REGEX = "^(\\d+\\.)(\\d+\\.)(\\*|\\d+)$";
    public static final String VALID_PROTOCOL = "urn";
    public static final String VALID_NAMESPACE_IDENTIFIER = "bamm";
    public static final int MAX_URN_LENGTH = 256;
    public static final int ASPECT_NAME_INDEX = 4;
    private static final int NAMESPACE_INDEX = 2;
    private static final int ELEMENT_TYPE_INDEX = 3;
    private static final int VERSION_INDEX_FOR_ASPECTS = 5;
    private static final int MODEL_ELEMENT_NAME_INDEX = 6;
    private static final int VERSION_INDEX_FOR_MODEL_ELEMENTS = 3;
    private static final int VERSION_INDEX_FOR_META_MODEL = 4;
    private static final int META_MODEL_ELEMENT_NAME_INDEX = 5;
    private static final List<ElementType> ELEMENT_TYPES_WITH_VARIABLE_NAMESPACE_STRUCTURE = Arrays.asList(ElementType.CHARACTERISTIC, ElementType.ENTITY, ElementType.UNIT);
    private static final List<ElementType> MODEL_ELEMENT_TYPES = Arrays.asList(ElementType.ASPECT_MODEL_ELEMENT, ElementType.ENTITY_MODEL_ELEMENT, ElementType.CHARACTERISTIC_MODEL_ELEMENT);
    private final String name;
    private final String version;
    private final String namespace;
    private final ElementType elementType;
    private final boolean isBammUrn;
    @JsonValue
    private final URI urn;

    private AspectModelUrn(URI urn, String name, String namespace, ElementType elementType, String version, boolean isBammUrn) {
        this.urn = urn;
        this.name = name;
        this.namespace = namespace;
        this.elementType = elementType;
        this.version = version;
        this.isBammUrn = isBammUrn;
    }

    @JsonCreator
    public static AspectModelUrn fromUrn(String urn) {
        try {
            return AspectModelUrn.fromUrn(new URI(urn));
        }
        catch (URISyntaxException e) {
            throw new UrnSyntaxException("The URN is no valid URI");
        }
    }

    public static AspectModelUrn fromUrn(URI urn) {
        AspectModelUrn.checkNotEmpty(urn);
        ImmutableList urnParts = ImmutableList.copyOf((Object[])urn.toString().split("[:|#]"));
        int numberOfUrnParts = urnParts.size();
        AspectModelUrn.checkUrn(numberOfUrnParts >= 5, "The URN must consist of at least 5 sections adhering to the following schema: urn:bamm:<organisation>:<optional>:<version>:<model-name>.", new Object[0]);
        String protocol = (String)urnParts.get(0);
        AspectModelUrn.checkUrn(protocol.equalsIgnoreCase(VALID_PROTOCOL), "The protocol must be equal to {0}.", VALID_PROTOCOL);
        String namespaceIdentifier = (String)urnParts.get(1);
        AspectModelUrn.checkUrn(namespaceIdentifier.equals(VALID_NAMESPACE_IDENTIFIER), "The namespace identifier must be equal to {0}.", VALID_NAMESPACE_IDENTIFIER);
        String namespace = (String)urnParts.get(2);
        AspectModelUrn.checkUrn(NAMESPACE_PATTERN.matcher(namespace).matches(), "The namespace must match {0}.", NAMESPACE_REGEX);
        ElementType elementType = AspectModelUrn.getElementType((List<String>)urnParts);
        boolean isBammUrn = AspectModelUrn.isBammUrn(urn, (List<String>)urnParts, elementType);
        String version = AspectModelUrn.getVersion(isBammUrn, (List<String>)urnParts, elementType);
        String elementName = AspectModelUrn.getName(isBammUrn, (List<String>)urnParts, elementType);
        return new AspectModelUrn(urn, elementName, namespace, elementType, version, isBammUrn);
    }

    private static ElementType getElementType(List<String> urnParts) {
        String elementType = urnParts.get(3);
        if (elementType.equals(ElementType.META_MODEL.getValue())) {
            return ElementType.META_MODEL;
        }
        if (elementType.equals(ElementType.ASPECT_MODEL.getValue())) {
            return AspectModelUrn.getModelElementType(urnParts, ElementType.ASPECT_MODEL, ElementType.ASPECT_MODEL_ELEMENT);
        }
        if (elementType.equals(ElementType.ENTITY.getValue())) {
            return AspectModelUrn.getModelElementType(urnParts, ElementType.ENTITY, ElementType.ENTITY_MODEL_ELEMENT);
        }
        if (elementType.equals(ElementType.CHARACTERISTIC.getValue())) {
            return AspectModelUrn.getModelElementType(urnParts, ElementType.CHARACTERISTIC, ElementType.CHARACTERISTIC_MODEL_ELEMENT);
        }
        if (elementType.equals(ElementType.UNIT.getValue())) {
            return ElementType.UNIT;
        }
        return ElementType.NONE;
    }

    private static ElementType getModelElementType(List<String> urnParts, ElementType elementType, ElementType modelElementType) {
        if (urnParts.size() == 7) {
            return modelElementType;
        }
        return elementType;
    }

    private static String getVersion(boolean isBammUrn, List<String> urnParts, ElementType elementType) {
        if (elementType.equals((Object)ElementType.NONE)) {
            String version = urnParts.get(3);
            AspectModelUrn.checkVersion(version);
            return urnParts.get(3);
        }
        if (elementType.equals((Object)ElementType.META_MODEL)) {
            String version = urnParts.get(4);
            AspectModelUrn.checkVersion(version);
            return urnParts.get(4);
        }
        if (ELEMENT_TYPES_WITH_VARIABLE_NAMESPACE_STRUCTURE.contains((Object)elementType)) {
            String version = urnParts.get(5);
            if (isBammUrn) {
                version = urnParts.get(4);
            }
            AspectModelUrn.checkVersion(version);
            return version;
        }
        String version = urnParts.get(5);
        AspectModelUrn.checkVersion(version);
        return version;
    }

    private static String getName(boolean isBammUrn, List<String> urnParts, ElementType elementType) {
        if (elementType.equals((Object)ElementType.META_MODEL)) {
            String modelElementName = urnParts.get(5);
            AspectModelUrn.checkElementName(modelElementName, "meta model element");
            return modelElementName;
        }
        if (MODEL_ELEMENT_TYPES.contains((Object)elementType)) {
            String modelElementName = urnParts.get(6);
            AspectModelUrn.checkElementName(modelElementName, elementType.getValue() + " element");
            return modelElementName;
        }
        if (ELEMENT_TYPES_WITH_VARIABLE_NAMESPACE_STRUCTURE.contains((Object)elementType)) {
            String name = urnParts.get(4);
            if (isBammUrn) {
                name = urnParts.get(5);
            }
            AspectModelUrn.checkElementName(name, elementType.getValue());
            return name;
        }
        String modelElementName = urnParts.get(4);
        AspectModelUrn.checkElementName(modelElementName, "aspect");
        return modelElementName;
    }

    private static boolean isBammUrn(URI urn, List<String> urnParts, ElementType elementType) {
        if (elementType == ElementType.NONE || urnParts.size() == 7) {
            return false;
        }
        String regex = ".*\\b" + elementType.getValue() + ":\\b.*\\b#\\b.*";
        return urn.toString().matches(regex);
    }

    private static void checkElementName(String modelElementName, String elementTypeForErrorMessage) {
        AspectModelUrn.checkUrn(modelElementName.matches(MODEL_ELEMENT_NAME_REGEX), "The {0} name must match {1}: {2}", elementTypeForErrorMessage, MODEL_ELEMENT_NAME_REGEX, modelElementName);
    }

    private static void checkVersion(String version) {
        AspectModelUrn.checkUrn(version.matches(VERSION_REGEX), "Invalid version in URN: {0}.", version);
    }

    private static void checkNotEmpty(URI urn) {
        AspectModelUrn.checkUrn(urn != null, "The URN may not be null.", new Object[0]);
        AspectModelUrn.checkUrn(urn.toString().length() <= 256, "The length of the URN is limited to {0} characters", 256);
    }

    public URI getUrn() {
        return this.urn;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUrnPrefix() {
        return this.urn.toString().split("#")[0] + "#";
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public boolean isBammUrn() {
        return this.isBammUrn;
    }

    private static void checkUrn(boolean expression, String errorMessage, Object ... errorMessageArguments) {
        String formattedErrorMessage = MessageFormat.format(errorMessage, errorMessageArguments);
        if (!expression) {
            throw new UrnSyntaxException(formattedErrorMessage);
        }
    }

    public String toString() {
        return this.urn.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AspectModelUrn that = (AspectModelUrn)o;
        return Objects.equals(this.urn, that.urn);
    }

    public int hashCode() {
        return Objects.hash(this.urn);
    }
}

