/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.serializer;

import com.google.common.collect.ImmutableList;
import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.UnsupportedVersionException;
import io.openmanufacturing.sds.aspectmodel.resolver.services.VersionedModel;
import io.openmanufacturing.sds.aspectmodel.urn.AspectModelUrn;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMM;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMMC;
import io.openmanufacturing.sds.aspectmodel.vocabulary.Namespace;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeVisitor;
import org.apache.jena.graph.Node_ANY;
import org.apache.jena.graph.Node_Blank;
import org.apache.jena.graph.Node_Graph;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.Node_Variable;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class PrettyPrinter {
    private static final String INDENT = "   ";
    private static final String TRIPLE_QUOTE = "\"\"\"";
    private static final String LINE_BREAK = "\n";
    private final Comparator<Property> propertyOrder;
    private final Comparator<Map.Entry<String, String>> prefixOrder;
    private final Set<Resource> processedResources = new HashSet<Resource>();
    private final Queue<Resource> resourceQueue = new ArrayDeque<Resource>();
    private final Model model;
    private final AspectModelUrn rootElementUrn;
    private final PrintWriter writer;
    private final Map<String, String> prefixMap;
    private final BAMM bamm;
    private final PrintVisitor printVisitor;

    public PrettyPrinter(Model model, KnownVersion metaModelVersion, AspectModelUrn rootElementUrn, PrintWriter writer) {
        this(new VersionedModel(ModelFactory.createDefaultModel(), metaModelVersion, model), rootElementUrn, writer);
    }

    public PrettyPrinter(VersionedModel versionedModel, AspectModelUrn rootElementUrn, PrintWriter writer) {
        this.model = versionedModel.getRawModel();
        KnownVersion metaModelVersion = (KnownVersion)KnownVersion.fromVersionString((String)versionedModel.getMetaModelVersion().toString()).orElseThrow(() -> new UnsupportedVersionException(versionedModel.getMetaModelVersion()));
        this.writer = writer;
        this.rootElementUrn = rootElementUrn;
        this.printVisitor = new PrintVisitor(this.model);
        this.bamm = new BAMM(metaModelVersion);
        BAMMC bammc = new BAMMC(metaModelVersion);
        this.prefixMap = new HashMap<String, String>(Namespace.createPrefixMap((KnownVersion)metaModelVersion));
        this.prefixMap.putAll(versionedModel.getModel().getNsPrefixMap());
        this.prefixMap.put("", rootElementUrn.getUrnPrefix());
        this.model.setNsPrefixes(this.prefixMap);
        this.propertyOrder = this.createPredefinedPropertyOrder(bammc);
        this.prefixOrder = this.createPredefinedPrefixOrder();
    }

    private Comparator<Property> createPredefinedPropertyOrder(BAMMC bammc) {
        ArrayList<Property> predefinedPropertyOrder = new ArrayList<Property>();
        predefinedPropertyOrder.add(this.bamm._extends());
        predefinedPropertyOrder.add(this.bamm.preferredName());
        predefinedPropertyOrder.add(this.bamm.description());
        predefinedPropertyOrder.add(this.bamm.see());
        predefinedPropertyOrder.add(this.bamm.characteristic());
        predefinedPropertyOrder.add(this.bamm.properties());
        predefinedPropertyOrder.add(this.bamm.operations());
        predefinedPropertyOrder.add(this.bamm.events());
        predefinedPropertyOrder.add(this.bamm.input());
        predefinedPropertyOrder.add(this.bamm.output());
        predefinedPropertyOrder.add(this.bamm.baseCharacteristic());
        predefinedPropertyOrder.add(this.bamm.dataType());
        predefinedPropertyOrder.add(this.bamm.exampleValue());
        predefinedPropertyOrder.add(this.bamm.value());
        predefinedPropertyOrder.add(this.bamm.property());
        predefinedPropertyOrder.add(this.bamm.optional());
        predefinedPropertyOrder.add(bammc.languageCode());
        predefinedPropertyOrder.add(bammc.localeCode());
        predefinedPropertyOrder.add(bammc.left());
        predefinedPropertyOrder.add(bammc.right());
        predefinedPropertyOrder.add(bammc.minValue());
        predefinedPropertyOrder.add(bammc.maxValue());
        predefinedPropertyOrder.add(bammc.lowerBoundDefinition());
        predefinedPropertyOrder.add(bammc.upperBoundDefinition());
        predefinedPropertyOrder.add(bammc.defaultValue());
        predefinedPropertyOrder.add(bammc.unit());
        predefinedPropertyOrder.add(bammc.left());
        predefinedPropertyOrder.add(bammc.right());
        predefinedPropertyOrder.add(bammc.deconstructionRule());
        predefinedPropertyOrder.add(bammc.elements());
        predefinedPropertyOrder.add(bammc.values());
        predefinedPropertyOrder.add(bammc.integer());
        predefinedPropertyOrder.add(bammc.scale());
        return Comparator.comparingInt(property -> predefinedPropertyOrder.contains(property) ? predefinedPropertyOrder.indexOf(property) : Integer.MAX_VALUE).thenComparing(Property::getLocalName);
    }

    private Comparator<Map.Entry<String, String>> createPredefinedPrefixOrder() {
        ArrayList<String> predefinedPrefixOrder = new ArrayList<String>();
        predefinedPrefixOrder.add("bamm");
        predefinedPrefixOrder.add("bamm-c");
        predefinedPrefixOrder.add("bamm-e");
        predefinedPrefixOrder.add("unit");
        predefinedPrefixOrder.add("rdf");
        predefinedPrefixOrder.add("rdfs");
        predefinedPrefixOrder.add("xsd");
        predefinedPrefixOrder.add("");
        return Comparator.comparingInt(entry -> predefinedPrefixOrder.contains(entry.getKey()) ? predefinedPrefixOrder.indexOf(entry.getKey()) : Integer.MAX_VALUE).thenComparing(Map.Entry::getKey);
    }

    private Properties loadProperties(String filename) {
        Properties properties = new Properties();
        InputStream propertiesResource = PrettyPrinter.class.getClassLoader().getResourceAsStream(filename);
        try {
            properties.load(propertiesResource);
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to load Properties: " + filename);
        }
        return properties;
    }

    private void showMilestoneBanner() {
        Properties applicationProperties = this.loadProperties("pom.properties");
        String version = applicationProperties.get("aspect-meta-model-version").toString();
        if (version.contains("-M")) {
            this.writer.println("# This model was created using BAMM version " + version + " and is not intended for productive usage.");
            this.writer.println();
        }
    }

    public void print() {
        this.showMilestoneBanner();
        this.prefixMap.entrySet().stream().sorted(this.prefixOrder).forEach(entry -> this.writer.format("@prefix %s: <%s> .%n", entry.getKey(), entry.getValue()));
        this.writer.println();
        Resource rootElementResource = ResourceFactory.createResource((String)this.rootElementUrn.toString());
        this.resourceQueue.add(rootElementResource);
        while (!this.resourceQueue.isEmpty()) {
            Resource resource2 = this.resourceQueue.poll();
            this.writer.print(this.processElement(resource2, 0));
        }
        this.model.listSubjects().toSet().stream().filter(RDFNode::isURIResource).filter(resource -> !this.processedResources.contains(resource)).map(resource -> this.processElement((Resource)resource, 0)).forEach(this.writer::print);
    }

    private List<Statement> statements(Resource subject, Property predicate, RDFNode object) {
        return ImmutableList.copyOf((Iterator)this.model.listStatements(subject, predicate, object));
    }

    private Optional<Statement> statement(Resource subject, Property predicate, RDFNode object) {
        return this.statements(subject, predicate, object).stream().findFirst();
    }

    private Optional<Statement> elementDefinition(Resource element) {
        return this.statement(element, RDF.type, null);
    }

    private String serializeList(Resource list, int indentationLevel) {
        if (list.isURIResource() && list.getURI().equals(RDF.nil.getURI())) {
            return "( )";
        }
        return ((RDFList)list.as(RDFList.class)).asJavaList().stream().map(listNode -> this.serialize((RDFNode)listNode, indentationLevel)).collect(Collectors.joining(" ", "( ", " )"));
    }

    private String serialize(RDFNode rdfNode, int indentationLevel) {
        if (rdfNode.isURIResource() && rdfNode.asResource().getURI().equals(RDF.type.getURI())) {
            return "a";
        }
        if (rdfNode.isResource()) {
            return this.serializeResource(rdfNode, indentationLevel);
        }
        if (rdfNode.isLiteral()) {
            return this.serializeLiteral(rdfNode, indentationLevel);
        }
        return this.print(rdfNode).replace('\'', '\"');
    }

    private String quoteValue(String value) {
        int approximateSize = value.length() <= 50 ? 64 : 256;
        StringBuilder buffer = new StringBuilder(approximateSize);
        if (value.contains(System.lineSeparator())) {
            buffer.append(TRIPLE_QUOTE);
            String[] lines = value.split(LINE_BREAK);
            for (int i = 0; i < lines.length; ++i) {
                this.escapeStringAndAppendToBuilder(lines[i], buffer);
                if (i == lines.length - 1) continue;
                buffer.append(LINE_BREAK);
            }
            buffer.append(TRIPLE_QUOTE);
            return buffer.toString();
        }
        buffer.append("\"");
        this.escapeStringAndAppendToBuilder(value, buffer);
        buffer.append("\"");
        return buffer.toString();
    }

    private void escapeStringAndAppendToBuilder(String input, StringBuilder builder) {
        String escapedSpecialCharacters = StringEscapeUtils.escapeJava((String)input);
        char[] chars = escapedSpecialCharacters.toCharArray();
        int index = 0;
        while (index < chars.length) {
            boolean indexAtUnicodeEscapeSequence;
            boolean bl = indexAtUnicodeEscapeSequence = chars[index] == '\\' && index + 1 < chars.length && chars[index + 1] == 'u' && index + 5 <= chars.length - 1;
            if (indexAtUnicodeEscapeSequence) {
                long codepoint = Long.parseLong(new String(chars, index + 2, 4), 16);
                builder.append((char)codepoint);
                index += 6;
                continue;
            }
            builder.append(chars[index]);
            ++index;
        }
    }

    private String serializeLiteral(RDFNode rdfNode, int indentationLevel) {
        Literal literal = rdfNode.asLiteral();
        String value = literal.getLexicalForm();
        RDFDatatype type = rdfNode.asNode().getLiteralDatatype();
        if (type == null || type.getURI().equals(XSD.xstring.getURI())) {
            return this.quoteValue(value);
        }
        if (type.getURI().equals(XSD.xboolean.getURI()) || type.getURI().equals(XSD.integer.getURI())) {
            return value;
        }
        if (type.getURI().equals(RDF.langString.getURI())) {
            return this.quoteValue(value) + "@" + literal.getLanguage();
        }
        return this.quoteValue(value) + "^^" + this.serialize((RDFNode)this.model.getResource(rdfNode.asNode().getLiteralDatatypeURI()), indentationLevel);
    }

    private String serializeAnonymousNodeWithoutRdfType(Resource resource, int indentationLevel) {
        List<Statement> statements = this.statements(resource, null, null);
        if (statements.isEmpty()) {
            return "";
        }
        return statements.stream().map(Statement::getPredicate).sorted(this.propertyOrder).flatMap(property -> this.statements(resource, (Property)property, null).stream()).distinct().map(statement -> String.format("%s %s", this.serialize((RDFNode)statement.getPredicate(), indentationLevel), this.serialize(statement.getObject(), indentationLevel))).collect(Collectors.joining("; ", "[ ", " ]"));
    }

    private String serializeResource(RDFNode rdfNode, int indentationLevel) {
        Resource resource = rdfNode.asResource();
        if (this.processedResources.contains(resource)) {
            return this.print((RDFNode)resource);
        }
        if (resource.isURIResource() && resource.getURI().equals(RDF.nil.getURI()) || this.statements(resource, RDF.first, null).iterator().hasNext()) {
            return this.serializeList(resource, indentationLevel);
        }
        if (resource.isURIResource()) {
            if (this.elementDefinition(resource).isPresent()) {
                this.resourceQueue.add(resource);
            }
            return this.print((RDFNode)resource);
        }
        return this.processElement(resource, indentationLevel + 1);
    }

    private String processElement(Resource element, int indentationLevel) {
        if (this.processedResources.contains(element)) {
            return "";
        }
        Optional<Statement> elementDefinition = this.elementDefinition(element);
        if (elementDefinition.isEmpty()) {
            return this.serializeAnonymousNodeWithoutRdfType(element, indentationLevel);
        }
        String serializedProperty = this.serialize((RDFNode)elementDefinition.get().getPredicate(), indentationLevel);
        String serializedObject = this.serialize((RDFNode)elementDefinition.get().getObject().asResource(), indentationLevel);
        String firstLine = element.isAnon() ? String.format("[%n%s%s %s", INDENT.repeat(indentationLevel + 1), serializedProperty, serializedObject) : String.format("%s %s %s", this.serialize((RDFNode)element, indentationLevel), serializedProperty, serializedObject);
        this.processedResources.add(element);
        String body = this.statements(element, null, null).stream().map(Statement::getPredicate).filter(property -> !property.equals(RDF.type)).sorted(this.propertyOrder).flatMap(property -> this.statements(element, (Property)property, null).stream()).distinct().map(statement -> String.format("%s%s %s", INDENT.repeat(indentationLevel + 1), this.serialize((RDFNode)statement.getPredicate(), indentationLevel), this.serialize(statement.getObject(), indentationLevel))).collect(Collectors.joining(String.format(" ;%n", new Object[0]), "", element.isAnon() ? String.format(" %n%s]", INDENT.repeat(indentationLevel)) : ""));
        if (body.isEmpty()) {
            return String.format("%s .%n%n", firstLine);
        }
        String firstPart = String.format("%s ;%n%s", firstLine, body);
        if (body.trim().endsWith(".")) {
            return firstPart;
        }
        if (body.endsWith("]") && indentationLevel >= 1) {
            return firstPart;
        }
        return String.format(indentationLevel >= 1 ? "%s ;%n" : "%s .%n%n", firstPart);
    }

    private String print(RDFNode node) {
        if (node == null) {
            return "null";
        }
        return (String)node.asNode().visitWith((NodeVisitor)this.printVisitor);
    }

    record PrintVisitor(Model model) implements NodeVisitor
    {
        public Object visitAny(Node_ANY it) {
            return "*";
        }

        public Object visitBlank(Node_Blank it, BlankNodeId id) {
            return it.toString();
        }

        public Object visitLiteral(Node_Literal it, LiteralLabel lit) {
            String lf = it.getLiteralLexicalForm();
            String singleQuote = "'";
            if (lf.contains("'")) {
                lf = lf.replace("'", "\\'");
            }
            return "'" + lf + "'" + (String)(Util.isSimpleString((Node)it) ? "" : "^^" + it.getLiteralDatatypeURI());
        }

        public Object visitURI(Node_URI it, String uri) {
            String suri = this.model.shortForm(uri);
            if (uri.equals(suri)) {
                return "<" + uri + ">";
            }
            return suri;
        }

        public Object visitVariable(Node_Variable it, String name) {
            return it.toString();
        }

        public Object visitTriple(Node_Triple it, Triple triple) {
            return it.toString();
        }

        public Object visitGraph(Node_Graph it, Graph graph) {
            return it.toString();
        }
    }
}

