/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.serializer;

import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.resolver.exceptions.InvalidModelException;
import io.openmanufacturing.sds.aspectmodel.resolver.services.DataType;
import io.openmanufacturing.sds.aspectmodel.resolver.services.ExtendedXsdDataType;
import io.openmanufacturing.sds.aspectmodel.urn.AspectModelUrn;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMM;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMMC;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMME;
import io.openmanufacturing.sds.aspectmodel.vocabulary.Namespace;
import io.openmanufacturing.sds.aspectmodel.vocabulary.UNIT;
import io.openmanufacturing.sds.metamodel.AbstractEntity;
import io.openmanufacturing.sds.metamodel.Aspect;
import io.openmanufacturing.sds.metamodel.Base;
import io.openmanufacturing.sds.metamodel.Characteristic;
import io.openmanufacturing.sds.metamodel.Code;
import io.openmanufacturing.sds.metamodel.Collection;
import io.openmanufacturing.sds.metamodel.CollectionValue;
import io.openmanufacturing.sds.metamodel.ComplexType;
import io.openmanufacturing.sds.metamodel.Constraint;
import io.openmanufacturing.sds.metamodel.Duration;
import io.openmanufacturing.sds.metamodel.Either;
import io.openmanufacturing.sds.metamodel.EncodingConstraint;
import io.openmanufacturing.sds.metamodel.EntityInstance;
import io.openmanufacturing.sds.metamodel.Enumeration;
import io.openmanufacturing.sds.metamodel.Event;
import io.openmanufacturing.sds.metamodel.FixedPointConstraint;
import io.openmanufacturing.sds.metamodel.HasProperties;
import io.openmanufacturing.sds.metamodel.IsDescribed;
import io.openmanufacturing.sds.metamodel.LanguageConstraint;
import io.openmanufacturing.sds.metamodel.LengthConstraint;
import io.openmanufacturing.sds.metamodel.LocaleConstraint;
import io.openmanufacturing.sds.metamodel.Measurement;
import io.openmanufacturing.sds.metamodel.Operation;
import io.openmanufacturing.sds.metamodel.Quantifiable;
import io.openmanufacturing.sds.metamodel.QuantityKind;
import io.openmanufacturing.sds.metamodel.RangeConstraint;
import io.openmanufacturing.sds.metamodel.RegularExpressionConstraint;
import io.openmanufacturing.sds.metamodel.Scalar;
import io.openmanufacturing.sds.metamodel.ScalarValue;
import io.openmanufacturing.sds.metamodel.Set;
import io.openmanufacturing.sds.metamodel.SingleEntity;
import io.openmanufacturing.sds.metamodel.SortedSet;
import io.openmanufacturing.sds.metamodel.State;
import io.openmanufacturing.sds.metamodel.StructuredValue;
import io.openmanufacturing.sds.metamodel.TimeSeries;
import io.openmanufacturing.sds.metamodel.Trait;
import io.openmanufacturing.sds.metamodel.Type;
import io.openmanufacturing.sds.metamodel.Unit;
import io.openmanufacturing.sds.metamodel.datatypes.LangString;
import io.openmanufacturing.sds.metamodel.visitor.AspectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class RdfModelCreatorVisitor
implements AspectVisitor<ElementModel, Base>,
Function<Aspect, Model> {
    private final BAMM bamm;
    private final BAMMC bammc;
    private final BAMME bamme;
    private final UNIT unitNamespace;
    private final Namespace namespace;
    private final Map<IsDescribed, Resource> anonymousResources = new HashMap<IsDescribed, Resource>();
    private final List<Resource> resourceList = new LinkedList<Resource>();
    private final List<ComplexType> hasVisited = new LinkedList<ComplexType>();

    public RdfModelCreatorVisitor(KnownVersion metaModelVersion, Namespace namespace) {
        this.bamm = new BAMM(metaModelVersion);
        this.bammc = new BAMMC(metaModelVersion);
        this.bamme = new BAMME(metaModelVersion, this.bamm);
        this.unitNamespace = new UNIT(metaModelVersion, this.bamm);
        this.namespace = namespace;
    }

    private Literal serializeLocalizedString(LangString localizedString) {
        Locale languageTag = localizedString.getLanguageTag();
        String value = localizedString.getValue();
        return ResourceFactory.createLangLiteral((String)value, (String)languageTag.toLanguageTag());
    }

    private Literal serializePlainString(String string) {
        return ResourceFactory.createPlainLiteral((String)string);
    }

    private RDFNode serializeTypedValue(String value, RDFDatatype rdfDatatype) {
        return ResourceFactory.createTypedLiteral((String)value, (RDFDatatype)rdfDatatype);
    }

    private Literal serializeBoolean(Boolean value) {
        return ResourceFactory.createTypedLiteral((Object)value);
    }

    private boolean isLocalElement(IsDescribed element) {
        return element.getAspectModelUrn().isEmpty() || ((AspectModelUrn)element.getAspectModelUrn().get()).getUrnPrefix().equals(this.namespace.getNamespace());
    }

    private Resource getElementResource(IsDescribed element) {
        if (element.getAspectModelUrn().isEmpty()) {
            return this.anonymousResources.computeIfAbsent(element, key -> ResourceFactory.createResource());
        }
        return ResourceFactory.createResource((String)((AspectModelUrn)element.getAspectModelUrn().get()).toString());
    }

    private Model serializeDescriptions(Resource elementResource, IsDescribed element) {
        Model model = ModelFactory.createDefaultModel();
        element.getSee().forEach(seeValue -> model.add(elementResource, this.bamm.see(), (RDFNode)ResourceFactory.createResource((String)seeValue)));
        element.getPreferredNames().stream().map(this::serializeLocalizedString).forEach(preferredName -> model.add(elementResource, this.bamm.preferredName(), (RDFNode)preferredName));
        element.getDescriptions().stream().map(this::serializeLocalizedString).forEach(description -> model.add(elementResource, this.bamm.description(), (RDFNode)description));
        return model;
    }

    private Model serializePropertiesOrParameters(Resource elementResource, HasProperties element, Property theProperty) {
        Model model = ModelFactory.createDefaultModel();
        ArrayList propertiesList = new ArrayList();
        if (this.resourceList.contains(elementResource)) {
            return model;
        }
        this.resourceList.add(elementResource);
        element.getProperties().stream().filter(this::isLocalElement).map(property -> {
            Model propertyModel = ModelFactory.createDefaultModel();
            ElementModel propertyResult = (ElementModel)property.accept((AspectVisitor)this, (Object)element);
            propertyModel.add(propertyResult.getModel());
            Resource propertyResource = propertyResult.getFocusElement().map(RDFNode::asResource).orElseGet(() -> this.getElementResource((IsDescribed)property));
            if (property.isOptional() || property.isNotInPayload() || !property.getName().equals(property.getPayloadName())) {
                Resource anonymousPropertyNode = this.serializeAnonymousPropertyNodes((io.openmanufacturing.sds.metamodel.Property)property, propertyModel, propertyResource);
                propertiesList.add(anonymousPropertyNode);
                return propertyModel;
            }
            propertiesList.add(propertyResource);
            return propertyModel;
        }).forEach(arg_0 -> ((Model)model).add(arg_0));
        model.add(elementResource, theProperty, (RDFNode)model.createList(propertiesList.iterator()));
        return model;
    }

    private Model serializeParameters(Resource elementResource, HasProperties element) {
        return this.serializePropertiesOrParameters(elementResource, element, this.bamm.parameters());
    }

    private Model serializeProperties(Resource elementResource, HasProperties element) {
        return this.serializePropertiesOrParameters(elementResource, element, this.bamm.properties());
    }

    private Resource serializeAnonymousPropertyNodes(io.openmanufacturing.sds.metamodel.Property property, Model propertyModel, Resource propertyResource) {
        Resource anonymousPropertyNode = ResourceFactory.createResource();
        propertyModel.add(anonymousPropertyNode, this.bamm.property(), (RDFNode)propertyResource);
        if (property.isOptional()) {
            propertyModel.add(anonymousPropertyNode, this.bamm.optional(), (RDFNode)this.serializeBoolean(true));
        }
        if (property.isNotInPayload()) {
            propertyModel.add(anonymousPropertyNode, this.bamm.notInPayload(), (RDFNode)this.serializeBoolean(true));
        }
        if (!property.getName().equals(property.getPayloadName())) {
            propertyModel.add(anonymousPropertyNode, this.bamm.payloadName(), (RDFNode)this.serializePlainString(property.getPayloadName()));
        }
        return anonymousPropertyNode;
    }

    private Model createCharacteristicsModel(Characteristic characteristic) {
        return this.createCharacteristicsModel(characteristic, false);
    }

    private Model createCharacteristicsModel(Characteristic characteristic, boolean skipDataType) {
        Model model = ModelFactory.createDefaultModel();
        if (!this.isLocalElement((IsDescribed)characteristic)) {
            return model;
        }
        Resource resource = this.getElementResource((IsDescribed)characteristic);
        if (!skipDataType && characteristic.getDataType().isPresent()) {
            Type type = (Type)characteristic.getDataType().get();
            model.add(resource, this.bamm.dataType(), (RDFNode)ResourceFactory.createResource((String)type.getUrn()));
            if (type.is(ComplexType.class)) {
                model.add(((ElementModel)type.accept((AspectVisitor)this, (Object)characteristic)).getModel());
            }
        }
        model.add(this.serializeDescriptions(resource, (IsDescribed)characteristic));
        return model;
    }

    public ElementModel visitBase(Base base, Base context) {
        return new ElementModel(ModelFactory.createDefaultModel(), Optional.empty());
    }

    private Model createCollectionModel(Collection collection) {
        Model model = ModelFactory.createDefaultModel();
        if (!this.isLocalElement((IsDescribed)collection)) {
            return model;
        }
        Resource resource = this.getElementResource((IsDescribed)collection);
        if (collection.getElementCharacteristic().isPresent()) {
            Characteristic elementCharacteristic = (Characteristic)collection.getElementCharacteristic().get();
            model.add(resource, this.bammc.elementCharacteristic(), (RDFNode)this.getElementResource((IsDescribed)elementCharacteristic));
            model.add(((ElementModel)elementCharacteristic.accept((AspectVisitor)this, (Object)collection)).getModel());
        } else if (collection.getDataType().isPresent()) {
            Type type = (Type)collection.getDataType().get();
            model.add(resource, this.bamm.dataType(), (RDFNode)ResourceFactory.createResource((String)type.getUrn()));
            if (!type.is(Scalar.class)) {
                model.add(((ElementModel)type.accept((AspectVisitor)this, (Object)collection)).getModel());
            }
        }
        model.add(this.serializeDescriptions(resource, (IsDescribed)collection));
        return model;
    }

    public ElementModel visitCollection(Collection collection, Base context) {
        Model model = this.createCollectionModel(collection);
        Resource resource = this.getElementResource((IsDescribed)collection);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Collection());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitList(io.openmanufacturing.sds.metamodel.List list, Base context) {
        Model model = this.createCollectionModel((Collection)list);
        Resource resource = this.getElementResource((IsDescribed)list);
        model.add(resource, RDF.type, (RDFNode)this.bammc.List());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitSet(Set set, Base context) {
        Model model = this.createCollectionModel((Collection)set);
        Resource resource = this.getElementResource((IsDescribed)set);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Set());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitSortedSet(SortedSet sortedSet, Base context) {
        Model model = this.createCollectionModel((Collection)sortedSet);
        Resource resource = this.getElementResource((IsDescribed)sortedSet);
        model.add(resource, RDF.type, (RDFNode)this.bammc.SortedSet());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitTimeSeries(TimeSeries timeSeries, Base context) {
        Model model = this.createCollectionModel((Collection)timeSeries);
        Resource resource = this.getElementResource((IsDescribed)timeSeries);
        model.add(resource, RDF.type, (RDFNode)this.bammc.TimeSeries());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitConstraint(Constraint constraint, Base context) {
        Model model = ModelFactory.createDefaultModel();
        if (!this.isLocalElement((IsDescribed)constraint)) {
            return new ElementModel(model, Optional.empty());
        }
        Resource resource = this.getElementResource((IsDescribed)constraint);
        model.add(this.serializeDescriptions(resource, (IsDescribed)constraint));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitEncodingConstraint(EncodingConstraint encodingConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)encodingConstraint, null).getModel();
        Resource resource = this.getElementResource((IsDescribed)encodingConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.EncodingConstraint());
        Resource encoding = this.bamm.resource(encodingConstraint.getValue().name());
        model.add(resource, this.bamm.value(), (RDFNode)encoding);
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitLanguageConstraint(LanguageConstraint languageConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)languageConstraint, null).getModel();
        Resource resource = this.getElementResource((IsDescribed)languageConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.LanguageConstraint());
        model.add(resource, this.bammc.languageCode(), (RDFNode)this.serializePlainString(languageConstraint.getLanguageCode().toLanguageTag()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitLocaleConstraint(LocaleConstraint localeConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)localeConstraint, null).getModel();
        Resource resource = this.getElementResource((IsDescribed)localeConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.LocaleConstraint());
        model.add(resource, this.bammc.localeCode(), (RDFNode)this.serializePlainString(localeConstraint.getLocaleCode().toLanguageTag()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitLengthConstraint(LengthConstraint lengthConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)lengthConstraint, null).getModel();
        Resource resource = this.getElementResource((IsDescribed)lengthConstraint);
        lengthConstraint.getMinValue().stream().map(minValue -> ResourceFactory.createStatement((Resource)resource, (Property)this.bammc.minValue(), (RDFNode)this.serializeTypedValue(minValue.toString(), (RDFDatatype)ExtendedXsdDataType.NON_NEGATIVE_INTEGER))).forEach(arg_0 -> ((Model)model).add(arg_0));
        lengthConstraint.getMaxValue().stream().map(maxValue -> ResourceFactory.createStatement((Resource)resource, (Property)this.bammc.maxValue(), (RDFNode)this.serializeTypedValue(maxValue.toString(), (RDFDatatype)ExtendedXsdDataType.NON_NEGATIVE_INTEGER))).forEach(arg_0 -> ((Model)model).add(arg_0));
        model.add(resource, RDF.type, (RDFNode)this.bammc.LengthConstraint());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitRangeConstraint(RangeConstraint rangeConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)rangeConstraint, null).getModel();
        Resource resource = this.getElementResource((IsDescribed)rangeConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.RangeConstraint());
        rangeConstraint.getMinValue().stream().flatMap(minValue -> ((ElementModel)minValue.accept((AspectVisitor)this, (Object)rangeConstraint)).getFocusElement().stream()).map(literal -> ResourceFactory.createStatement((Resource)resource, (Property)this.bammc.minValue(), (RDFNode)literal)).forEach(arg_0 -> ((Model)model).add(arg_0));
        rangeConstraint.getMaxValue().stream().flatMap(maxValue -> ((ElementModel)maxValue.accept((AspectVisitor)this, (Object)rangeConstraint)).getFocusElement().stream()).map(literal -> ResourceFactory.createStatement((Resource)resource, (Property)this.bammc.maxValue(), (RDFNode)literal)).forEach(arg_0 -> ((Model)model).add(arg_0));
        model.add(resource, this.bammc.lowerBoundDefinition(), (RDFNode)this.bammc.resource(rangeConstraint.getLowerBoundDefinition().toString().replace(" ", "_").toUpperCase()));
        model.add(resource, this.bammc.upperBoundDefinition(), (RDFNode)this.bammc.resource(rangeConstraint.getUpperBoundDefinition().toString().replace(" ", "_").toUpperCase()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitRegularExpressionConstraint(RegularExpressionConstraint regularExpressionConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)regularExpressionConstraint, null).getModel();
        Resource resource = this.getElementResource((IsDescribed)regularExpressionConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.RegularExpressionConstraint());
        model.add(resource, this.bamm.value(), (RDFNode)this.serializePlainString(regularExpressionConstraint.getValue()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitFixedPointConstraint(FixedPointConstraint fixedPointConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)fixedPointConstraint, null).getModel();
        Resource resource = this.getElementResource((IsDescribed)fixedPointConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.FixedPointConstraint());
        model.add(resource, this.bammc.integer(), this.serializeTypedValue(fixedPointConstraint.getInteger().toString(), (RDFDatatype)ExtendedXsdDataType.POSITIVE_INTEGER));
        model.add(resource, this.bammc.scale(), this.serializeTypedValue(fixedPointConstraint.getScale().toString(), (RDFDatatype)ExtendedXsdDataType.POSITIVE_INTEGER));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitCode(Code code, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)code);
        Resource resource = this.getElementResource((IsDescribed)code);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Code());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitDuration(Duration duration, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)duration);
        Resource resource = this.getElementResource((IsDescribed)duration);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Duration());
        this.getUnitStatement((Quantifiable)duration, resource).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        duration.getUnit().map(unit -> (ElementModel)unit.accept((AspectVisitor)this, (Object)duration)).ifPresent(elementModel -> model.add(elementModel.getModel()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitEither(Either either, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)either);
        Resource resource = this.getElementResource((IsDescribed)either);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Either());
        ElementModel left = (ElementModel)either.getLeft().accept((AspectVisitor)this, (Object)either);
        left.getFocusElement().ifPresent(leftCharacteristic -> model.add(resource, this.bammc.left(), leftCharacteristic));
        model.add(left.getModel());
        ElementModel right = (ElementModel)either.getRight().accept((AspectVisitor)this, (Object)either);
        right.getFocusElement().ifPresent(rightCharacteristic -> model.add(resource, this.bammc.right(), rightCharacteristic));
        model.add(right.getModel());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitEnumeration(Enumeration enumeration, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)enumeration);
        Resource resource = this.getElementResource((IsDescribed)enumeration);
        if (!enumeration.is(State.class)) {
            model.add(resource, RDF.type, (RDFNode)this.bammc.Enumeration());
        }
        List elements = enumeration.getValues().stream().flatMap(value -> {
            ElementModel valueElementModel = (ElementModel)value.accept((AspectVisitor)this, (Object)enumeration);
            model.add(valueElementModel.getModel());
            return valueElementModel.getFocusElement().stream();
        }).collect(Collectors.toList());
        model.add(resource, this.bammc.values(), (RDFNode)model.createList(elements.iterator()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitEntityInstance(EntityInstance instance, Base context) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = this.getElementResource((IsDescribed)instance);
        model.add(resource, RDF.type, (RDFNode)this.getElementResource((IsDescribed)instance.getEntityType()));
        instance.getAssertions().forEach((key, value) -> {
            Property property = ResourceFactory.createProperty((String)((AspectModelUrn)key.getAspectModelUrn().orElseThrow()).toString());
            ElementModel valueElementModel = (ElementModel)value.accept((AspectVisitor)this, (Object)instance);
            model.add(valueElementModel.getModel());
            valueElementModel.getFocusElement().ifPresent(elementValue -> model.add(resource, property, elementValue));
        });
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitScalarValue(ScalarValue value, Base context) {
        Model model = ModelFactory.createDefaultModel();
        Type type = value.getType();
        if (type.getUrn().equals(RDF.langString.getURI())) {
            LangString langString = (LangString)value.getValue();
            Literal literal = ResourceFactory.createLangLiteral((String)langString.getValue(), (String)langString.getLanguageTag().toLanguageTag());
            return new ElementModel(model, Optional.of(literal));
        }
        Optional<RDFDatatype> targetType = DataType.getAllSupportedTypesForMetaModelVersion((KnownVersion)value.getMetaModelVersion()).stream().filter(dataType -> dataType.getURI().equals(type.getUrn())).findAny();
        if (targetType.isEmpty() || type.getUrn().equals(XSD.xstring.getURI())) {
            return new ElementModel(model, Optional.of(ResourceFactory.createStringLiteral((String)value.getValue().toString())));
        }
        return new ElementModel(model, Optional.of(ResourceFactory.createTypedLiteral((String)targetType.get().unparse(value.getValue()), (RDFDatatype)targetType.get())));
    }

    public ElementModel visitCollectionValue(CollectionValue collection, Base context) {
        Model model = ModelFactory.createDefaultModel();
        List elements = collection.getValues().stream().flatMap(value -> {
            ElementModel valueElementModel = (ElementModel)value.accept((AspectVisitor)this, (Object)collection);
            model.add(valueElementModel.getModel());
            return valueElementModel.getFocusElement().stream();
        }).collect(Collectors.toList());
        RDFList rdfList = model.createList(elements.iterator());
        return new ElementModel(model, Optional.of(rdfList));
    }

    public ElementModel visitState(State state, Base context) {
        Model model = this.visitEnumeration((Enumeration)state, null).getModel();
        Resource resource = this.getElementResource((IsDescribed)state);
        model.add(resource, RDF.type, (RDFNode)this.bammc.State());
        ElementModel defaultValueElementModel = (ElementModel)state.getDefaultValue().accept((AspectVisitor)this, (Object)state);
        model.add(defaultValueElementModel.getModel());
        defaultValueElementModel.getFocusElement().ifPresent(defaultValue -> model.add(resource, this.bammc.defaultValue(), defaultValue));
        return new ElementModel(model, Optional.of(resource));
    }

    private Optional<Statement> getUnitStatement(Quantifiable elementWithUnit, Resource targetResource) {
        return elementWithUnit.getUnit().flatMap(IsDescribed::getAspectModelUrn).map(AspectModelUrn::toString).map(unitUrn -> ResourceFactory.createStatement((Resource)targetResource, (Property)this.bammc.unit(), (RDFNode)ResourceFactory.createResource((String)unitUrn)));
    }

    public ElementModel visitMeasurement(Measurement measurement, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)measurement);
        Resource resource = this.getElementResource((IsDescribed)measurement);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Measurement());
        this.getUnitStatement((Quantifiable)measurement, resource).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        measurement.getUnit().map(unit -> (ElementModel)unit.accept((AspectVisitor)this, (Object)measurement)).ifPresent(elementModel -> model.add(elementModel.getModel()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitQuantifiable(Quantifiable quantifiable, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)quantifiable);
        Resource resource = this.getElementResource((IsDescribed)quantifiable);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Quantifiable());
        this.getUnitStatement(quantifiable, resource).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        quantifiable.getUnit().map(unit -> (ElementModel)unit.accept((AspectVisitor)this, (Object)quantifiable)).ifPresent(elementModel -> model.add(elementModel.getModel()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitSingleEntity(SingleEntity singleEntity, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)singleEntity);
        Resource resource = this.getElementResource((IsDescribed)singleEntity);
        model.add(resource, RDF.type, (RDFNode)this.bammc.SingleEntity());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitStructuredValue(StructuredValue structuredValue, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)structuredValue);
        Resource resource = this.getElementResource((IsDescribed)structuredValue);
        model.add(resource, RDF.type, (RDFNode)this.bammc.StructuredValue());
        model.add(resource, this.bammc.deconstructionRule(), (RDFNode)this.serializePlainString(structuredValue.getDeconstructionRule()));
        RDFList elementsList = model.createList(structuredValue.getElements().stream().map(element -> element instanceof String ? this.serializePlainString((String)element) : this.getElementResource((IsDescribed)((io.openmanufacturing.sds.metamodel.Property)element))).iterator());
        model.add(resource, this.bammc.elements(), (RDFNode)elementsList);
        structuredValue.getElements().stream().filter(io.openmanufacturing.sds.metamodel.Property.class::isInstance).map(io.openmanufacturing.sds.metamodel.Property.class::cast).map(property -> (ElementModel)property.accept((AspectVisitor)this, (Object)structuredValue)).forEach(elementModel -> model.add(elementModel.getModel()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitTrait(Trait trait, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)trait, true);
        Resource resource = this.getElementResource((IsDescribed)trait);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Trait());
        Resource baseCharacteristicResource = this.getElementResource((IsDescribed)trait.getBaseCharacteristic());
        model.add(resource, this.bammc.baseCharacteristic(), (RDFNode)baseCharacteristicResource);
        model.add(((ElementModel)trait.getBaseCharacteristic().accept((AspectVisitor)this, (Object)trait)).getModel());
        trait.getConstraints().forEach(constraint -> {
            Resource constraintResource = this.getElementResource((IsDescribed)constraint);
            model.add(resource, this.bammc.constraint(), (RDFNode)constraintResource);
            model.add(((ElementModel)constraint.accept((AspectVisitor)this, (Object)trait)).getModel());
        });
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitAspect(Aspect aspect, Base context) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = this.getElementResource((IsDescribed)aspect);
        model.add(resource, RDF.type, (RDFNode)this.bamm.Aspect());
        model.add(this.serializeDescriptions(resource, (IsDescribed)aspect));
        model.add(this.serializeProperties(resource, (HasProperties)aspect));
        model.add(resource, this.bamm.operations(), (RDFNode)model.createList(aspect.getOperations().stream().map(this::getElementResource).iterator()));
        aspect.getOperations().stream().map(operation -> (ElementModel)operation.accept((AspectVisitor)this, (Object)aspect)).forEach(elementModel -> model.add(elementModel.getModel()));
        if (!aspect.getEvents().isEmpty()) {
            model.add(resource, this.bamm.events(), (RDFNode)model.createList(aspect.getEvents().stream().map(this::getElementResource).iterator()));
            aspect.getEvents().stream().map(event -> (ElementModel)event.accept((AspectVisitor)this, (Object)aspect)).forEach(elementModel -> model.add(elementModel.getModel()));
        }
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitProperty(io.openmanufacturing.sds.metamodel.Property property, Base context) {
        io.openmanufacturing.sds.metamodel.Property superProperty;
        Model model = ModelFactory.createDefaultModel();
        if (property.getExtends().isPresent() && !(superProperty = (io.openmanufacturing.sds.metamodel.Property)property.getExtends().get()).getCharacteristic().equals(property.getCharacteristic())) {
            Resource propertyResource = ResourceFactory.createResource();
            Resource superPropertyResource = this.getElementResource((IsDescribed)superProperty);
            ElementModel superPropertyElementModel = (ElementModel)superProperty.accept((AspectVisitor)this, (Object)context);
            model.add(superPropertyElementModel.getModel());
            property.getCharacteristic().ifPresent(characteristic -> {
                Resource characteristicResource = this.getElementResource((IsDescribed)characteristic);
                model.add(((ElementModel)characteristic.accept((AspectVisitor)this, (Object)property)).getModel());
                model.add(propertyResource, this.bamm.characteristic(), (RDFNode)characteristicResource);
                model.add(propertyResource, this.bamm._extends(), (RDFNode)superPropertyResource);
            });
            return new ElementModel(model, Optional.of(propertyResource));
        }
        if (!this.isLocalElement((IsDescribed)property)) {
            return new ElementModel(model, Optional.empty());
        }
        Resource resource = this.getElementResource((IsDescribed)property);
        model.add(resource, RDF.type, (RDFNode)this.bamm.Property());
        model.add(this.serializeDescriptions(resource, (IsDescribed)property));
        property.getExampleValue().ifPresent(exampleValue -> {
            ElementModel exampleValueElementModel = (ElementModel)exampleValue.accept((AspectVisitor)this, (Object)property);
            model.add(exampleValueElementModel.getModel());
            exampleValueElementModel.getFocusElement().ifPresent(exampleValueNode -> model.add(resource, this.bamm.exampleValue(), exampleValueNode));
        });
        property.getCharacteristic().ifPresent(characteristic -> {
            Resource characteristicResource = this.getElementResource((IsDescribed)characteristic);
            model.add(((ElementModel)characteristic.accept((AspectVisitor)this, (Object)property)).getModel());
            model.add(resource, this.bamm.characteristic(), (RDFNode)characteristicResource);
        });
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitOperation(Operation operation, Base context) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = this.getElementResource((IsDescribed)operation);
        model.add(resource, RDF.type, (RDFNode)this.bamm.Operation());
        model.add(this.serializeDescriptions(resource, (IsDescribed)operation));
        List inputProperties = operation.getInput().stream().map(this::getElementResource).collect(Collectors.toList());
        model.add(resource, this.bamm.input(), (RDFNode)model.createList(inputProperties.iterator()));
        operation.getInput().stream().map(property -> (ElementModel)property.accept((AspectVisitor)this, (Object)operation)).forEach(elementModel -> model.add(elementModel.getModel()));
        operation.getOutput().ifPresent(outputProperty -> model.add(resource, this.bamm.output(), (RDFNode)this.getElementResource((IsDescribed)outputProperty)));
        operation.getOutput().map(outputProperty -> (ElementModel)outputProperty.accept((AspectVisitor)this, (Object)operation)).ifPresent(elementModel -> model.add(elementModel.getModel()));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitEvent(Event event, Base context) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = this.getElementResource((IsDescribed)event);
        model.add(resource, RDF.type, (RDFNode)this.bamm.Event());
        model.add(this.serializeDescriptions(resource, (IsDescribed)event));
        model.add(this.serializeParameters(resource, (HasProperties)event));
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitCharacteristic(Characteristic characteristic, Base context) {
        if (!this.isLocalElement((IsDescribed)characteristic)) {
            return new ElementModel(ModelFactory.createDefaultModel(), characteristic.getAspectModelUrn().map(urn -> ResourceFactory.createResource((String)urn.toString())));
        }
        Model model = this.createCharacteristicsModel(characteristic);
        Resource resource = this.getElementResource((IsDescribed)characteristic);
        model.add(resource, RDF.type, (RDFNode)this.bamm.Characteristic());
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitComplexType(ComplexType complexType, Base context) {
        Model model = ModelFactory.createDefaultModel();
        if (this.hasVisited.contains(complexType)) {
            return new ElementModel(model, Optional.empty());
        }
        this.hasVisited.add(complexType);
        Resource resource = this.getElementResource((IsDescribed)complexType);
        if (complexType.getExtends().isPresent()) {
            ComplexType extendedComplexType = (ComplexType)complexType.getExtends().get();
            model.add(((ElementModel)extendedComplexType.accept((AspectVisitor)this, (Object)extendedComplexType)).getModel());
            Resource extendedTypeResource = ResourceFactory.createResource((String)extendedComplexType.getUrn());
            model.add(ResourceFactory.createStatement((Resource)resource, (Property)this.bamm._extends(), (RDFNode)extendedTypeResource));
        }
        model.add(this.serializeProperties(resource, (HasProperties)complexType));
        model.add(this.serializeDescriptions(resource, (IsDescribed)complexType));
        if (complexType.isAbstractEntity()) {
            model.add(ResourceFactory.createStatement((Resource)resource, (Property)RDF.type, (RDFNode)this.bamm.AbstractEntity()));
        } else {
            model.add(ResourceFactory.createStatement((Resource)resource, (Property)RDF.type, (RDFNode)this.bamm.Entity()));
        }
        return new ElementModel(model, Optional.of(resource));
    }

    public ElementModel visitAbstractEntity(AbstractEntity abstractEntity, Base context) {
        if (abstractEntity.getUrn().startsWith(this.bamme.getNamespace())) {
            return new ElementModel(ModelFactory.createDefaultModel(), abstractEntity.getAspectModelUrn().map(urn -> ResourceFactory.createResource((String)urn.toString())));
        }
        Model model = this.visitComplexType((ComplexType)abstractEntity, context).getModel();
        abstractEntity.getExtendingElements().forEach(complexType -> model.add(((ElementModel)complexType.accept((AspectVisitor)this, complexType)).getModel()));
        return new ElementModel(model, Optional.empty());
    }

    public ElementModel visitUnit(Unit unit, Base context) {
        Model model = ModelFactory.createDefaultModel();
        String unitUrn = unit.getAspectModelUrn().map(AspectModelUrn::toString).orElseThrow(() -> new InvalidModelException("Invalid unit without URN."));
        if (!ResourceFactory.createResource((String)unitUrn).getNameSpace().equals(this.unitNamespace.getNamespace())) {
            Resource unitResource = this.getElementResource((IsDescribed)unit);
            model.add(unitResource, RDF.type, (RDFNode)this.bamm.Unit());
            unit.getQuantityKinds().forEach(quantityKind -> model.add(unitResource, this.bamm.quantityKind(), (RDFNode)this.unitNamespace.resource(quantityKind.getName())));
            model.add(this.serializeDescriptions(unitResource, (IsDescribed)unit));
            unit.getSymbol().ifPresent(symbol -> model.add(unitResource, this.bamm.symbol(), (RDFNode)this.serializePlainString((String)symbol)));
            return new ElementModel(model, Optional.of(unitResource));
        }
        return new ElementModel(model, Optional.empty());
    }

    public ElementModel visitQuantityKind(QuantityKind quantityKind, Base context) {
        return new ElementModel(ModelFactory.createDefaultModel(), Optional.empty());
    }

    @Override
    public Model apply(Aspect aspect) {
        return this.visitAspect(aspect, null).getModel();
    }

    public static final class ElementModel {
        private final Model model;
        private final Optional<RDFNode> focusElement;

        public ElementModel(Model model, Optional<RDFNode> focusElement) {
            this.model = model;
            this.focusElement = focusElement;
        }

        public Model getModel() {
            return this.model;
        }

        public Optional<RDFNode> getFocusElement() {
            return this.focusElement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementModel)) {
                return false;
            }
            ElementModel other = (ElementModel)o;
            Model this$model = this.getModel();
            Model other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            Optional<RDFNode> this$focusElement = this.getFocusElement();
            Optional<RDFNode> other$focusElement = other.getFocusElement();
            return !(this$focusElement == null ? other$focusElement != null : !((Object)this$focusElement).equals(other$focusElement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Model $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            Optional<RDFNode> $focusElement = this.getFocusElement();
            result = result * 59 + ($focusElement == null ? 43 : ((Object)$focusElement).hashCode());
            return result;
        }

        public String toString() {
            return "RdfModelCreatorVisitor.ElementModel(model=" + this.getModel() + ", focusElement=" + this.getFocusElement() + ")";
        }
    }
}

