/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.serializer;

import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.resolver.exceptions.InvalidModelException;
import io.openmanufacturing.sds.aspectmodel.resolver.services.DataType;
import io.openmanufacturing.sds.aspectmodel.resolver.services.ExtendedXsdDataType;
import io.openmanufacturing.sds.aspectmodel.urn.AspectModelUrn;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMM;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMMC;
import io.openmanufacturing.sds.aspectmodel.vocabulary.Namespace;
import io.openmanufacturing.sds.aspectmodel.vocabulary.UNIT;
import io.openmanufacturing.sds.metamodel.Aspect;
import io.openmanufacturing.sds.metamodel.Base;
import io.openmanufacturing.sds.metamodel.Characteristic;
import io.openmanufacturing.sds.metamodel.Code;
import io.openmanufacturing.sds.metamodel.Collection;
import io.openmanufacturing.sds.metamodel.Constraint;
import io.openmanufacturing.sds.metamodel.Duration;
import io.openmanufacturing.sds.metamodel.Either;
import io.openmanufacturing.sds.metamodel.EncodingConstraint;
import io.openmanufacturing.sds.metamodel.Entity;
import io.openmanufacturing.sds.metamodel.Enumeration;
import io.openmanufacturing.sds.metamodel.FixedPointConstraint;
import io.openmanufacturing.sds.metamodel.HasProperties;
import io.openmanufacturing.sds.metamodel.IsDescribed;
import io.openmanufacturing.sds.metamodel.LanguageConstraint;
import io.openmanufacturing.sds.metamodel.LengthConstraint;
import io.openmanufacturing.sds.metamodel.LocaleConstraint;
import io.openmanufacturing.sds.metamodel.Measurement;
import io.openmanufacturing.sds.metamodel.Operation;
import io.openmanufacturing.sds.metamodel.Quantifiable;
import io.openmanufacturing.sds.metamodel.QuantityKind;
import io.openmanufacturing.sds.metamodel.RangeConstraint;
import io.openmanufacturing.sds.metamodel.RegularExpressionConstraint;
import io.openmanufacturing.sds.metamodel.Set;
import io.openmanufacturing.sds.metamodel.SingleEntity;
import io.openmanufacturing.sds.metamodel.SortedSet;
import io.openmanufacturing.sds.metamodel.State;
import io.openmanufacturing.sds.metamodel.StructuredValue;
import io.openmanufacturing.sds.metamodel.TimeSeries;
import io.openmanufacturing.sds.metamodel.Trait;
import io.openmanufacturing.sds.metamodel.Type;
import io.openmanufacturing.sds.metamodel.Unit;
import io.openmanufacturing.sds.metamodel.visitor.AspectVisitor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class RdfModelCreatorVisitor
implements AspectVisitor<Model, Base>,
Function<Aspect, Model> {
    private final KnownVersion metaModelVersion;
    private final BAMM bamm;
    private final BAMMC bammc;
    private final UNIT unitNamespace;
    private final Namespace namespace;
    private final Map<IsDescribed, Resource> anonymousResources = new HashMap<IsDescribed, Resource>();
    private final List<Resource> resourceList = new LinkedList<Resource>();

    public RdfModelCreatorVisitor(KnownVersion metaModelVersion, Namespace namespace) {
        this.metaModelVersion = metaModelVersion;
        this.bamm = new BAMM(metaModelVersion);
        this.bammc = new BAMMC(metaModelVersion);
        this.unitNamespace = new UNIT(metaModelVersion, this.bamm);
        this.namespace = namespace;
    }

    private Literal serializeLocalizedString(Map.Entry<Locale, String> localizedString) {
        Locale languageTag = localizedString.getKey();
        String value = localizedString.getValue();
        return ResourceFactory.createLangLiteral((String)value, (String)languageTag.toLanguageTag());
    }

    private Map.Entry<Resource, Model> serializeEntityInstance(Entity entity, Map<String, Object> entityInstance) {
        Model model = ModelFactory.createDefaultModel();
        String nameKey = this.bamm.name().toString();
        Resource resource = this.namespace.resource(entityInstance.get(nameKey).toString());
        model.add(resource, RDF.type, (RDFNode)ResourceFactory.createResource((String)entity.getUrn()));
        entity.getProperties().stream().map(property -> {
            Model propertyModel = ModelFactory.createDefaultModel();
            property.getDataType().ifPresent(propertyType -> {
                String instanceKey = property.getName();
                Object instanceValue = entityInstance.get(instanceKey);
                Property instanceProperty = this.namespace.property(instanceKey);
                if (propertyType.isComplex()) {
                    Map.Entry<Resource, Model> nestedInstance = this.serializeEntityInstance((Entity)propertyType, (Map)instanceValue);
                    propertyModel.add(nestedInstance.getValue());
                    propertyModel.add(resource, instanceProperty, (RDFNode)nestedInstance.getKey());
                } else if (instanceValue != null) {
                    propertyModel.add(resource, instanceProperty, (RDFNode)this.serializeTypedValue(instanceValue, (Type)propertyType));
                }
            });
            return propertyModel;
        }).forEach(arg_0 -> ((Model)model).add(arg_0));
        return new AbstractMap.SimpleEntry<Resource, Model>(resource, model);
    }

    private Literal serializePlainString(String string) {
        return ResourceFactory.createPlainLiteral((String)string);
    }

    private Literal serializeTypedValue(String value, RDFDatatype rdfDatatype) {
        return ResourceFactory.createTypedLiteral((String)value, (RDFDatatype)rdfDatatype);
    }

    private Literal serializeTypedValue(Object value, Type type) {
        return this.serializeTypedValue(value, Optional.of(type));
    }

    private Literal serializeTypedValue(Object value, Optional<Type> optionalType) {
        Optional targetType = optionalType.flatMap(type -> DataType.getAllSupportedTypesForMetaModelVersion((KnownVersion)this.metaModelVersion).stream().filter(dataType -> dataType.getURI().equals(type.getUrn())).findAny());
        if (targetType.isEmpty() || optionalType.map(type -> type.getUrn().equals(XSD.xstring.getURI())).orElse(false).booleanValue()) {
            return ResourceFactory.createStringLiteral((String)value.toString());
        }
        return ResourceFactory.createTypedLiteral((String)((RDFDatatype)targetType.get()).unparse(value), (RDFDatatype)((RDFDatatype)targetType.get()));
    }

    private Literal serializeBoolean(Boolean value) {
        return ResourceFactory.createTypedLiteral((Object)value);
    }

    private boolean isLocalElement(IsDescribed element) {
        return element.getAspectModelUrn().isEmpty() || ((AspectModelUrn)element.getAspectModelUrn().get()).getUrnPrefix().equals(this.namespace.getNamespace());
    }

    private Type getEffectiveDatatype(Characteristic characteristic) {
        Optional type = characteristic.getDataType();
        return type.orElseGet(() -> this.getEffectiveDatatype(((Trait)characteristic).getBaseCharacteristic()));
    }

    private Resource getElementResource(IsDescribed element) {
        if (element.getAspectModelUrn().isEmpty()) {
            return this.anonymousResources.computeIfAbsent(element, key -> ResourceFactory.createResource());
        }
        return ResourceFactory.createResource((String)((AspectModelUrn)element.getAspectModelUrn().get()).toString());
    }

    private Model serializeDescriptions(Resource elementResource, IsDescribed element) {
        Model model = ModelFactory.createDefaultModel();
        element.getSee().forEach(seeValue -> model.add(elementResource, this.bamm.see(), (RDFNode)ResourceFactory.createResource((String)seeValue)));
        element.getPreferredNames().entrySet().stream().map(this::serializeLocalizedString).forEach(preferredName -> model.add(elementResource, this.bamm.preferredName(), (RDFNode)preferredName));
        element.getDescriptions().entrySet().stream().map(this::serializeLocalizedString).forEach(description -> model.add(elementResource, this.bamm.description(), (RDFNode)description));
        return model;
    }

    private Model serializeProperties(Resource elementResource, HasProperties element) {
        Model model = ModelFactory.createDefaultModel();
        ArrayList propertiesList = new ArrayList();
        if (this.resourceList.contains(elementResource)) {
            return model;
        }
        this.resourceList.add(elementResource);
        element.getProperties().stream().filter(this::isLocalElement).map(property -> {
            Model propertyModel = ModelFactory.createDefaultModel();
            Resource propertyResource = this.getElementResource((IsDescribed)property);
            propertyModel.add((Model)property.accept((AspectVisitor)this, (Object)element));
            if (property.isOptional() || property.isNotInPayload() || !property.getName().equals(property.getPayloadName())) {
                Resource anonymousPropertyNode = this.serializeAnonymousPropertyNodes((io.openmanufacturing.sds.metamodel.Property)property, propertyModel, propertyResource);
                propertiesList.add(anonymousPropertyNode);
                return propertyModel;
            }
            propertiesList.add(propertyResource);
            return propertyModel;
        }).forEach(arg_0 -> ((Model)model).add(arg_0));
        model.add(elementResource, this.bamm.properties(), (RDFNode)model.createList(propertiesList.iterator()));
        return model;
    }

    private Resource serializeAnonymousPropertyNodes(io.openmanufacturing.sds.metamodel.Property property, Model propertyModel, Resource propertyResource) {
        Resource anonymousPropertyNode = ResourceFactory.createResource();
        if (property.isOptional()) {
            propertyModel.add(anonymousPropertyNode, this.bamm.property(), (RDFNode)propertyResource);
            propertyModel.add(anonymousPropertyNode, this.bamm.optional(), (RDFNode)this.serializeBoolean(true));
        }
        if (property.isNotInPayload()) {
            propertyModel.add(anonymousPropertyNode, this.bamm.property(), (RDFNode)propertyResource);
            propertyModel.add(anonymousPropertyNode, this.bamm.notInPayload(), (RDFNode)this.serializeBoolean(true));
        }
        if (!property.getName().equals(property.getPayloadName())) {
            propertyModel.add(anonymousPropertyNode, this.bamm.property(), (RDFNode)propertyResource);
            propertyModel.add(anonymousPropertyNode, this.bamm.payloadName(), (RDFNode)this.serializePlainString(property.getPayloadName()));
        }
        return anonymousPropertyNode;
    }

    private Model createCharacteristicsModel(Characteristic characteristic) {
        Model model = ModelFactory.createDefaultModel();
        if (!this.isLocalElement((IsDescribed)characteristic)) {
            return model;
        }
        Resource resource = this.getElementResource((IsDescribed)characteristic);
        if (!characteristic.hasSyntheticName()) {
            model.add(resource, this.bamm.name(), (RDFNode)this.serializePlainString(characteristic.getName()));
        }
        characteristic.getDataType().ifPresent(type -> {
            model.add(resource, this.bamm.dataType(), (RDFNode)ResourceFactory.createResource((String)type.getUrn()));
            if (type.isComplex()) {
                model.add((Model)type.accept((AspectVisitor)this, (Object)characteristic));
            }
        });
        model.add(this.serializeDescriptions(resource, (IsDescribed)characteristic));
        return model;
    }

    public Model visitBase(Base base, Base context) {
        return ModelFactory.createDefaultModel();
    }

    public Model visitCollection(Collection collection, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)collection);
        Resource resource = this.getElementResource((IsDescribed)collection);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Collection());
        return model;
    }

    public Model visitList(io.openmanufacturing.sds.metamodel.List list, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)list);
        Resource resource = this.getElementResource((IsDescribed)list);
        model.add(resource, RDF.type, (RDFNode)this.bammc.List());
        return model;
    }

    public Model visitSet(Set set, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)set);
        Resource resource = this.getElementResource((IsDescribed)set);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Set());
        return model;
    }

    public Model visitSortedSet(SortedSet sortedSet, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)sortedSet);
        Resource resource = this.getElementResource((IsDescribed)sortedSet);
        model.add(resource, RDF.type, (RDFNode)this.bammc.SortedSet());
        return model;
    }

    public Model visitTimeSeries(TimeSeries timeSeries, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)timeSeries);
        Resource resource = this.getElementResource((IsDescribed)timeSeries);
        model.add(resource, RDF.type, (RDFNode)this.bammc.TimeSeries());
        return model;
    }

    public Model visitConstraint(Constraint constraint, Base context) {
        Model model = ModelFactory.createDefaultModel();
        if (!this.isLocalElement((IsDescribed)constraint)) {
            return model;
        }
        Resource resource = this.getElementResource((IsDescribed)constraint);
        if (!constraint.hasSyntheticName()) {
            model.add(resource, this.bamm.name(), (RDFNode)this.serializePlainString(constraint.getName()));
        }
        model.add(this.serializeDescriptions(resource, (IsDescribed)constraint));
        return model;
    }

    public Model visitEncodingConstraint(EncodingConstraint encodingConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)encodingConstraint, null);
        Resource resource = this.getElementResource((IsDescribed)encodingConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.EncodingConstraint());
        model.add(resource, this.bamm.value(), (RDFNode)this.serializePlainString(encodingConstraint.getValue().name()));
        return model;
    }

    public Model visitLanguageConstraint(LanguageConstraint languageConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)languageConstraint, null);
        Resource resource = this.getElementResource((IsDescribed)languageConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.LanguageConstraint());
        model.add(resource, this.bammc.languageCode(), (RDFNode)this.serializePlainString(languageConstraint.getLanguageCode().toLanguageTag()));
        return model;
    }

    public Model visitLocaleConstraint(LocaleConstraint localeConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)localeConstraint, null);
        Resource resource = this.getElementResource((IsDescribed)localeConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.LocaleConstraint());
        model.add(resource, this.bammc.localeCode(), (RDFNode)this.serializePlainString(localeConstraint.getLocaleCode().toLanguageTag()));
        return model;
    }

    public Model visitLengthConstraint(LengthConstraint lengthConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)lengthConstraint, null);
        Resource resource = this.getElementResource((IsDescribed)lengthConstraint);
        lengthConstraint.getMinValue().stream().map(minValue -> ResourceFactory.createStatement((Resource)resource, (Property)this.bammc.minValue(), (RDFNode)this.serializeTypedValue(minValue.toString(), (RDFDatatype)ExtendedXsdDataType.NON_NEGATIVE_INTEGER))).forEach(arg_0 -> ((Model)model).add(arg_0));
        lengthConstraint.getMinValue().stream().map(maxValue -> ResourceFactory.createStatement((Resource)resource, (Property)this.bammc.maxValue(), (RDFNode)this.serializeTypedValue(maxValue.toString(), (RDFDatatype)ExtendedXsdDataType.NON_NEGATIVE_INTEGER))).forEach(arg_0 -> ((Model)model).add(arg_0));
        model.add(resource, RDF.type, (RDFNode)this.bammc.LengthConstraint());
        return model;
    }

    public Model visitRangeConstraint(RangeConstraint rangeConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)rangeConstraint, null);
        Resource resource = this.getElementResource((IsDescribed)rangeConstraint);
        Trait parentTrait = (Trait)context;
        Type type = this.getEffectiveDatatype((Characteristic)parentTrait);
        model.add(resource, RDF.type, (RDFNode)this.bammc.RangeConstraint());
        rangeConstraint.getMinValue().stream().map(minValue -> this.serializeTypedValue(minValue, type)).map(literal -> ResourceFactory.createStatement((Resource)resource, (Property)this.bammc.minValue(), (RDFNode)literal)).forEach(arg_0 -> ((Model)model).add(arg_0));
        rangeConstraint.getMinValue().stream().map(maxValue -> this.serializeTypedValue(maxValue, type)).map(literal -> ResourceFactory.createStatement((Resource)resource, (Property)this.bammc.maxValue(), (RDFNode)literal)).forEach(arg_0 -> ((Model)model).add(arg_0));
        model.add(resource, this.bammc.lowerBoundDefinition(), (RDFNode)this.bammc.resource(rangeConstraint.getLowerBoundDefinition().toString().replace(" ", "_").toUpperCase()));
        model.add(resource, this.bammc.upperBoundDefinition(), (RDFNode)this.bammc.resource(rangeConstraint.getUpperBoundDefinition().toString().replace(" ", "_").toUpperCase()));
        return model;
    }

    public Model visitRegularExpressionConstraint(RegularExpressionConstraint regularExpressionConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)regularExpressionConstraint, null);
        Resource resource = this.getElementResource((IsDescribed)regularExpressionConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.RegularExpressionConstraint());
        model.add(resource, this.bamm.value(), (RDFNode)this.serializePlainString(regularExpressionConstraint.getValue()));
        return model;
    }

    public Model visitFixedPointConstraint(FixedPointConstraint fixedPointConstraint, Base context) {
        Model model = this.visitConstraint((Constraint)fixedPointConstraint, null);
        Resource resource = this.getElementResource((IsDescribed)fixedPointConstraint);
        model.add(resource, RDF.type, (RDFNode)this.bammc.FixedPointConstraint());
        model.add(resource, this.bammc.integer(), (RDFNode)this.serializeTypedValue(fixedPointConstraint.getInteger().toString(), (RDFDatatype)ExtendedXsdDataType.NON_NEGATIVE_INTEGER));
        model.add(resource, this.bammc.scale(), (RDFNode)this.serializeTypedValue(fixedPointConstraint.getScale().toString(), (RDFDatatype)ExtendedXsdDataType.NON_NEGATIVE_INTEGER));
        return model;
    }

    public Model visitCode(Code code, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)code);
        Resource resource = this.getElementResource((IsDescribed)code);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Code());
        return model;
    }

    public Model visitDuration(Duration duration, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)duration);
        Resource resource = this.getElementResource((IsDescribed)duration);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Duration());
        this.getUnitStatement((Quantifiable)duration, resource).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        duration.getUnit().map(unit -> (Model)unit.accept((AspectVisitor)this, (Object)duration)).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        return model;
    }

    public Model visitEither(Either either, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)either);
        Resource resource = this.getElementResource((IsDescribed)either);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Either());
        model.add((Model)either.getLeft().accept((AspectVisitor)this, (Object)either));
        model.add((Model)either.getRight().accept((AspectVisitor)this, (Object)either));
        return model;
    }

    public Model visitEnumeration(Enumeration enumeration, Base context) {
        Type type;
        Model model = this.createCharacteristicsModel((Characteristic)enumeration);
        Resource resource = this.getElementResource((IsDescribed)enumeration);
        if (!(enumeration instanceof State)) {
            model.add(resource, RDF.type, (RDFNode)this.bammc.Enumeration());
        }
        if ((type = this.getEffectiveDatatype((Characteristic)enumeration)).isScalar()) {
            model.add(resource, this.bammc.values(), (RDFNode)model.createList(enumeration.getValues().stream().map(value -> this.serializeTypedValue(value, type)).iterator()));
            return model;
        }
        Entity entity = (Entity)type;
        Map<Resource, Model> instances = enumeration.getValues().stream().map(instanceValue -> this.serializeEntityInstance(entity, (Map)instanceValue)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        instances.values().forEach(arg_0 -> ((Model)model).add(arg_0));
        model.add(resource, this.bammc.values(), (RDFNode)model.createList(instances.keySet().stream().iterator()));
        return model;
    }

    public Model visitState(State state, Base context) {
        Model model = this.visitEnumeration((Enumeration)state, null);
        Resource resource = this.getElementResource((IsDescribed)state);
        model.add(resource, RDF.type, (RDFNode)this.bammc.State());
        model.add(resource, this.bammc.defaultValue(), (RDFNode)this.serializeTypedValue(state.getDefaultValue(), state.getDataType()));
        return model;
    }

    private Optional<Statement> getUnitStatement(Quantifiable elementWithUnit, Resource targetResource) {
        return elementWithUnit.getUnit().flatMap(IsDescribed::getAspectModelUrn).map(AspectModelUrn::toString).map(unitUrn -> ResourceFactory.createStatement((Resource)targetResource, (Property)this.bammc.unit(), (RDFNode)ResourceFactory.createResource((String)unitUrn)));
    }

    public Model visitMeasurement(Measurement measurement, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)measurement);
        Resource resource = this.getElementResource((IsDescribed)measurement);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Measurement());
        this.getUnitStatement((Quantifiable)measurement, resource).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        measurement.getUnit().map(unit -> (Model)unit.accept((AspectVisitor)this, (Object)measurement)).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        return model;
    }

    public Model visitQuantifiable(Quantifiable quantifiable, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)quantifiable);
        Resource resource = this.getElementResource((IsDescribed)quantifiable);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Quantifiable());
        this.getUnitStatement(quantifiable, resource).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        quantifiable.getUnit().map(unit -> (Model)unit.accept((AspectVisitor)this, (Object)quantifiable)).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        return model;
    }

    public Model visitSingleEntity(SingleEntity singleEntity, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)singleEntity);
        Resource resource = this.getElementResource((IsDescribed)singleEntity);
        model.add(resource, RDF.type, (RDFNode)this.bammc.SingleEntity());
        return model;
    }

    public Model visitStructuredValue(StructuredValue structuredValue, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)structuredValue);
        Resource resource = this.getElementResource((IsDescribed)structuredValue);
        model.add(resource, RDF.type, (RDFNode)this.bammc.StructuredValue());
        model.add(resource, this.bammc.deconstructionRule(), (RDFNode)this.serializePlainString(structuredValue.getDeconstructionRule()));
        RDFList elementsList = model.createList(structuredValue.getElements().stream().map(element -> element instanceof String ? this.serializePlainString((String)element) : this.getElementResource((IsDescribed)((io.openmanufacturing.sds.metamodel.Property)element))).iterator());
        model.add(resource, this.bammc.elements(), (RDFNode)elementsList);
        structuredValue.getElements().stream().filter(io.openmanufacturing.sds.metamodel.Property.class::isInstance).map(io.openmanufacturing.sds.metamodel.Property.class::cast).map(property -> (Model)property.accept((AspectVisitor)this, (Object)structuredValue)).forEach(arg_0 -> ((Model)model).add(arg_0));
        return model;
    }

    public Model visitTrait(Trait trait, Base context) {
        Model model = this.createCharacteristicsModel((Characteristic)trait);
        Resource resource = this.getElementResource((IsDescribed)trait);
        model.add(resource, RDF.type, (RDFNode)this.bammc.Trait());
        Resource baseCharacteristicResource = this.getElementResource((IsDescribed)trait.getBaseCharacteristic());
        model.add(resource, this.bammc.baseCharacteristic(), (RDFNode)baseCharacteristicResource);
        model.add((Model)trait.getBaseCharacteristic().accept((AspectVisitor)this, (Object)trait));
        trait.getConstraints().forEach(constraint -> {
            Resource constraintResource = this.getElementResource((IsDescribed)constraint);
            model.add(resource, this.bammc.constraint(), (RDFNode)constraintResource);
            model.add((Model)constraint.accept((AspectVisitor)this, (Object)trait));
        });
        return model;
    }

    public Model visitAspect(Aspect aspect, Base context) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = this.getElementResource((IsDescribed)aspect);
        model.add(resource, RDF.type, (RDFNode)this.bamm.Aspect());
        if (!aspect.hasSyntheticName()) {
            model.add(resource, this.bamm.name(), (RDFNode)this.serializePlainString(aspect.getName()));
        }
        model.add(this.serializeDescriptions(resource, (IsDescribed)aspect));
        model.add(this.serializeProperties(resource, (HasProperties)aspect));
        model.add(resource, this.bamm.operations(), (RDFNode)model.createList(aspect.getOperations().stream().map(this::getElementResource).iterator()));
        aspect.getOperations().stream().map(operation -> (Model)operation.accept((AspectVisitor)this, (Object)aspect)).forEach(arg_0 -> ((Model)model).add(arg_0));
        return model;
    }

    public Model visitProperty(io.openmanufacturing.sds.metamodel.Property property, Base context) {
        Model model = ModelFactory.createDefaultModel();
        if (!this.isLocalElement((IsDescribed)property)) {
            return model;
        }
        Resource resource = this.getElementResource((IsDescribed)property);
        if (!property.hasSyntheticName()) {
            model.add(resource, this.bamm.name(), (RDFNode)this.serializePlainString(property.getName()));
        }
        model.add(property.getRefines().map(urn -> ResourceFactory.createStatement((Resource)resource, (Property)this.bamm.refines(), (RDFNode)ResourceFactory.createResource((String)urn.toString()))).orElse(ResourceFactory.createStatement((Resource)resource, (Property)RDF.type, (RDFNode)this.bamm.Property())));
        model.add(this.serializeDescriptions(resource, (IsDescribed)property));
        if (property.getExampleValue().isPresent()) {
            model.add(resource, this.bamm.exampleValue(), (RDFNode)this.serializeTypedValue(property.getExampleValue().get(), property.getDataType()));
        }
        Characteristic characteristic = property.getCharacteristic();
        Resource characteristicResource = this.getElementResource((IsDescribed)characteristic);
        model.add((Model)characteristic.accept((AspectVisitor)this, (Object)property));
        model.add(resource, this.bamm.characteristic(), (RDFNode)characteristicResource);
        return model;
    }

    public Model visitOperation(Operation operation, Base context) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = this.getElementResource((IsDescribed)operation);
        model.add(resource, RDF.type, (RDFNode)this.bamm.Operation());
        if (!operation.hasSyntheticName()) {
            model.add(resource, this.bamm.name(), (RDFNode)this.serializePlainString(operation.getName()));
        }
        model.add(this.serializeDescriptions(resource, (IsDescribed)operation));
        List inputProperties = operation.getInput().stream().map(this::getElementResource).collect(Collectors.toList());
        model.add(resource, this.bamm.input(), (RDFNode)model.createList(inputProperties.iterator()));
        operation.getInput().stream().map(property -> (Model)property.accept((AspectVisitor)this, (Object)operation)).forEach(arg_0 -> ((Model)model).add(arg_0));
        operation.getOutput().ifPresent(outputProperty -> model.add(resource, this.bamm.output(), (RDFNode)this.getElementResource((IsDescribed)outputProperty)));
        operation.getOutput().map(outputProperty -> (Model)outputProperty.accept((AspectVisitor)this, (Object)operation)).ifPresent(arg_0 -> ((Model)model).add(arg_0));
        return model;
    }

    public Model visitCharacteristic(Characteristic characteristic, Base context) {
        if (!this.isLocalElement((IsDescribed)characteristic)) {
            return ModelFactory.createDefaultModel();
        }
        Model model = this.createCharacteristicsModel(characteristic);
        Resource resource = this.getElementResource((IsDescribed)characteristic);
        model.add(resource, RDF.type, (RDFNode)this.bamm.Characteristic());
        return model;
    }

    public Model visitEntity(Entity entity, Base context) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = this.getElementResource((IsDescribed)entity);
        if (!entity.hasSyntheticName()) {
            model.add(resource, this.bamm.name(), (RDFNode)this.serializePlainString(entity.getName()));
        }
        model.add(entity.getRefines().map(urn -> ResourceFactory.createStatement((Resource)resource, (Property)this.bamm.refines(), (RDFNode)ResourceFactory.createResource((String)urn.toString()))).orElse(ResourceFactory.createStatement((Resource)resource, (Property)RDF.type, (RDFNode)this.bamm.Entity())));
        model.add(this.serializeProperties(resource, (HasProperties)entity));
        model.add(this.serializeDescriptions(resource, (IsDescribed)entity));
        return model;
    }

    public Model visitUnit(Unit unit, Base context) {
        Model model = ModelFactory.createDefaultModel();
        String unitUrn = unit.getAspectModelUrn().map(AspectModelUrn::toString).orElseThrow(() -> new InvalidModelException("Invalid unit without URN."));
        if (!ResourceFactory.createResource((String)unitUrn).getNameSpace().equals(this.unitNamespace.getNamespace())) {
            Resource unitResource = this.getElementResource((IsDescribed)unit);
            model.add(unitResource, RDF.type, (RDFNode)this.unitNamespace.Unit());
            if (!unit.hasSyntheticName()) {
                model.add(unitResource, this.bamm.name(), (RDFNode)this.serializePlainString(unit.getName()));
            }
            unit.getQuantityKinds().forEach(quantityKind -> model.add(unitResource, this.unitNamespace.quantityKind(), (RDFNode)this.unitNamespace.resource(quantityKind.getName())));
            model.add(this.serializeDescriptions(unitResource, (IsDescribed)unit));
        }
        return model;
    }

    public Model visitQuantityKind(QuantityKind quantityKind, Base context) {
        return ModelFactory.createDefaultModel();
    }

    @Override
    public Model apply(Aspect aspect) {
        return this.visitAspect(aspect, null);
    }
}

