/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class Either<L, R> {
    private final Optional<L> left;
    private final Optional<R> right;

    @JsonCreator
    public Either(@JsonProperty(value="left") Optional<L> left, @JsonProperty(value="right") Optional<R> right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> left(L leftValue) {
        return new Either(Optional.of(leftValue), Optional.empty());
    }

    public static <L, R> Either<L, R> right(R rightValue) {
        return new Either(Optional.empty(), Optional.of(rightValue));
    }

    public Optional<L> getLeft() {
        return this.left;
    }

    public Optional<R> getRight() {
        return this.right;
    }
}

