/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLGregorianCalendarDeserializer
extends StdScalarDeserializer<XMLGregorianCalendar> {
    private static final long serialVersionUID = 8911315963918963886L;
    private static final Logger LOG = LoggerFactory.getLogger(XMLGregorianCalendarDeserializer.class);
    public static final XMLGregorianCalendarDeserializer INSTANCE = new XMLGregorianCalendarDeserializer();
    private final transient DatatypeFactory datatypeFactory;

    private XMLGregorianCalendarDeserializer() {
        super(XMLGregorianCalendar.class);
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException exception) {
            LOG.error("Could not instantiate DatatypeFactory", (Throwable)exception);
            throw new RuntimeJsonMappingException(exception.getMessage());
        }
    }

    public XMLGregorianCalendar deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.currentTokenId() == 6) {
            return this.datatypeFactory.newXMLGregorianCalendar(parser.getText().trim());
        }
        return (XMLGregorianCalendar)context.handleUnexpectedToken(XMLGregorianCalendar.class, parser);
    }
}

