/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.openmanufacturing.sds.aspectmodel.resolver.services.ExtendedXsdDataType;
import java.io.IOException;
import java.util.Optional;

public class HexBinaryDeserializer
extends StdDeserializer<byte[]> {
    private static final long serialVersionUID = 8408540591452927413L;
    public static final HexBinaryDeserializer INSTANCE = new HexBinaryDeserializer();

    private HexBinaryDeserializer() {
        super(byte[].class);
    }

    public byte[] deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Optional value;
        if (parser.currentTokenId() == 6 && (value = ExtendedXsdDataType.HEX_BINARY.parseTyped(parser.getText())).isPresent()) {
            return (byte[])value.get();
        }
        return (byte[])context.handleUnexpectedToken(byte[].class, parser);
    }
}

