/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.openmanufacturing.sds.aspectmodel.resolver.services.ExtendedXsdDataType;
import java.io.IOException;
import java.util.Optional;

public class Base64BinaryDeserializer
extends StdDeserializer<byte[]> {
    private static final long serialVersionUID = 6637893688907290484L;
    public static final Base64BinaryDeserializer INSTANCE = new Base64BinaryDeserializer();

    private Base64BinaryDeserializer() {
        super(byte[].class);
    }

    public byte[] deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Optional value;
        if (parser.getCurrentTokenId() == 6 && (value = ExtendedXsdDataType.BASE64_BINARY.parseTyped(parser.getText())).isPresent()) {
            return (byte[])value.get();
        }
        return (byte[])context.handleUnexpectedToken(byte[].class, parser);
    }
}

