/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shade.client.dataset.namespace.resolver;

import io.openlineage.spark.shade.client.OpenLineageClientException;
import io.openlineage.spark.shade.client.dataset.DatasetConfig;
import io.openlineage.spark.shade.client.dataset.namespace.resolver.DatasetNamespaceResolver;
import io.openlineage.spark.shade.client.dataset.namespace.resolver.DatasetNamespaceResolverBuilder;
import io.openlineage.spark.shade.client.dataset.namespace.resolver.DatasetNamespaceResolverConfig;
import io.openlineage.spark.shade.client.dataset.namespace.resolver.HostListNamespaceResolverBuilder;
import io.openlineage.spark.shade.client.dataset.namespace.resolver.PatternMatchingGroupNamespaceResolverBuilder;
import io.openlineage.spark.shade.client.dataset.namespace.resolver.PatternNamespaceResolverBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DatasetNamespaceResolverLoader {
    private static List<DatasetNamespaceResolverBuilder> builders = Arrays.asList(new HostListNamespaceResolverBuilder(), new PatternNamespaceResolverBuilder(), new PatternMatchingGroupNamespaceResolverBuilder());

    public static Class<? extends DatasetNamespaceResolverConfig> loadDatasetNamespaceResolverConfigByType(String type) {
        return DatasetNamespaceResolverLoader.getDatasetNamespaceResolverBuilder(b -> b.getType().equalsIgnoreCase(type)).map(b -> b.getConfig().getClass()).orElseThrow(() -> new OpenLineageClientException("Invalid dataset namespace resolver type provided: " + type));
    }

    public static String loadDatasetNamespaceResolverTypeByConfigClass(Class datasetNamespaceResolverConfigClass) {
        return DatasetNamespaceResolverLoader.getDatasetNamespaceResolverBuilder(b -> b.getConfig().getClass().equals(datasetNamespaceResolverConfigClass)).map(b -> b.getType()).orElseThrow(() -> new OpenLineageClientException("Invalid dataset namespace resolver class provided: " + datasetNamespaceResolverConfigClass.getCanonicalName()));
    }

    public static List<DatasetNamespaceResolver> loadDatasetNamespaceResolvers(DatasetConfig datasetConfig) {
        if (datasetConfig.getNamespaceResolvers() == null) {
            return Collections.emptyList();
        }
        return datasetConfig.getNamespaceResolvers().keySet().stream().map(name -> {
            DatasetNamespaceResolverConfig config = datasetConfig.getNamespaceResolvers().get(name);
            return DatasetNamespaceResolverLoader.getDatasetNamespaceResolverBuilder(b -> b.getConfig().getClass().equals(config.getClass())).map(b -> b.build((String)name, config)).orElseThrow(() -> new OpenLineageClientException("Dataset namespace resolver shouldn't be called for invalid or null config"));
        }).collect(Collectors.toList());
    }

    private static Optional<DatasetNamespaceResolverBuilder> getDatasetNamespaceResolverBuilder(Predicate<DatasetNamespaceResolverBuilder> predicate) {
        return Stream.concat(builders.stream(), StreamSupport.stream(DatasetNamespaceResolverServiceLoader.load().spliterator(), false)).filter(predicate).findFirst();
    }

    static class DatasetNamespaceResolverServiceLoader {
        DatasetNamespaceResolverServiceLoader() {
        }

        static ServiceLoader<DatasetNamespaceResolverBuilder> load() {
            return ServiceLoader.load(DatasetNamespaceResolverBuilder.class);
        }
    }
}

