/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils;

import io.openlineage.client.utils.DatasetIdentifier;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;

public class DatasetIdentifierUtils {
    private static final String DEFAULT_SCHEME = "file";
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = "/";
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Pattern HAS_DRIVE_LETTER_SPECIFIER = Pattern.compile("^/?[a-zA-Z]:");

    public static DatasetIdentifier fromURI(URI uri) {
        return DatasetIdentifierUtils.fromURI(uri, DEFAULT_SCHEME);
    }

    public static DatasetIdentifier fromURI(URI uri, String defaultScheme) {
        if (DatasetIdentifierUtils.isAbsoluteAndSchemeAuthorityNull(uri)) {
            return new DatasetIdentifier(uri.getPath(), defaultScheme);
        }
        String name = Optional.of(uri.getPath()).map(DatasetIdentifierUtils::removeLastSlash).map(DatasetIdentifierUtils::removeFirstSlashIfSingleSlashInString).get();
        String namespace = Optional.ofNullable(uri.getAuthority()).map(a -> String.format("%s://%s", uri.getScheme(), a)).orElseGet(() -> uri.getScheme() != null ? uri.getScheme() : defaultScheme);
        return new DatasetIdentifier(name, namespace);
    }

    private static String removeFirstSlashIfSingleSlashInString(String name) {
        if (name.chars().filter(x -> x == 47).count() == 1L && name.startsWith(SEPARATOR)) {
            return name.substring(1);
        }
        return name;
    }

    private static String removeLastSlash(String name) {
        if (name.charAt(name.length() - 1) == '/') {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    private static boolean isAbsoluteAndSchemeAuthorityNull(URI uri) {
        if (uri.getScheme() != null || uri.getAuthority() != null) {
            return false;
        }
        boolean hasWindowsDrive = WINDOWS && HAS_DRIVE_LETTER_SPECIFIER.matcher(uri.getPath()).find();
        int startPositionWithoutWindowsDrive = 0;
        if (hasWindowsDrive) {
            startPositionWithoutWindowsDrive = uri.getPath().charAt(0) == '/' ? 3 : 2;
        }
        return uri.getPath().startsWith(SEPARATOR, startPositionWithoutWindowsDrive);
    }
}

