/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.openlineage.client.ConfigPathProvider;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.OpenLineageYaml;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import lombok.NonNull;

public final class OpenLineageClientUtils {
    private static final ObjectMapper MAPPER = OpenLineageClientUtils.newObjectMapper();
    private static final ObjectMapper YML = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final ObjectMapper JSON = new ObjectMapper(new JsonFactory());

    private OpenLineageClientUtils() {
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public static void configureObjectMapper(String[] disableFacets) {
        if (disableFacets == null) {
            return;
        }
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider().addFilter("disabledFacets", SimpleBeanPropertyFilter.serializeAllExcept((String[])disableFacets));
        MAPPER.setFilterProvider((FilterProvider)simpleFilterProvider);
        MAPPER.addMixIn(Object.class, DisabledFacetsMixin.class);
    }

    public static String toJson(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <T> T fromJson(@NonNull String json, @NonNull TypeReference<T> type) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static OpenLineage.RunEvent runEventFromJson(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return OpenLineageClientUtils.fromJson(json, new TypeReference<OpenLineage.RunEvent>(){});
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T, F> T mergeFacets(Map<String, F> facetsMap, T facetsContainer, Class<T> klass) {
        if (facetsContainer == null) {
            return (T)MAPPER.convertValue(facetsMap, klass);
        }
        Map targetMap = (Map)MAPPER.convertValue(facetsContainer, new TypeReference<Map<String, F>>(){});
        targetMap.putAll(facetsMap);
        return (T)MAPPER.convertValue((Object)targetMap, klass);
    }

    public static URI toUri(@NonNull String urlString) {
        if (urlString == null) {
            throw new NullPointerException("urlString is marked non-null but is null");
        }
        try {
            String urlStringWithNoTrailingSlash = urlString.endsWith("/") ? urlString.substring(0, urlString.length() - 1) : urlString;
            return new URI(urlStringWithNoTrailingSlash);
        }
        catch (URISyntaxException e) {
            OpenLineageClientException error = new OpenLineageClientException("Malformed URI: " + urlString);
            error.initCause(e);
            throw error;
        }
    }

    public static OpenLineageYaml loadOpenLineageYaml(ConfigPathProvider configPathProvider) {
        try {
            for (Path path : configPathProvider.getPaths()) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                return (OpenLineageYaml)YML.readValue(path.toFile(), OpenLineageYaml.class);
            }
            throw new IllegalArgumentException();
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    public static OpenLineageYaml loadOpenLineageYaml(InputStream inputStream) {
        try {
            return (OpenLineageYaml)JSON.readValue(inputStream, OpenLineageYaml.class);
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    @JsonFilter(value="disabledFacets")
    public class DisabledFacetsMixin {
    }
}

