/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.openlineage.client.MergeConfig;
import io.openlineage.client.transports.TransportConfig;
import java.util.Map;
import java.util.Properties;

public final class KafkaConfig
implements TransportConfig,
MergeConfig<KafkaConfig> {
    private String topicName;
    private String messageKey;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Properties properties;

    KafkaConfig() {
        this.properties = new Properties();
    }

    @Deprecated
    String getLocalServerId() {
        return this.messageKey;
    }

    @Deprecated
    void setLocalServerId(String localServerId) {
        this.messageKey = localServerId;
    }

    @Override
    public KafkaConfig mergeWithNonNull(KafkaConfig other) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.mergePropertyWith(this.properties, other.properties));
        return new KafkaConfig(this.mergePropertyWith(this.topicName, other.topicName), this.mergePropertyWith(this.messageKey, other.messageKey), p);
    }

    public String toString() {
        return "KafkaConfig(topicName=" + this.getTopicName() + ", messageKey=" + this.getMessageKey() + ", properties=" + this.getProperties() + ")";
    }

    public KafkaConfig(String topicName, String messageKey, Properties properties) {
        this.topicName = topicName;
        this.messageKey = messageKey;
        this.properties = properties;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

