/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.Transport;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsoleTransport
extends Transport {
    private static final Logger log = LoggerFactory.getLogger(ConsoleTransport.class);

    public ConsoleTransport() {
        super(Transport.Type.CONSOLE);
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(runEvent));
    }

    @Override
    public void emit(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(datasetEvent));
    }

    @Override
    public void emit(@NonNull OpenLineage.JobEvent jobEvent) {
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(jobEvent));
    }

    @Override
    @Deprecated
    public void emit(String eventJson) {
        log.info(eventJson);
    }
}

