/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.micrometer.core.instrument.MeterRegistry;
import io.openlineage.client.ConfigPathProvider;
import io.openlineage.client.DefaultConfigPathProvider;
import io.openlineage.client.Environment;
import io.openlineage.client.OpenLineageClient;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.OpenLineageConfig;
import io.openlineage.client.circuitBreaker.CircuitBreakerFactory;
import io.openlineage.client.metrics.MicrometerProvider;
import io.openlineage.client.transports.NoopTransport;
import io.openlineage.client.transports.Transport;
import io.openlineage.client.transports.TransportFactory;
import java.util.Optional;

public final class Clients {
    private Clients() {
    }

    public static OpenLineageClient newClient() {
        return Clients.newClient(new DefaultConfigPathProvider());
    }

    public static OpenLineageClient newClient(ConfigPathProvider configPathProvider) {
        if (Clients.isDisabled()) {
            return OpenLineageClient.builder().transport(new NoopTransport()).build();
        }
        OpenLineageConfig openLineageConfig = OpenLineageClientUtils.loadOpenLineageConfigYaml(configPathProvider, new TypeReference<OpenLineageConfig>(){});
        return Clients.newClient(openLineageConfig);
    }

    public static OpenLineageClient newClient(OpenLineageConfig openLineageConfig) {
        if (Clients.isDisabled()) {
            return OpenLineageClient.builder().transport(new NoopTransport()).build();
        }
        TransportFactory factory = new TransportFactory(openLineageConfig.getTransportConfig());
        Transport transport = factory.build();
        OpenLineageClient.Builder builder = OpenLineageClient.builder();
        if (openLineageConfig.getFacetsConfig() != null) {
            builder.disableFacets(openLineageConfig.getFacetsConfig().getDisabledFacets());
        }
        Optional.ofNullable(openLineageConfig.getCircuitBreaker()).map(CircuitBreakerFactory::new).ifPresent(f -> builder.circuitBreaker(f.build()));
        Optional.ofNullable(openLineageConfig.getMetricsConfig()).map(MicrometerProvider::addMeterRegistryFromConfig).ifPresent(f -> builder.meterRegistry((MeterRegistry)f));
        return builder.transport(transport).build();
    }

    private static boolean isDisabled() {
        String disabled = Environment.getEnvironmentVariable("OPENLINEAGE_DISABLED");
        return Boolean.parseBoolean(disabled);
    }
}

