/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils;

import io.openlineage.client.utils.DatasetIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);
    public static final String SLASH_DELIMITER_USER_PASSWORD_REGEX = "[A-Za-z0-9_%]+//?[A-Za-z0-9_%]*@";
    public static final String COLON_DELIMITER_USER_PASSWORD_REGEX = "([/|,])[A-Za-z0-9_%]+:?[A-Za-z0-9_%]*@";
    public static final String ALPHANUMERIC = "[A-Za-z0-9]+";

    public static String sanitizeJdbcUrl(String jdbcUrl) {
        return jdbcUrl.replaceFirst("^jdbc:", "").replaceFirst("^postgresql:", "postgres:").replaceAll(SLASH_DELIMITER_USER_PASSWORD_REGEX, "@").replaceAll(COLON_DELIMITER_USER_PASSWORD_REGEX, "$1").replaceAll("(?<=[?,;&:)=])\\(?(?i)(?:user|username|password)=[^;&,)]+(?:[;&;)]|$)", "").replaceAll("\\?.*$", "");
    }

    public static DatasetIdentifier getDatasetIdentifierFromJdbcUrl(String jdbcUrl, String name) {
        List<String> parts = Arrays.stream(name.split("\\.")).collect(Collectors.toList());
        return JdbcUtils.getDatasetIdentifierFromJdbcUrl(jdbcUrl, parts);
    }

    public static DatasetIdentifier getDatasetIdentifierFromJdbcUrl(String jdbcUrl, List<String> parts) {
        String namespace = jdbcUrl = JdbcUtils.sanitizeJdbcUrl(jdbcUrl);
        String urlDatabase = null;
        try {
            URI uri = new URI(jdbcUrl);
            String path = uri.getPath();
            if (path != null) {
                namespace = String.format("%s://%s", uri.getScheme(), uri.getAuthority());
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.length() > 1 && path.matches(ALPHANUMERIC)) {
                    urlDatabase = path;
                }
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        if (urlDatabase != null && parts.size() <= 3) {
            parts.add(0, urlDatabase);
        }
        String name = String.join((CharSequence)".", parts);
        return new DatasetIdentifier(name, namespace);
    }
}

