/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.transports.TokenProvider;
import io.openlineage.client.transports.TransportConfig;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;

public final class HttpConfig
implements TransportConfig {
    private URI url;
    @Nullable
    private String endpoint;
    @Nullable
    private Double timeout;
    @Nullable
    private Integer timeoutInMillis;
    @Nullable
    private TokenProvider auth;
    @Nullable
    private Map<String, String> urlParams;
    @Nullable
    private Map<String, String> headers;

    public HttpConfig() {
    }

    public HttpConfig(URI url, @Nullable String endpoint, @Nullable Double timeout, @Nullable Integer timeoutInMillis, @Nullable TokenProvider auth, @Nullable Map<String, String> urlParams, @Nullable Map<String, String> headers) {
        this.url = url;
        this.endpoint = endpoint;
        this.timeout = timeout;
        this.timeoutInMillis = timeoutInMillis;
        this.auth = auth;
        this.urlParams = urlParams;
        this.headers = headers;
    }

    public String toString() {
        return "HttpConfig(url=" + this.getUrl() + ", endpoint=" + this.getEndpoint() + ", timeout=" + this.getTimeout() + ", timeoutInMillis=" + this.getTimeoutInMillis() + ", auth=" + this.getAuth() + ", urlParams=" + this.getUrlParams() + ", headers=" + this.getHeaders() + ")";
    }

    public HttpConfig withUrl(URI url) {
        return this.url == url ? this : new HttpConfig(url, this.endpoint, this.timeout, this.timeoutInMillis, this.auth, this.urlParams, this.headers);
    }

    public HttpConfig withEndpoint(@Nullable String endpoint) {
        return this.endpoint == endpoint ? this : new HttpConfig(this.url, endpoint, this.timeout, this.timeoutInMillis, this.auth, this.urlParams, this.headers);
    }

    public HttpConfig withTimeout(@Nullable Double timeout) {
        return this.timeout == timeout ? this : new HttpConfig(this.url, this.endpoint, timeout, this.timeoutInMillis, this.auth, this.urlParams, this.headers);
    }

    public HttpConfig withTimeoutInMillis(@Nullable Integer timeoutInMillis) {
        return this.timeoutInMillis == timeoutInMillis ? this : new HttpConfig(this.url, this.endpoint, this.timeout, timeoutInMillis, this.auth, this.urlParams, this.headers);
    }

    public HttpConfig withAuth(@Nullable TokenProvider auth) {
        return this.auth == auth ? this : new HttpConfig(this.url, this.endpoint, this.timeout, this.timeoutInMillis, auth, this.urlParams, this.headers);
    }

    public HttpConfig withUrlParams(@Nullable Map<String, String> urlParams) {
        return this.urlParams == urlParams ? this : new HttpConfig(this.url, this.endpoint, this.timeout, this.timeoutInMillis, this.auth, urlParams, this.headers);
    }

    public HttpConfig withHeaders(@Nullable Map<String, String> headers) {
        return this.headers == headers ? this : new HttpConfig(this.url, this.endpoint, this.timeout, this.timeoutInMillis, this.auth, this.urlParams, headers);
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    @Nullable
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
    }

    @Nullable
    public Double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Double timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public Integer getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public void setTimeoutInMillis(@Nullable Integer timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    @Nullable
    public TokenProvider getAuth() {
        return this.auth;
    }

    public void setAuth(@Nullable TokenProvider auth) {
        this.auth = auth;
    }

    @Nullable
    public Map<String, String> getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(@Nullable Map<String, String> urlParams) {
        this.urlParams = urlParams;
    }

    @Nullable
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(@Nullable Map<String, String> headers) {
        this.headers = headers;
    }
}

