/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.openlineage.client.circuitBreaker.CircuitBreakerState;
import io.openlineage.client.circuitBreaker.ExecutorCircuitBreaker;
import io.openlineage.client.circuitBreaker.RuntimeUtils;
import io.openlineage.client.circuitBreaker.SimpleMemoryCircuitBreakerConfig;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMemoryCircuitBreaker
extends ExecutorCircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(SimpleMemoryCircuitBreaker.class);
    private final SimpleMemoryCircuitBreakerConfig config;

    public SimpleMemoryCircuitBreaker(@NonNull SimpleMemoryCircuitBreakerConfig config) {
        super(config.getCircuitCheckIntervalInMillis());
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    @Override
    public CircuitBreakerState currentState() {
        if (!this.isPercentageValueValid(this.config.getMemoryThreshold())) {
            log.warn("Invalid memory threshold configured {}", (Object)this.config.getMemoryThreshold());
            return new CircuitBreakerState(false);
        }
        double percentageFreeMemory = 100.0 * ((double)(RuntimeUtils.freeMemory() + (RuntimeUtils.maxMemory() - RuntimeUtils.totalMemory())) / (double)RuntimeUtils.maxMemory());
        int freeMemoryThreshold = this.config.getMemoryThreshold();
        log.debug("Circuit breaker: percentage free memory {}%  (freeMemoryThreshold {})", (Object)percentageFreeMemory, (Object)freeMemoryThreshold);
        if (percentageFreeMemory <= (double)freeMemoryThreshold) {
            String reason = String.format("Circuit breaker tripped at memory %.2f%% (freeMemoryThreshold %d%%)", percentageFreeMemory, freeMemoryThreshold);
            return new CircuitBreakerState(true, reason);
        }
        return new CircuitBreakerState(false);
    }
}

