/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.openlineage.client.circuitBreaker.CircuitBreakerConfig;

public final class JavaRuntimeCircuitBreakerConfig
implements CircuitBreakerConfig {
    private Integer memoryThreshold = 20;
    private Integer gcCpuThreshold = 10;
    private Integer circuitCheckIntervalInMillis = 1000;

    public JavaRuntimeCircuitBreakerConfig(int memoryThreshold, int gcCpuThreshold) {
        this(memoryThreshold, gcCpuThreshold, 1000);
    }

    public JavaRuntimeCircuitBreakerConfig() {
    }

    public JavaRuntimeCircuitBreakerConfig(Integer memoryThreshold, Integer gcCpuThreshold, Integer circuitCheckIntervalInMillis) {
        this.memoryThreshold = memoryThreshold;
        this.gcCpuThreshold = gcCpuThreshold;
        this.circuitCheckIntervalInMillis = circuitCheckIntervalInMillis;
    }

    public String toString() {
        return "JavaRuntimeCircuitBreakerConfig(memoryThreshold=" + this.getMemoryThreshold() + ", gcCpuThreshold=" + this.getGcCpuThreshold() + ", circuitCheckIntervalInMillis=" + this.getCircuitCheckIntervalInMillis() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaRuntimeCircuitBreakerConfig)) {
            return false;
        }
        JavaRuntimeCircuitBreakerConfig other = (JavaRuntimeCircuitBreakerConfig)o;
        Integer this$memoryThreshold = this.getMemoryThreshold();
        Integer other$memoryThreshold = other.getMemoryThreshold();
        if (this$memoryThreshold == null ? other$memoryThreshold != null : !((Object)this$memoryThreshold).equals(other$memoryThreshold)) {
            return false;
        }
        Integer this$gcCpuThreshold = this.getGcCpuThreshold();
        Integer other$gcCpuThreshold = other.getGcCpuThreshold();
        if (this$gcCpuThreshold == null ? other$gcCpuThreshold != null : !((Object)this$gcCpuThreshold).equals(other$gcCpuThreshold)) {
            return false;
        }
        Integer this$circuitCheckIntervalInMillis = this.getCircuitCheckIntervalInMillis();
        Integer other$circuitCheckIntervalInMillis = other.getCircuitCheckIntervalInMillis();
        return !(this$circuitCheckIntervalInMillis == null ? other$circuitCheckIntervalInMillis != null : !((Object)this$circuitCheckIntervalInMillis).equals(other$circuitCheckIntervalInMillis));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $memoryThreshold = this.getMemoryThreshold();
        result = result * 59 + ($memoryThreshold == null ? 43 : ((Object)$memoryThreshold).hashCode());
        Integer $gcCpuThreshold = this.getGcCpuThreshold();
        result = result * 59 + ($gcCpuThreshold == null ? 43 : ((Object)$gcCpuThreshold).hashCode());
        Integer $circuitCheckIntervalInMillis = this.getCircuitCheckIntervalInMillis();
        result = result * 59 + ($circuitCheckIntervalInMillis == null ? 43 : ((Object)$circuitCheckIntervalInMillis).hashCode());
        return result;
    }

    public JavaRuntimeCircuitBreakerConfig withMemoryThreshold(Integer memoryThreshold) {
        return this.memoryThreshold == memoryThreshold ? this : new JavaRuntimeCircuitBreakerConfig(memoryThreshold, this.gcCpuThreshold, this.circuitCheckIntervalInMillis);
    }

    public JavaRuntimeCircuitBreakerConfig withGcCpuThreshold(Integer gcCpuThreshold) {
        return this.gcCpuThreshold == gcCpuThreshold ? this : new JavaRuntimeCircuitBreakerConfig(this.memoryThreshold, gcCpuThreshold, this.circuitCheckIntervalInMillis);
    }

    public JavaRuntimeCircuitBreakerConfig withCircuitCheckIntervalInMillis(Integer circuitCheckIntervalInMillis) {
        return this.circuitCheckIntervalInMillis == circuitCheckIntervalInMillis ? this : new JavaRuntimeCircuitBreakerConfig(this.memoryThreshold, this.gcCpuThreshold, circuitCheckIntervalInMillis);
    }

    public Integer getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(Integer memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public Integer getGcCpuThreshold() {
        return this.gcCpuThreshold;
    }

    public void setGcCpuThreshold(Integer gcCpuThreshold) {
        this.gcCpuThreshold = gcCpuThreshold;
    }

    public Integer getCircuitCheckIntervalInMillis() {
        return this.circuitCheckIntervalInMillis;
    }

    public void setCircuitCheckIntervalInMillis(Integer circuitCheckIntervalInMillis) {
        this.circuitCheckIntervalInMillis = circuitCheckIntervalInMillis;
    }
}

