/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.openlineage.client.circuitBreaker.CircuitBreakerState;
import io.openlineage.client.circuitBreaker.ExecutorCircuitBreaker;
import io.openlineage.client.circuitBreaker.JavaRuntimeCircuitBreakerConfig;
import io.openlineage.client.circuitBreaker.RuntimeUtils;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRuntimeCircuitBreaker
extends ExecutorCircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(JavaRuntimeCircuitBreaker.class);
    private volatile GarbageCollectorMXBean oldGenGCBeanCached = null;
    private final JavaRuntimeCircuitBreakerConfig config;
    private final ThreadLocal<Long> lastTotalGCTimeNS = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return JavaRuntimeCircuitBreaker.this.getGCCpuTimeNS();
        }
    };
    private final ThreadLocal<Long> lastTimestampInNanoseconds = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return System.nanoTime();
        }
    };

    public JavaRuntimeCircuitBreaker(@NonNull JavaRuntimeCircuitBreakerConfig config) {
        super(config.getCircuitCheckIntervalInMillis());
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    @Override
    public CircuitBreakerState currentState() {
        if (!this.isPercentageValueValid(this.config.getMemoryThreshold()) || !this.isPercentageValueValid(this.config.getGcCpuThreshold())) {
            log.warn("Invalid memory threshold configured {}", (Object)this.config.getMemoryThreshold());
            return new CircuitBreakerState(false);
        }
        long currentTimeInNanoseconds = System.nanoTime();
        long gcCpuTime = this.getGCCpuTimeNS() - this.lastTotalGCTimeNS.get();
        long elapsedTime = currentTimeInNanoseconds - this.lastTimestampInNanoseconds.get();
        double gcCpuTimePercentage = (double)gcCpuTime / (double)elapsedTime * 100.0;
        if (elapsedTime <= 0L) {
            this.lastTimestampInNanoseconds.set(currentTimeInNanoseconds);
            this.lastTotalGCTimeNS.set(gcCpuTime);
            return new CircuitBreakerState(false);
        }
        double percentageFreeMemory = 100.0 * ((double)(RuntimeUtils.freeMemory() + (RuntimeUtils.maxMemory() - RuntimeUtils.totalMemory())) / (double)RuntimeUtils.maxMemory());
        this.lastTimestampInNanoseconds.set(currentTimeInNanoseconds);
        this.lastTotalGCTimeNS.set(this.lastTotalGCTimeNS.get() + gcCpuTime);
        int freeMemoryThreshold = this.config.getMemoryThreshold();
        int gcCPUThreshold = this.config.getGcCpuThreshold();
        String reason = String.format("Circuit breaker tripped at memory %.2f%%  GC CPU time %.2f%% (freeMemoryThreshold %d%%, gcCPUThreshold %d%%)", percentageFreeMemory, gcCpuTimePercentage, freeMemoryThreshold, gcCPUThreshold);
        log.debug(reason);
        if (gcCpuTimePercentage >= (double)gcCPUThreshold && percentageFreeMemory <= (double)freeMemoryThreshold) {
            return new CircuitBreakerState(true, reason);
        }
        return new CircuitBreakerState(false);
    }

    private long getGCCpuTimeNS() {
        return TimeUnit.NANOSECONDS.convert(this.getOldGenGCBean().getCollectionTime(), TimeUnit.MILLISECONDS);
    }

    private long getGCCount() {
        long gcCpuCount = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectorCount = gcBean.getCollectionCount();
            if (collectorCount == -1L) continue;
            gcCpuCount += gcBean.getCollectionCount();
        }
        return gcCpuCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GarbageCollectorMXBean getOldGenGCBean() {
        if (null != this.oldGenGCBeanCached) {
            return this.oldGenGCBeanCached;
        }
        JavaRuntimeCircuitBreaker javaRuntimeCircuitBreaker = this;
        synchronized (javaRuntimeCircuitBreaker) {
            if (null != this.oldGenGCBeanCached) {
                return this.oldGenGCBeanCached;
            }
            MemoryManagerMXBean lowestGCCountBean = null;
            log.debug("Circuit breaker: looking for old gen gc bean");
            boolean tie = false;
            long totalGCs = this.getGCCount();
            for (GarbageCollectorMXBean gcBean : RuntimeUtils.getGarbageCollectorMXBeans()) {
                log.debug("Circuit breaker: checking {0}", (Object)gcBean.getName());
                if (null == lowestGCCountBean || lowestGCCountBean.getCollectionCount() > gcBean.getCollectionCount()) {
                    tie = false;
                    lowestGCCountBean = gcBean;
                    continue;
                }
                if (lowestGCCountBean.getCollectionCount() != gcBean.getCollectionCount()) continue;
                tie = true;
            }
            if (this.getGCCount() == totalGCs && !tie) {
                log.debug("Circuit breaker: found and cached oldGenGCBean: {0}", (Object)lowestGCCountBean.getName());
                this.oldGenGCBeanCached = lowestGCCountBean;
                return this.oldGenGCBeanCached;
            }
            log.debug("Circuit breaker: unable to find oldGenGCBean. Best guess: {0}", (Object)lowestGCCountBean.getName());
            return lowestGCCountBean;
        }
    }
}

