/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.openlineage.client.circuitBreaker.CircuitBreaker;
import io.openlineage.client.circuitBreaker.CircuitBreakerState;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutorCircuitBreaker
implements CircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(ExecutorCircuitBreaker.class);
    private Integer circuitCheckIntervalInMillis;

    public ExecutorCircuitBreaker(Integer circuitCheckIntervalInMillis) {
        this.circuitCheckIntervalInMillis = circuitCheckIntervalInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Callable<T> callable) {
        T result;
        if (this.currentState().isClosed()) {
            log.warn("CircuitBreaker closed preventing callable to be run: {}", (Object)this);
            return null;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        Future futureOpenLineage = executor.submit(callable);
        Future<Object> futureCircuitBreaker = executor.submit(() -> {
            log.debug("Starting CircuitBreaker in background {} with interval {}", (Object)this, (Object)this.getCheckIntervalMillis());
            CircuitBreakerState circuitBreakerState = this.currentState();
            while (!circuitBreakerState.isClosed()) {
                Thread.sleep(this.getCheckIntervalMillis());
                circuitBreakerState = this.currentState();
            }
            log.warn("CircuitBreaker cancelling OpenLineage code: " + circuitBreakerState.getReason());
            futureOpenLineage.cancel(true);
            return null;
        });
        try {
            result = futureOpenLineage.get();
            log.debug("Callable successfully executed. Stopping CircuitBreaker.");
            futureCircuitBreaker.cancel(true);
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            futureOpenLineage.cancel(true);
            futureCircuitBreaker.cancel(true);
            log.warn("Got error in run callable: {}", (Object)e.getMessage(), (Object)e.getCause());
            executor.shutdownNow();
            T t = null;
            return t;
        }
        finally {
            executor.shutdownNow();
        }
        return result;
    }

    @Override
    public int getCheckIntervalMillis() {
        return this.circuitCheckIntervalInMillis;
    }

    protected boolean isPercentageValueValid(Integer value) {
        return value != null && value >= 0 && value <= 100;
    }
}

